/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;

public class OutputClause {
    List<SelectItem> selectItemList;
    UserVariable tableVariable;
    Table outputTable;
    List<String> columnList;

    public OutputClause(List<SelectItem> selectItemList, UserVariable tableVariable, Table outputTable, List<String> columnList) {
        this.selectItemList = Objects.requireNonNull(selectItemList, "The Select List of the Output Clause must not be null.");
        this.tableVariable = tableVariable;
        this.outputTable = outputTable;
        this.columnList = columnList;
    }

    public List<SelectItem> getSelectItemList() {
        return this.selectItemList;
    }

    public void setSelectItemList(List<SelectItem> selectItemList) {
        this.selectItemList = selectItemList;
    }

    public UserVariable getTableVariable() {
        return this.tableVariable;
    }

    public void setTableVariable(UserVariable tableVariable) {
        this.tableVariable = tableVariable;
    }

    public Table getOutputTable() {
        return this.outputTable;
    }

    public void setOutputTable(Table outputTable) {
        this.outputTable = outputTable;
    }

    public List<String> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(List<String> columnList) {
        this.columnList = columnList;
    }

    public StringBuilder appendTo(StringBuilder builder2) {
        builder2.append(" OUTPUT ");
        PlainSelect.appendStringListTo(builder2, this.selectItemList, true, false);
        if (this.tableVariable != null) {
            builder2.append(" INTO ").append(this.tableVariable);
        } else if (this.outputTable != null) {
            builder2.append(" INTO ").append(this.outputTable);
        }
        PlainSelect.appendStringListTo(builder2, this.columnList, true, false);
        return builder2.append(" ");
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

