/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class OracleNamedFunctionParameter
extends ASTNodeAccessImpl
implements Expression {
    private final String name;
    private final Expression expression;

    public OracleNamedFunctionParameter(String name, Expression expression) {
        this.name = Objects.requireNonNull(name, "The NAME of the OracleNamedFunctionParameter must not be null.");
        this.expression = Objects.requireNonNull(expression, "The EXPRESSION of the OracleNamedFunctionParameter must not be null.");
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public StringBuilder appendTo(StringBuilder builder2) {
        builder2.append(this.name).append(" => ").append(this.expression);
        return builder2;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

