/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.JsonAggregateOnNullType;
import net.sf.jsqlparser.expression.JsonAggregateUniqueKeysType;
import net.sf.jsqlparser.expression.JsonFunctionExpression;
import net.sf.jsqlparser.expression.JsonFunctionType;
import net.sf.jsqlparser.expression.JsonKeyValuePair;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class JsonFunction
extends ASTNodeAccessImpl
implements Expression {
    private JsonFunctionType functionType;
    private final ArrayList<JsonKeyValuePair> keyValuePairs = new ArrayList();
    private final ArrayList<JsonFunctionExpression> expressions = new ArrayList();
    private JsonAggregateOnNullType onNullType;
    private JsonAggregateUniqueKeysType uniqueKeysType;

    public ArrayList<JsonKeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public ArrayList<JsonFunctionExpression> getExpressions() {
        return this.expressions;
    }

    public JsonKeyValuePair getKeyValuePair(int i) {
        return this.keyValuePairs.get(i);
    }

    public JsonFunctionExpression getExpression(int i) {
        return this.expressions.get(i);
    }

    public boolean add(JsonKeyValuePair keyValuePair) {
        return this.keyValuePairs.add(keyValuePair);
    }

    public void add(int i, JsonKeyValuePair keyValuePair) {
        this.keyValuePairs.add(i, keyValuePair);
    }

    public boolean add(JsonFunctionExpression expression) {
        return this.expressions.add(expression);
    }

    public void add(int i, JsonFunctionExpression expression) {
        this.expressions.add(i, expression);
    }

    public boolean isEmpty() {
        return this.keyValuePairs.isEmpty();
    }

    public JsonAggregateOnNullType getOnNullType() {
        return this.onNullType;
    }

    public void setOnNullType(JsonAggregateOnNullType onNullType) {
        this.onNullType = onNullType;
    }

    public JsonFunction withOnNullType(JsonAggregateOnNullType onNullType) {
        this.setOnNullType(onNullType);
        return this;
    }

    public JsonAggregateUniqueKeysType getUniqueKeysType() {
        return this.uniqueKeysType;
    }

    public void setUniqueKeysType(JsonAggregateUniqueKeysType uniqueKeysType) {
        this.uniqueKeysType = uniqueKeysType;
    }

    public JsonFunction withUniqueKeysType(JsonAggregateUniqueKeysType uniqueKeysType) {
        this.setUniqueKeysType(uniqueKeysType);
        return this;
    }

    public JsonFunctionType getType() {
        return this.functionType;
    }

    public void setType(JsonFunctionType type2) {
        this.functionType = Objects.requireNonNull(type2, "The Type of the JSON Aggregate Function must not be null");
    }

    public JsonFunction withType(JsonFunctionType type2) {
        this.setType(type2);
        return this;
    }

    public void setType(String typeName) {
        this.functionType = JsonFunctionType.valueOf(Objects.requireNonNull(typeName, "The Type of the JSON Aggregate Function must not be null").toUpperCase());
    }

    public JsonFunction withType(String typeName) {
        this.setType(typeName);
        return this;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public StringBuilder append(StringBuilder builder2) {
        switch (this.functionType) {
            case OBJECT: {
                this.appendObject(builder2);
                break;
            }
            case POSTGRES_OBJECT: {
                this.appendPostgresObject(builder2);
                break;
            }
            case MYSQL_OBJECT: {
                this.appendMySqlObject(builder2);
                break;
            }
            case ARRAY: {
                this.appendArray(builder2);
                break;
            }
        }
        return builder2;
    }

    public StringBuilder appendObject(StringBuilder builder2) {
        builder2.append("JSON_OBJECT( ");
        int i = 0;
        for (JsonKeyValuePair keyValuePair : this.keyValuePairs) {
            if (i > 0) {
                builder2.append(", ");
            }
            if (keyValuePair.isUsingValueKeyword()) {
                if (keyValuePair.isUsingKeyKeyword()) {
                    builder2.append("KEY ");
                }
                builder2.append(keyValuePair.getKey()).append(" VALUE ").append(keyValuePair.getValue());
            } else {
                builder2.append(keyValuePair.getKey()).append(":").append(keyValuePair.getValue());
            }
            if (keyValuePair.isUsingFormatJson()) {
                builder2.append(" FORMAT JSON");
            }
            ++i;
        }
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    builder2.append(" NULL ON NULL");
                    break;
                }
                case ABSENT: {
                    builder2.append(" ABSENT On NULL");
                    break;
                }
            }
        }
        if (this.uniqueKeysType != null) {
            switch (this.uniqueKeysType) {
                case WITH: {
                    builder2.append(" WITH UNIQUE KEYS");
                    break;
                }
                case WITHOUT: {
                    builder2.append(" WITHOUT UNIQUE KEYS");
                    break;
                }
            }
        }
        builder2.append(" ) ");
        return builder2;
    }

    public StringBuilder appendPostgresObject(StringBuilder builder2) {
        builder2.append("JSON_OBJECT( ");
        for (JsonKeyValuePair keyValuePair : this.keyValuePairs) {
            builder2.append(keyValuePair.getKey());
            if (keyValuePair.getValue() == null) continue;
            builder2.append(", ").append(keyValuePair.getValue());
        }
        builder2.append(" ) ");
        return builder2;
    }

    public StringBuilder appendMySqlObject(StringBuilder builder2) {
        builder2.append("JSON_OBJECT( ");
        int i = 0;
        for (JsonKeyValuePair keyValuePair : this.keyValuePairs) {
            if (i > 0) {
                builder2.append(", ");
            }
            builder2.append(keyValuePair.getKey());
            builder2.append(", ").append(keyValuePair.getValue());
            ++i;
        }
        builder2.append(" ) ");
        return builder2;
    }

    public StringBuilder appendArray(StringBuilder builder2) {
        builder2.append("JSON_ARRAY( ");
        int i = 0;
        for (JsonFunctionExpression expr : this.expressions) {
            if (i > 0) {
                builder2.append(", ");
            }
            expr.append(builder2);
            ++i;
        }
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    builder2.append(" NULL ON NULL ");
                    break;
                }
                case ABSENT: {
                    builder2.append(" ABSENT ON NULL ");
                    break;
                }
            }
        }
        builder2.append(") ");
        return builder2;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        return this.append(builder2).toString();
    }
}

