/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.AbstractTimeSource;
import kotlinx.coroutines.AbstractTimeSourceKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.DefaultExecutor;
import kotlinx.coroutines.Delay;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.DisposableFutureHandle;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.ResumeUndispatchedRunnable;
import kotlinx.coroutines.internal.ConcurrentKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0016J\u001c\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J.\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#*\u00020$2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lkotlinx/coroutines/ExecutorCoroutineDispatcherImpl;", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "Lkotlinx/coroutines/Delay;", "executor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "getExecutor", "()Ljava/util/concurrent/Executor;", "cancelJobOnRejection", "", "context", "Lkotlin/coroutines/CoroutineContext;", "exception", "Ljava/util/concurrent/RejectedExecutionException;", "close", "dispatch", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "equals", "", "other", "", "hashCode", "", "invokeOnTimeout", "Lkotlinx/coroutines/DisposableHandle;", "timeMillis", "", "scheduleResumeAfterDelay", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "toString", "", "scheduleBlock", "Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlinx-coroutines-core"})
public final class ExecutorCoroutineDispatcherImpl
extends ExecutorCoroutineDispatcher
implements Delay {
    @NotNull
    private final Executor executor;

    public ExecutorCoroutineDispatcherImpl(@NotNull Executor executor) {
        this.executor = executor;
        ConcurrentKt.removeFutureOnCancel(this.getExecutor());
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context2, @NotNull Runnable block2) {
        try {
            Executor executor = this.getExecutor();
            Object object = AbstractTimeSourceKt.getTimeSource();
            if (object == null || (object = ((AbstractTimeSource)object).wrapTask(block2)) == null) {
                object = block2;
            }
            executor.execute((Runnable)object);
        }
        catch (RejectedExecutionException e) {
            AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.getTimeSource();
            if (abstractTimeSource != null) {
                abstractTimeSource.unTrackTask();
            }
            this.cancelJobOnRejection(context2, e);
            Dispatchers.getIO().dispatch(context2, block2);
        }
    }

    @Override
    public void scheduleResumeAfterDelay(long timeMillis, @NotNull CancellableContinuation<? super Unit> continuation2) {
        ScheduledFuture<?> future;
        Executor executor = this.getExecutor();
        ScheduledExecutorService scheduledExecutorService = executor instanceof ScheduledExecutorService ? (ScheduledExecutorService)executor : null;
        ScheduledFuture<?> scheduledFuture = future = scheduledExecutorService != null ? this.scheduleBlock(scheduledExecutorService, new ResumeUndispatchedRunnable(this, continuation2), continuation2.getContext(), timeMillis) : null;
        if (future != null) {
            JobKt.cancelFutureOnCancellation(continuation2, (Future)future);
            return;
        }
        DefaultExecutor.INSTANCE.scheduleResumeAfterDelay(timeMillis, continuation2);
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long timeMillis, @NotNull Runnable block2, @NotNull CoroutineContext context2) {
        Executor executor = this.getExecutor();
        ScheduledExecutorService scheduledExecutorService = executor instanceof ScheduledExecutorService ? (ScheduledExecutorService)executor : null;
        ScheduledFuture<?> future = scheduledExecutorService != null ? this.scheduleBlock(scheduledExecutorService, block2, context2, timeMillis) : null;
        return future != null ? (DisposableHandle)new DisposableFutureHandle((Future)future) : DefaultExecutor.INSTANCE.invokeOnTimeout(timeMillis, block2, context2);
    }

    private final ScheduledFuture<?> scheduleBlock(ScheduledExecutorService $this$scheduleBlock, Runnable block2, CoroutineContext context2, long timeMillis) {
        ScheduledFuture<?> scheduledFuture;
        try {
            scheduledFuture = $this$scheduleBlock.schedule(block2, timeMillis, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.cancelJobOnRejection(context2, e);
            scheduledFuture = null;
        }
        return scheduledFuture;
    }

    private final void cancelJobOnRejection(CoroutineContext context2, RejectedExecutionException exception) {
        JobKt.cancel(context2, ExceptionsKt.CancellationException("The task was rejected", exception));
    }

    @Override
    public void close() {
        block0: {
            Executor executor = this.getExecutor();
            ExecutorService executorService = executor instanceof ExecutorService ? (ExecutorService)executor : null;
            if (executorService == null) break block0;
            executorService.shutdown();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.getExecutor().toString();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ExecutorCoroutineDispatcherImpl && ((ExecutorCoroutineDispatcherImpl)other).getExecutor() == this.getExecutor();
    }

    public int hashCode() {
        return System.identityHashCode(this.getExecutor());
    }

    @Override
    @Deprecated(message="Deprecated without replacement as an internal method never intended for public use", level=DeprecationLevel.ERROR)
    @Nullable
    public Object delay(long time, @NotNull Continuation<? super Unit> $completion) {
        return Delay.DefaultImpls.delay(this, time, $completion);
    }
}

