/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import java.util.Comparator;

public final class ObjectHeaps {
    private ObjectHeaps() {
    }

    public static <K> int downHeap(K[] heap, int size2, int i, Comparator<? super K> c) {
        assert (i < size2);
        K e = heap[i];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                K t = heap[child];
                int right = child + 1;
                if (right < size2 && ((Comparable)heap[right]).compareTo(t) < 0) {
                    child = right;
                    t = heap[child];
                }
                if (((Comparable)e).compareTo(t) > 0) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                K t = heap[child];
                int right = child + 1;
                if (right < size2 && c.compare(heap[right], t) < 0) {
                    child = right;
                    t = heap[child];
                }
                if (c.compare(e, t) > 0) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static <K> int upHeap(K[] heap, int size2, int i, Comparator<K> c) {
        assert (i < size2);
        K e = heap[i];
        if (c == null) {
            int parent;
            K t;
            while (i != 0 && ((Comparable)(t = heap[parent = i - 1 >>> 1])).compareTo(e) > 0) {
                heap[i] = t;
                i = parent;
            }
        } else {
            int parent;
            K t;
            while (i != 0 && c.compare(t = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t;
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static <K> void makeHeap(K[] heap, int size2, Comparator<K> c) {
        int i = size2 >>> 1;
        while (i-- != 0) {
            ObjectHeaps.downHeap(heap, size2, i, c);
        }
    }
}

