/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectIndirectHeaps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class ObjectHeapIndirectPriorityQueue<K>
extends ObjectHeapSemiIndirectPriorityQueue<K> {
    protected final int[] inv;

    public ObjectHeapIndirectPriorityQueue(K[] refArray, int capacity, Comparator<? super K> c) {
        super(refArray, capacity, c);
        this.inv = new int[refArray.length];
        Arrays.fill(this.inv, -1);
    }

    public ObjectHeapIndirectPriorityQueue(K[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public ObjectHeapIndirectPriorityQueue(K[] refArray, Comparator<? super K> c) {
        this(refArray, refArray.length, c);
    }

    public ObjectHeapIndirectPriorityQueue(K[] refArray) {
        this(refArray, refArray.length, null);
    }

    public ObjectHeapIndirectPriorityQueue(K[] refArray, int[] a, int size2, Comparator<? super K> c) {
        this(refArray, 0, c);
        this.heap = a;
        this.size = size2;
        int i = size2;
        while (i-- != 0) {
            if (this.inv[a[i]] != -1) {
                throw new IllegalArgumentException("Index " + a[i] + " appears twice in the heap");
            }
            this.inv[a[i]] = i;
        }
        ObjectIndirectHeaps.makeHeap(refArray, a, this.inv, size2, c);
    }

    public ObjectHeapIndirectPriorityQueue(K[] refArray, int[] a, Comparator<? super K> c) {
        this(refArray, a, a.length, c);
    }

    public ObjectHeapIndirectPriorityQueue(K[] refArray, int[] a, int size2) {
        this(refArray, a, size2, null);
    }

    public ObjectHeapIndirectPriorityQueue(K[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    @Override
    public void enqueue(int x) {
        if (this.inv[x] >= 0) {
            throw new IllegalArgumentException("Index " + x + " belongs to the queue");
        }
        if (this.size == this.heap.length) {
            this.heap = IntArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size] = x;
        this.inv[this.heap[this.size]] = this.size++;
        ObjectIndirectHeaps.upHeap(this.refArray, this.heap, this.inv, this.size, this.size - 1, this.c);
    }

    @Override
    public boolean contains(int index) {
        return this.inv[index] >= 0;
    }

    @Override
    public int dequeue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int result2 = this.heap[0];
        if (--this.size != 0) {
            this.heap[0] = this.heap[this.size];
            this.inv[this.heap[0]] = 0;
        }
        this.inv[result2] = -1;
        if (this.size != 0) {
            ObjectIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, 0, this.c);
        }
        return result2;
    }

    @Override
    public void changed() {
        ObjectIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, 0, this.c);
    }

    @Override
    public void changed(int index) {
        int pos = this.inv[index];
        if (pos < 0) {
            throw new IllegalArgumentException("Index " + index + " does not belong to the queue");
        }
        int newPos = ObjectIndirectHeaps.upHeap(this.refArray, this.heap, this.inv, this.size, pos, this.c);
        ObjectIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, newPos, this.c);
    }

    @Override
    public void allChanged() {
        ObjectIndirectHeaps.makeHeap(this.refArray, this.heap, this.inv, this.size, this.c);
    }

    @Override
    public boolean remove(int index) {
        int result2 = this.inv[index];
        if (result2 < 0) {
            return false;
        }
        this.inv[index] = -1;
        if (result2 < --this.size) {
            this.heap[result2] = this.heap[this.size];
            this.inv[this.heap[result2]] = result2;
            int newPos = ObjectIndirectHeaps.upHeap(this.refArray, this.heap, this.inv, this.size, result2, this.c);
            ObjectIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, newPos, this.c);
        }
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.inv, -1);
    }
}

