/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.NIOKt;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputPrimitivesKt;
import io.ktor.websocket.CloseReason;
import io.ktor.websocket.FrameType;
import io.ktor.websocket.NonDisposableHandle;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DisposableHandle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \"2\u00020\u0001:\u0006 !\"#$%BG\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001d\u001a\u00020\u0000J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017\u0082\u0001\u0005&'()*\u00a8\u0006+"}, d2={"Lio/ktor/websocket/Frame;", "", "fin", "", "frameType", "Lio/ktor/websocket/FrameType;", "data", "", "disposableHandle", "Lkotlinx/coroutines/DisposableHandle;", "rsv1", "rsv2", "rsv3", "(ZLio/ktor/websocket/FrameType;[BLkotlinx/coroutines/DisposableHandle;ZZZ)V", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "getData", "()[B", "getDisposableHandle", "()Lkotlinx/coroutines/DisposableHandle;", "getFin", "()Z", "getFrameType", "()Lio/ktor/websocket/FrameType;", "getRsv1", "getRsv2", "getRsv3", "copy", "toString", "", "Binary", "Close", "Companion", "Ping", "Pong", "Text", "Lio/ktor/websocket/Frame$Binary;", "Lio/ktor/websocket/Frame$Text;", "Lio/ktor/websocket/Frame$Close;", "Lio/ktor/websocket/Frame$Ping;", "Lio/ktor/websocket/Frame$Pong;", "ktor-websockets"})
public abstract class Frame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean fin;
    @NotNull
    private final FrameType frameType;
    @NotNull
    private final byte[] data;
    @NotNull
    private final DisposableHandle disposableHandle;
    private final boolean rsv1;
    private final boolean rsv2;
    private final boolean rsv3;
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private static final byte[] Empty = new byte[0];

    private Frame(boolean fin, FrameType frameType, byte[] data2, DisposableHandle disposableHandle, boolean rsv1, boolean rsv2, boolean rsv3) {
        this.fin = fin;
        this.frameType = frameType;
        this.data = data2;
        this.disposableHandle = disposableHandle;
        this.rsv1 = rsv1;
        this.rsv2 = rsv2;
        this.rsv3 = rsv3;
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(data)");
        this.buffer = byteBuffer;
    }

    public /* synthetic */ Frame(boolean bl, FrameType frameType, byte[] byArray, DisposableHandle disposableHandle, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            disposableHandle = NonDisposableHandle.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            bl4 = false;
        }
        this(bl, frameType, byArray, disposableHandle, bl2, bl3, bl4, null);
    }

    public final boolean getFin() {
        return this.fin;
    }

    @NotNull
    public final FrameType getFrameType() {
        return this.frameType;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @NotNull
    public final DisposableHandle getDisposableHandle() {
        return this.disposableHandle;
    }

    public final boolean getRsv1() {
        return this.rsv1;
    }

    public final boolean getRsv2() {
        return this.rsv2;
    }

    public final boolean getRsv3() {
        return this.rsv3;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @NotNull
    public String toString() {
        return "Frame " + (Object)((Object)this.frameType) + " (fin=" + this.fin + ", buffer len = " + this.data.length + ')';
    }

    @NotNull
    public final Frame copy() {
        byte[] byArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(this, size)");
        return Companion.byType(this.fin, this.frameType, byArray, this.rsv1, this.rsv2, this.rsv3);
    }

    public /* synthetic */ Frame(boolean fin, FrameType frameType, byte[] data2, DisposableHandle disposableHandle, boolean rsv1, boolean rsv2, boolean rsv3, DefaultConstructorMarker $constructor_marker) {
        this(fin, frameType, data2, disposableHandle, rsv1, rsv2, rsv3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/ktor/websocket/Frame$Binary;", "Lio/ktor/websocket/Frame;", "fin", "", "buffer", "Ljava/nio/ByteBuffer;", "(ZLjava/nio/ByteBuffer;)V", "data", "", "(Z[B)V", "packet", "Lio/ktor/utils/io/core/ByteReadPacket;", "(ZLio/ktor/utils/io/core/ByteReadPacket;)V", "rsv1", "rsv2", "rsv3", "(Z[BZZZ)V", "ktor-websockets"})
    public static final class Binary
    extends Frame {
        public Binary(boolean fin, @NotNull byte[] data2, boolean rsv1, boolean rsv2, boolean rsv3) {
            Intrinsics.checkNotNullParameter(data2, "data");
            super(fin, FrameType.BINARY, data2, NonDisposableHandle.INSTANCE, rsv1, rsv2, rsv3, null);
        }

        public /* synthetic */ Binary(boolean bl, byte[] byArray, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = false;
            }
            if ((n & 0x10) != 0) {
                bl4 = false;
            }
            this(bl, byArray, bl2, bl3, bl4);
        }

        public Binary(boolean fin, @NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(fin, NIOKt.moveToByteArray(buffer));
        }

        public Binary(boolean fin, @NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            this(fin, data2, false, false, false);
        }

        public Binary(boolean fin, @NotNull ByteReadPacket packet2) {
            Intrinsics.checkNotNullParameter(packet2, "packet");
            this(fin, io.ktor.utils.io.core.StringsKt.readBytes$default(packet2, 0, 1, null));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/ktor/websocket/Frame$Text;", "Lio/ktor/websocket/Frame;", "fin", "", "data", "", "(Z[B)V", "text", "", "(Ljava/lang/String;)V", "packet", "Lio/ktor/utils/io/core/ByteReadPacket;", "(ZLio/ktor/utils/io/core/ByteReadPacket;)V", "buffer", "Ljava/nio/ByteBuffer;", "(ZLjava/nio/ByteBuffer;)V", "rsv1", "rsv2", "rsv3", "(Z[BZZZ)V", "ktor-websockets"})
    public static final class Text
    extends Frame {
        public Text(boolean fin, @NotNull byte[] data2, boolean rsv1, boolean rsv2, boolean rsv3) {
            Intrinsics.checkNotNullParameter(data2, "data");
            super(fin, FrameType.TEXT, data2, NonDisposableHandle.INSTANCE, rsv1, rsv2, rsv3, null);
        }

        public /* synthetic */ Text(boolean bl, byte[] byArray, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = false;
            }
            if ((n & 0x10) != 0) {
                bl4 = false;
            }
            this(bl, byArray, bl2, bl3, bl4);
        }

        public Text(boolean fin, @NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            this(fin, data2, false, false, false);
        }

        public Text(@NotNull String text) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter(text, "text");
            String $this$toByteArray_u24default$iv = text;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$toByteArray = false;
            if (Intrinsics.areEqual(charset$iv, Charsets.UTF_8)) {
                byArray = StringsKt.encodeToByteArray($this$toByteArray_u24default$iv);
            } else {
                CharsetEncoder charsetEncoder = charset$iv.newEncoder();
                Intrinsics.checkNotNullExpressionValue(charsetEncoder, "charset.newEncoder()");
                byArray = CharsetJVMKt.encodeToByteArray(charsetEncoder, $this$toByteArray_u24default$iv, 0, $this$toByteArray_u24default$iv.length());
            }
            this(true, byArray);
        }

        public Text(boolean fin, @NotNull ByteReadPacket packet2) {
            Intrinsics.checkNotNullParameter(packet2, "packet");
            this(fin, io.ktor.utils.io.core.StringsKt.readBytes$default(packet2, 0, 1, null));
        }

        public Text(boolean fin, @NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(fin, NIOKt.moveToByteArray(buffer));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0007\b\u0016\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/ktor/websocket/Frame$Close;", "Lio/ktor/websocket/Frame;", "reason", "Lio/ktor/websocket/CloseReason;", "(Lio/ktor/websocket/CloseReason;)V", "packet", "Lio/ktor/utils/io/core/ByteReadPacket;", "(Lio/ktor/utils/io/core/ByteReadPacket;)V", "()V", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "data", "", "([B)V", "ktor-websockets"})
    public static final class Close
    extends Frame {
        public Close(@NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            super(true, FrameType.CLOSE, data2, NonDisposableHandle.INSTANCE, false, false, false, null);
        }

        public Close(@NotNull CloseReason reason) {
            ByteReadPacket byteReadPacket;
            Intrinsics.checkNotNullParameter(reason, "reason");
            Close close2 = this;
            boolean $i$f$buildPacket = false;
            BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
            try {
                BytePacketBuilder $this$_init__u24lambda_u2d0 = builder$iv;
                boolean bl = false;
                OutputPrimitivesKt.writeShort($this$_init__u24lambda_u2d0, reason.getCode());
                io.ktor.utils.io.core.StringsKt.writeText$default((Output)$this$_init__u24lambda_u2d0, reason.getMessage(), 0, 0, null, 14, null);
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            close2(byteReadPacket);
        }

        public Close(@NotNull ByteReadPacket packet2) {
            Intrinsics.checkNotNullParameter(packet2, "packet");
            this(io.ktor.utils.io.core.StringsKt.readBytes$default(packet2, 0, 1, null));
        }

        public Close() {
            this(Empty);
        }

        public Close(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(NIOKt.moveToByteArray(buffer));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/ktor/websocket/Frame$Ping;", "Lio/ktor/websocket/Frame;", "packet", "Lio/ktor/utils/io/core/ByteReadPacket;", "(Lio/ktor/utils/io/core/ByteReadPacket;)V", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "data", "", "([B)V", "ktor-websockets"})
    public static final class Ping
    extends Frame {
        public Ping(@NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            super(true, FrameType.PING, data2, NonDisposableHandle.INSTANCE, false, false, false, null);
        }

        public Ping(@NotNull ByteReadPacket packet2) {
            Intrinsics.checkNotNullParameter(packet2, "packet");
            this(io.ktor.utils.io.core.StringsKt.readBytes$default(packet2, 0, 1, null));
        }

        public Ping(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(NIOKt.moveToByteArray(buffer));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB\u0017\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/ktor/websocket/Frame$Pong;", "Lio/ktor/websocket/Frame;", "packet", "Lio/ktor/utils/io/core/ByteReadPacket;", "(Lio/ktor/utils/io/core/ByteReadPacket;)V", "buffer", "Ljava/nio/ByteBuffer;", "disposableHandle", "Lkotlinx/coroutines/DisposableHandle;", "(Ljava/nio/ByteBuffer;Lkotlinx/coroutines/DisposableHandle;)V", "(Ljava/nio/ByteBuffer;)V", "data", "", "([BLkotlinx/coroutines/DisposableHandle;)V", "ktor-websockets"})
    public static final class Pong
    extends Frame {
        public Pong(@NotNull byte[] data2, @NotNull DisposableHandle disposableHandle) {
            Intrinsics.checkNotNullParameter(data2, "data");
            Intrinsics.checkNotNullParameter(disposableHandle, "disposableHandle");
            super(true, FrameType.PONG, data2, disposableHandle, false, false, false, null);
        }

        public /* synthetic */ Pong(byte[] byArray, DisposableHandle disposableHandle, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                disposableHandle = NonDisposableHandle.INSTANCE;
            }
            this(byArray, disposableHandle);
        }

        public Pong(@NotNull ByteReadPacket packet2) {
            Intrinsics.checkNotNullParameter(packet2, "packet");
            this(io.ktor.utils.io.core.StringsKt.readBytes$default(packet2, 0, 1, null), (DisposableHandle)NonDisposableHandle.INSTANCE);
        }

        public Pong(@NotNull ByteBuffer buffer, @NotNull DisposableHandle disposableHandle) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            Intrinsics.checkNotNullParameter(disposableHandle, "disposableHandle");
            this(NIOKt.moveToByteArray(buffer), disposableHandle);
        }

        public /* synthetic */ Pong(ByteBuffer byteBuffer, DisposableHandle disposableHandle, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                disposableHandle = NonDisposableHandle.INSTANCE;
            }
            this(byteBuffer, disposableHandle);
        }

        public Pong(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(NIOKt.moveToByteArray(buffer), (DisposableHandle)NonDisposableHandle.INSTANCE);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/ktor/websocket/Frame$Companion;", "", "()V", "Empty", "", "byType", "Lio/ktor/websocket/Frame;", "fin", "", "frameType", "Lio/ktor/websocket/FrameType;", "data", "rsv1", "rsv2", "rsv3", "ktor-websockets"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Frame byType(boolean fin, @NotNull FrameType frameType, @NotNull byte[] data2, boolean rsv1, boolean rsv2, boolean rsv3) {
            Frame frame;
            Intrinsics.checkNotNullParameter((Object)frameType, "frameType");
            Intrinsics.checkNotNullParameter(data2, "data");
            switch (WhenMappings.$EnumSwitchMapping$0[frameType.ordinal()]) {
                case 1: {
                    frame = new Binary(fin, data2, rsv1, rsv2, rsv3);
                    break;
                }
                case 2: {
                    frame = new Text(fin, data2, rsv1, rsv2, rsv3);
                    break;
                }
                case 3: {
                    frame = new Close(data2);
                    break;
                }
                case 4: {
                    frame = new Ping(data2);
                    break;
                }
                case 5: {
                    frame = new Pong(data2, (DisposableHandle)NonDisposableHandle.INSTANCE);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return frame;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FrameType.values().length];
                nArray[FrameType.BINARY.ordinal()] = 1;
                nArray[FrameType.TEXT.ordinal()] = 2;
                nArray[FrameType.CLOSE.ordinal()] = 3;
                nArray[FrameType.PING.ordinal()] = 4;
                nArray[FrameType.PONG.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

