/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.internals.CharArrayPoolKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u00013B\u0015\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0017\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u0017\u001a\u00060\u0002j\u0002`\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0016J&\u0010\u0017\u001a\u00060\u0002j\u0002`\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020\fH\u0002J\u0013\u0010!\u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\u0011\u0010$\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\fH\u0096\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\fH\u0002J\b\u0010&\u001a\u00020\fH\u0016J\u0018\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0002J\b\u0010*\u001a\u00020\u0006H\u0002J(\u0010+\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0006\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\fH\u0002J\b\u00102\u001a\u00020\u0016H\u0016R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lio/ktor/http/cio/internals/CharArrayBuilder;", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "pool", "Lio/ktor/utils/io/pool/ObjectPool;", "", "(Lio/ktor/utils/io/pool/ObjectPool;)V", "buffers", "", "current", "<set-?>", "", "length", "getLength", "()I", "getPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "released", "", "remaining", "stringified", "", "append", "value", "", "startIndex", "endIndex", "appendNewArray", "bufferForIndex", "index", "copy", "currentPosition", "equals", "other", "", "get", "getImpl", "hashCode", "hashCodeImpl", "start", "end", "nonFullBuffer", "rangeEqualsImpl", "otherStart", "release", "", "subSequence", "throwSingleBuffer", "", "toString", "SubSequenceImpl", "ktor-http-cio"})
public final class CharArrayBuilder
implements CharSequence,
Appendable {
    @NotNull
    private final ObjectPool<char[]> pool;
    @Nullable
    private List<char[]> buffers;
    @Nullable
    private char[] current;
    @Nullable
    private String stringified;
    private boolean released;
    private int remaining;
    private int length;

    public CharArrayBuilder(@NotNull ObjectPool<char[]> pool) {
        Intrinsics.checkNotNullParameter(pool, "pool");
        this.pool = pool;
    }

    public /* synthetic */ CharArrayBuilder(ObjectPool objectPool, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            objectPool = CharArrayPoolKt.getCharArrayPool();
        }
        this(objectPool);
    }

    @NotNull
    public final ObjectPool<char[]> getPool() {
        return this.pool;
    }

    public int getLength() {
        return this.length;
    }

    public char get(int index) {
        if (!(index >= 0)) {
            boolean $i$a$-require-CharArrayBuilder$get$32 = false;
            String $i$a$-require-CharArrayBuilder$get$32 = "index is negative: " + index;
            throw new IllegalArgumentException($i$a$-require-CharArrayBuilder$get$32.toString());
        }
        if (!(index < this.length())) {
            boolean bl = false;
            String string = "index " + index + " is not in range [0, " + this.length() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        return this.getImpl(index);
    }

    private final char getImpl(int index) {
        char[] cArray = this.bufferForIndex(index);
        Intrinsics.checkNotNull(this.current);
        return cArray[index % this.current.length];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (!(startIndex <= endIndex)) {
            boolean $i$a$-require-CharArrayBuilder$subSequence$42 = false;
            String $i$a$-require-CharArrayBuilder$subSequence$42 = "startIndex (" + startIndex + ") should be less or equal to endIndex (" + endIndex + ')';
            throw new IllegalArgumentException($i$a$-require-CharArrayBuilder$subSequence$42.toString());
        }
        if (!(startIndex >= 0)) {
            boolean $i$a$-require-CharArrayBuilder$subSequence$52 = false;
            String $i$a$-require-CharArrayBuilder$subSequence$52 = "startIndex is negative: " + startIndex;
            throw new IllegalArgumentException($i$a$-require-CharArrayBuilder$subSequence$52.toString());
        }
        if (!(endIndex <= this.length())) {
            boolean bl = false;
            String string = "endIndex (" + endIndex + ") is greater than length (" + this.length() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        return new SubSequenceImpl(startIndex, endIndex);
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.stringified;
        if (string == null) {
            String string2;
            String it = string2 = ((Object)this.copy(0, this.length())).toString();
            boolean bl = false;
            this.stringified = it;
            string = string2;
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof CharSequence)) {
            return false;
        }
        if (this.length() != ((CharSequence)other).length()) {
            return false;
        }
        return this.rangeEqualsImpl(0, (CharSequence)other, 0, this.length());
    }

    public int hashCode() {
        String string = this.stringified;
        return string != null ? string.hashCode() : this.hashCodeImpl(0, this.length());
    }

    @Override
    @NotNull
    public Appendable append(char value) {
        char[] cArray = this.nonFullBuffer();
        Intrinsics.checkNotNull(this.current);
        cArray[this.current.length - this.remaining] = value;
        this.stringified = null;
        --this.remaining;
        int n = this.length();
        this.length = n + 1;
        return this;
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence value, int startIndex, int endIndex) {
        if (value == null) {
            return this;
        }
        int current = startIndex;
        while (current < endIndex) {
            char[] buffer = this.nonFullBuffer();
            int offset = buffer.length - this.remaining;
            int bytesToCopy = Math.min(endIndex - current, this.remaining);
            for (int i = 0; i < bytesToCopy; ++i) {
                buffer[offset + i] = value.charAt(current + i);
            }
            current += bytesToCopy;
            this.remaining -= bytesToCopy;
        }
        this.stringified = null;
        this.length = this.length() + (endIndex - startIndex);
        return this;
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence value) {
        if (value == null) {
            return this;
        }
        return this.append(value, 0, value.length());
    }

    public final void release() {
        List<char[]> list = this.buffers;
        if (list != null) {
            this.current = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.pool.recycle(list.get(i));
            }
        } else {
            if (this.current != null) {
                char[] it = this.current;
                boolean bl = false;
                this.pool.recycle(it);
            }
            this.current = null;
        }
        this.released = true;
        this.buffers = null;
        this.stringified = null;
        this.length = 0;
        this.remaining = 0;
    }

    private final CharSequence copy(int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return "";
        }
        StringBuilder builder2 = new StringBuilder(endIndex - startIndex);
        char[] buffer = null;
        for (int base = startIndex - startIndex % 2048; base < endIndex; base += 2048) {
            buffer = this.bufferForIndex(base);
            int innerStartIndex = Math.max(0, startIndex - base);
            int innerEndIndex = Math.min(endIndex - base, 2048);
            for (int innerIndex = innerStartIndex; innerIndex < innerEndIndex; ++innerIndex) {
                builder2.append(buffer[innerIndex]);
            }
        }
        return builder2;
    }

    private final char[] bufferForIndex(int index) {
        List<char[]> list = this.buffers;
        if (list == null) {
            if (index >= 2048) {
                this.throwSingleBuffer(index);
                throw new KotlinNothingValueException();
            }
            if (this.current == null) {
                this.throwSingleBuffer(index);
                throw new KotlinNothingValueException();
            }
            return this.current;
        }
        Intrinsics.checkNotNull(this.current);
        return list.get(index / this.current.length);
    }

    private final Void throwSingleBuffer(int index) {
        if (this.released) {
            throw new IllegalStateException("Buffer is already released");
        }
        throw new IndexOutOfBoundsException(index + " is not in range [0; " + this.currentPosition() + ')');
    }

    private final char[] nonFullBuffer() {
        char[] cArray;
        if (this.remaining == 0) {
            cArray = this.appendNewArray();
        } else {
            cArray = this.current;
            Intrinsics.checkNotNull(this.current);
        }
        return cArray;
    }

    private final char[] appendNewArray() {
        char[] newBuffer = this.pool.borrow();
        char[] existing = this.current;
        this.current = newBuffer;
        this.remaining = newBuffer.length;
        this.released = false;
        if (existing != null) {
            List list = this.buffers;
            if (list == null) {
                ArrayList<char[]> arrayList;
                ArrayList<char[]> it = arrayList = new ArrayList<char[]>();
                boolean bl = false;
                this.buffers = it;
                it.add(existing);
                list = arrayList;
            }
            List list2 = list;
            list2.add((char[])newBuffer);
        }
        return newBuffer;
    }

    private final boolean rangeEqualsImpl(int start2, CharSequence other, int otherStart, int length) {
        for (int i = 0; i < length; ++i) {
            if (this.getImpl(start2 + i) == other.charAt(otherStart + i)) continue;
            return false;
        }
        return true;
    }

    private final int hashCodeImpl(int start2, int end2) {
        int hc = 0;
        for (int i = start2; i < end2; ++i) {
            hc = 31 * hc + this.getImpl(i);
        }
        return hc;
    }

    private final int currentPosition() {
        Intrinsics.checkNotNull(this.current);
        return this.current.length - this.remaining;
    }

    public CharArrayBuilder() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/ktor/http/cio/internals/CharArrayBuilder$SubSequenceImpl;", "", "start", "", "end", "(Lio/ktor/http/cio/internals/CharArrayBuilder;II)V", "getEnd", "()I", "length", "getLength", "getStart", "stringified", "", "equals", "", "other", "", "get", "", "index", "hashCode", "subSequence", "startIndex", "endIndex", "toString", "ktor-http-cio"})
    private final class SubSequenceImpl
    implements CharSequence {
        private final int start;
        private final int end;
        @Nullable
        private String stringified;

        public SubSequenceImpl(int start2, int end2) {
            this.start = start2;
            this.end = end2;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public int getLength() {
            return this.end - this.start;
        }

        public char get(int index) {
            int withOffset = index + this.start;
            if (!(index >= 0)) {
                boolean $i$a$-require-CharArrayBuilder$SubSequenceImpl$get$32 = false;
                String $i$a$-require-CharArrayBuilder$SubSequenceImpl$get$32 = "index is negative: " + index;
                throw new IllegalArgumentException($i$a$-require-CharArrayBuilder$SubSequenceImpl$get$32.toString());
            }
            if (!(withOffset < this.end)) {
                boolean bl = false;
                String string = "index (" + index + ") should be less than length (" + this.length() + ')';
                throw new IllegalArgumentException(string.toString());
            }
            return CharArrayBuilder.this.getImpl(withOffset);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int startIndex, int endIndex) {
            if (!(startIndex >= 0)) {
                boolean $i$a$-require-CharArrayBuilder$SubSequenceImpl$subSequence$42 = false;
                String $i$a$-require-CharArrayBuilder$SubSequenceImpl$subSequence$42 = "start is negative: " + startIndex;
                throw new IllegalArgumentException($i$a$-require-CharArrayBuilder$SubSequenceImpl$subSequence$42.toString());
            }
            if (!(startIndex <= endIndex)) {
                boolean $i$a$-require-CharArrayBuilder$SubSequenceImpl$subSequence$52 = false;
                String $i$a$-require-CharArrayBuilder$SubSequenceImpl$subSequence$52 = "start (" + startIndex + ") should be less or equal to end (" + endIndex + ')';
                throw new IllegalArgumentException($i$a$-require-CharArrayBuilder$SubSequenceImpl$subSequence$52.toString());
            }
            if (!(endIndex <= this.end - this.start)) {
                boolean bl = false;
                String string = "end should be less than length (" + this.length() + ')';
                throw new IllegalArgumentException(string.toString());
            }
            if (startIndex == endIndex) {
                return "";
            }
            return new SubSequenceImpl(this.start + startIndex, this.start + endIndex);
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.stringified;
            if (string == null) {
                String string2;
                String it = string2 = ((Object)CharArrayBuilder.this.copy(this.start, this.end)).toString();
                boolean bl = false;
                this.stringified = it;
                string = string2;
            }
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof CharSequence)) {
                return false;
            }
            if (((CharSequence)other).length() != this.length()) {
                return false;
            }
            return CharArrayBuilder.this.rangeEqualsImpl(this.start, (CharSequence)other, 0, this.length());
        }

        public int hashCode() {
            String string = this.stringified;
            return string != null ? string.hashCode() : CharArrayBuilder.this.hashCodeImpl(this.start, this.end);
        }
    }
}

