/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLParserKt;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b\u001a\u000e\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0001\u001a&\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a(\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a$\u0010\u0017\u001a\u00020\u000e*\u00060\u0018j\u0002`\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0012\u0010\u001c\u001a\u00020\b*\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a\u0012\u0010\u001c\u001a\u00020\b*\u00020\b2\u0006\u0010\n\u001a\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u001d"}, d2={"fullPath", "", "Lio/ktor/http/Url;", "getFullPath", "(Lio/ktor/http/Url;)Ljava/lang/String;", "hostWithPort", "getHostWithPort", "URLBuilder", "Lio/ktor/http/URLBuilder;", "builder", "url", "urlString", "Url", "appendUrlFullPath", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "encodedPath", "encodedQueryParameters", "Lio/ktor/http/ParametersBuilder;", "trailingQuery", "", "encodedQuery", "appendUserAndPassword", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "encodedUser", "encodedPassword", "takeFrom", "ktor-http"})
public final class URLUtilsKt {
    @NotNull
    public static final Url Url(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter(urlString, "urlString");
        return URLUtilsKt.URLBuilder(urlString).build();
    }

    @NotNull
    public static final Url Url(@NotNull URLBuilder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), builder2).build();
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter(urlString, "urlString");
        return URLParserKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), urlString);
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull Url url2) {
        Intrinsics.checkNotNullParameter(url2, "url");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), url2);
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull URLBuilder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), builder2);
    }

    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull URLBuilder url2) {
        Intrinsics.checkNotNullParameter($this$takeFrom, "<this>");
        Intrinsics.checkNotNullParameter(url2, "url");
        $this$takeFrom.setProtocol(url2.getProtocol());
        $this$takeFrom.setHost(url2.getHost());
        $this$takeFrom.setPort(url2.getPort());
        $this$takeFrom.setEncodedPathSegments(url2.getEncodedPathSegments());
        $this$takeFrom.setEncodedUser(url2.getEncodedUser());
        $this$takeFrom.setEncodedPassword(url2.getEncodedPassword());
        $this$takeFrom.setEncodedParameters(url2.getEncodedParameters());
        $this$takeFrom.setEncodedFragment(url2.getEncodedFragment());
        $this$takeFrom.setTrailingQuery(url2.getTrailingQuery());
        return $this$takeFrom;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull Url url2) {
        void $this$takeFrom_u24lambda_u2d0;
        ParametersBuilder parametersBuilder;
        Intrinsics.checkNotNullParameter($this$takeFrom, "<this>");
        Intrinsics.checkNotNullParameter(url2, "url");
        $this$takeFrom.setProtocol(url2.getProtocol());
        $this$takeFrom.setHost(url2.getHost());
        $this$takeFrom.setPort(url2.getPort());
        URLBuilderKt.setEncodedPath($this$takeFrom, url2.getEncodedPath());
        $this$takeFrom.setEncodedUser(url2.getEncodedUser());
        $this$takeFrom.setEncodedPassword(url2.getEncodedPassword());
        ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        URLBuilder uRLBuilder = $this$takeFrom;
        boolean bl = false;
        $this$takeFrom_u24lambda_u2d0.appendAll(QueryKt.parseQueryString$default(url2.getEncodedQuery(), 0, 0, false, 6, null));
        uRLBuilder.setEncodedParameters(parametersBuilder);
        $this$takeFrom.setEncodedFragment(url2.getEncodedFragment());
        $this$takeFrom.setTrailingQuery(url2.getTrailingQuery());
        return $this$takeFrom;
    }

    @NotNull
    public static final String getFullPath(@NotNull Url $this$fullPath) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$fullPath, "<this>");
        StringBuilder $this$_get_fullPath__u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        URLUtilsKt.appendUrlFullPath((Appendable)$this$_get_fullPath__u24lambda_u2d1, $this$fullPath.getEncodedPath(), $this$fullPath.getEncodedQuery(), $this$fullPath.getTrailingQuery());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String getHostWithPort(@NotNull Url $this$hostWithPort) {
        Intrinsics.checkNotNullParameter($this$hostWithPort, "<this>");
        return $this$hostWithPort.getHost() + ':' + $this$hostWithPort.getPort();
    }

    public static final void appendUrlFullPath(@NotNull Appendable $this$appendUrlFullPath, @NotNull String encodedPath2, @NotNull String encodedQuery2, boolean trailingQuery) {
        Intrinsics.checkNotNullParameter($this$appendUrlFullPath, "<this>");
        Intrinsics.checkNotNullParameter(encodedPath2, "encodedPath");
        Intrinsics.checkNotNullParameter(encodedQuery2, "encodedQuery");
        if (!StringsKt.isBlank(encodedPath2) && !StringsKt.startsWith$default(encodedPath2, "/", false, 2, null)) {
            $this$appendUrlFullPath.append('/');
        }
        $this$appendUrlFullPath.append(encodedPath2);
        if (((CharSequence)encodedQuery2).length() > 0 || trailingQuery) {
            $this$appendUrlFullPath.append("?");
        }
        $this$appendUrlFullPath.append(encodedQuery2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendUrlFullPath(@NotNull Appendable $this$appendUrlFullPath, @NotNull String encodedPath2, @NotNull ParametersBuilder encodedQueryParameters, boolean trailingQuery) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter($this$appendUrlFullPath, "<this>");
        Intrinsics.checkNotNullParameter(encodedPath2, "encodedPath");
        Intrinsics.checkNotNullParameter(encodedQueryParameters, "encodedQueryParameters");
        if (!StringsKt.isBlank(encodedPath2) && !StringsKt.startsWith$default(encodedPath2, "/", false, 2, null)) {
            $this$appendUrlFullPath.append('/');
        }
        $this$appendUrlFullPath.append(encodedPath2);
        if (!encodedQueryParameters.isEmpty() || trailingQuery) {
            $this$appendUrlFullPath.append("?");
        }
        Iterable iterable = encodedQueryParameters.entries();
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value.isEmpty()) {
                list = CollectionsKt.listOf(TuplesKt.to(key, null));
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to(key, it));
                }
                list = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        CollectionsKt.joinTo$default((List)destination$iv$iv, $this$appendUrlFullPath, "&", null, null, 0, null, appendUrlFullPath.2.INSTANCE, 60, null);
    }

    public static final void appendUserAndPassword(@NotNull StringBuilder $this$appendUserAndPassword, @Nullable String encodedUser2, @Nullable String encodedPassword2) {
        Intrinsics.checkNotNullParameter($this$appendUserAndPassword, "<this>");
        if (encodedUser2 == null) {
            return;
        }
        $this$appendUserAndPassword.append(encodedUser2);
        if (encodedPassword2 != null) {
            $this$appendUserAndPassword.append(':');
            $this$appendUserAndPassword.append(encodedPassword2);
        }
        $this$appendUserAndPassword.append("@");
    }
}

