/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.StaticUnicodeSets;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public final class ScientificNumberFormatter {
    private final String preExponent;
    private final DecimalFormat fmt;
    private final Style style;
    private static final Style SUPER_SCRIPT = new SuperscriptStyle();

    public static ScientificNumberFormatter getSuperscriptInstance(ULocale locale) {
        return ScientificNumberFormatter.getInstanceForLocale(locale, SUPER_SCRIPT);
    }

    public static ScientificNumberFormatter getSuperscriptInstance(DecimalFormat df) {
        return ScientificNumberFormatter.getInstance(df, SUPER_SCRIPT);
    }

    public static ScientificNumberFormatter getMarkupInstance(ULocale locale, String beginMarkup, String endMarkup) {
        return ScientificNumberFormatter.getInstanceForLocale(locale, new MarkupStyle(beginMarkup, endMarkup));
    }

    public static ScientificNumberFormatter getMarkupInstance(DecimalFormat df, String beginMarkup, String endMarkup) {
        return ScientificNumberFormatter.getInstance(df, new MarkupStyle(beginMarkup, endMarkup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Object number) {
        DecimalFormat decimalFormat = this.fmt;
        synchronized (decimalFormat) {
            return this.style.format(this.fmt.formatToCharacterIterator(number), this.preExponent);
        }
    }

    private static String getPreExponent(DecimalFormatSymbols dfs) {
        StringBuilder preExponent = new StringBuilder();
        preExponent.append(dfs.getExponentMultiplicationSign());
        char[] digits = dfs.getDigits();
        preExponent.append(digits[1]).append(digits[0]);
        return preExponent.toString();
    }

    private static ScientificNumberFormatter getInstance(DecimalFormat decimalFormat, Style style) {
        DecimalFormatSymbols dfs = decimalFormat.getDecimalFormatSymbols();
        return new ScientificNumberFormatter((DecimalFormat)decimalFormat.clone(), ScientificNumberFormatter.getPreExponent(dfs), style);
    }

    private static ScientificNumberFormatter getInstanceForLocale(ULocale locale, Style style) {
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getScientificInstance(locale);
        return new ScientificNumberFormatter(decimalFormat, ScientificNumberFormatter.getPreExponent(decimalFormat.getDecimalFormatSymbols()), style);
    }

    private ScientificNumberFormatter(DecimalFormat decimalFormat, String preExponent, Style style) {
        this.fmt = decimalFormat;
        this.preExponent = preExponent;
        this.style = style;
    }

    private static class SuperscriptStyle
    extends Style {
        private static final char[] SUPERSCRIPT_DIGITS = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
        private static final char SUPERSCRIPT_PLUS_SIGN = '\u207a';
        private static final char SUPERSCRIPT_MINUS_SIGN = '\u207b';

        private SuperscriptStyle() {
        }

        @Override
        String format(AttributedCharacterIterator iterator2, String preExponent) {
            int copyFromOffset = 0;
            StringBuilder result2 = new StringBuilder();
            iterator2.first();
            while (iterator2.current() != '\uffff') {
                int limit;
                int start2;
                Map<AttributedCharacterIterator.Attribute, Object> attributeSet = iterator2.getAttributes();
                if (attributeSet.containsKey(NumberFormat.Field.EXPONENT_SYMBOL)) {
                    SuperscriptStyle.append(iterator2, copyFromOffset, iterator2.getRunStart(NumberFormat.Field.EXPONENT_SYMBOL), result2);
                    copyFromOffset = iterator2.getRunLimit(NumberFormat.Field.EXPONENT_SYMBOL);
                    iterator2.setIndex(copyFromOffset);
                    result2.append(preExponent);
                    continue;
                }
                if (attributeSet.containsKey(NumberFormat.Field.EXPONENT_SIGN)) {
                    start2 = iterator2.getRunStart(NumberFormat.Field.EXPONENT_SIGN);
                    limit = iterator2.getRunLimit(NumberFormat.Field.EXPONENT_SIGN);
                    int aChar = SuperscriptStyle.char32AtAndAdvance(iterator2);
                    if (StaticUnicodeSets.get(StaticUnicodeSets.Key.MINUS_SIGN).contains(aChar)) {
                        SuperscriptStyle.append(iterator2, copyFromOffset, start2, result2);
                        result2.append('\u207b');
                    } else if (StaticUnicodeSets.get(StaticUnicodeSets.Key.PLUS_SIGN).contains(aChar)) {
                        SuperscriptStyle.append(iterator2, copyFromOffset, start2, result2);
                        result2.append('\u207a');
                    } else {
                        throw new IllegalArgumentException();
                    }
                    copyFromOffset = limit;
                    iterator2.setIndex(copyFromOffset);
                    continue;
                }
                if (attributeSet.containsKey(NumberFormat.Field.EXPONENT)) {
                    start2 = iterator2.getRunStart(NumberFormat.Field.EXPONENT);
                    limit = iterator2.getRunLimit(NumberFormat.Field.EXPONENT);
                    SuperscriptStyle.append(iterator2, copyFromOffset, start2, result2);
                    SuperscriptStyle.copyAsSuperscript(iterator2, start2, limit, result2);
                    copyFromOffset = limit;
                    iterator2.setIndex(copyFromOffset);
                    continue;
                }
                iterator2.next();
            }
            SuperscriptStyle.append(iterator2, copyFromOffset, iterator2.getEndIndex(), result2);
            return result2.toString();
        }

        private static void copyAsSuperscript(AttributedCharacterIterator iterator2, int start2, int limit, StringBuilder result2) {
            int oldIndex = iterator2.getIndex();
            iterator2.setIndex(start2);
            while (iterator2.getIndex() < limit) {
                int aChar = SuperscriptStyle.char32AtAndAdvance(iterator2);
                int digit = UCharacter.digit(aChar);
                if (digit < 0) {
                    throw new IllegalArgumentException();
                }
                result2.append(SUPERSCRIPT_DIGITS[digit]);
            }
            iterator2.setIndex(oldIndex);
        }

        private static int char32AtAndAdvance(AttributedCharacterIterator iterator2) {
            char c1 = iterator2.current();
            char c2 = iterator2.next();
            if (UCharacter.isHighSurrogate(c1) && UCharacter.isLowSurrogate(c2)) {
                iterator2.next();
                return UCharacter.toCodePoint(c1, c2);
            }
            return c1;
        }
    }

    private static class MarkupStyle
    extends Style {
        private final String beginMarkup;
        private final String endMarkup;

        MarkupStyle(String beginMarkup, String endMarkup) {
            this.beginMarkup = beginMarkup;
            this.endMarkup = endMarkup;
        }

        @Override
        String format(AttributedCharacterIterator iterator2, String preExponent) {
            int copyFromOffset = 0;
            StringBuilder result2 = new StringBuilder();
            iterator2.first();
            while (iterator2.current() != '\uffff') {
                Map<AttributedCharacterIterator.Attribute, Object> attributeSet = iterator2.getAttributes();
                if (attributeSet.containsKey(NumberFormat.Field.EXPONENT_SYMBOL)) {
                    MarkupStyle.append(iterator2, copyFromOffset, iterator2.getRunStart(NumberFormat.Field.EXPONENT_SYMBOL), result2);
                    copyFromOffset = iterator2.getRunLimit(NumberFormat.Field.EXPONENT_SYMBOL);
                    iterator2.setIndex(copyFromOffset);
                    result2.append(preExponent);
                    result2.append(this.beginMarkup);
                    continue;
                }
                if (attributeSet.containsKey(NumberFormat.Field.EXPONENT)) {
                    int limit = iterator2.getRunLimit(NumberFormat.Field.EXPONENT);
                    MarkupStyle.append(iterator2, copyFromOffset, limit, result2);
                    copyFromOffset = limit;
                    iterator2.setIndex(copyFromOffset);
                    result2.append(this.endMarkup);
                    continue;
                }
                iterator2.next();
            }
            MarkupStyle.append(iterator2, copyFromOffset, iterator2.getEndIndex(), result2);
            return result2.toString();
        }
    }

    private static abstract class Style {
        private Style() {
        }

        abstract String format(AttributedCharacterIterator var1, String var2);

        static void append(AttributedCharacterIterator iterator2, int start2, int limit, StringBuilder result2) {
            int oldIndex = iterator2.getIndex();
            iterator2.setIndex(start2);
            for (int i = start2; i < limit; ++i) {
                result2.append(iterator2.current());
                iterator2.next();
            }
            iterator2.setIndex(oldIndex);
        }
    }
}

