/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Norm2AllModes;
import com.ibm.icu.impl.Normalizer2Impl;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.SourceTargetUtility;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import java.util.HashMap;
import java.util.Map;

final class NormalizationTransliterator
extends Transliterator {
    private final Normalizer2 norm2;
    static final Map<Normalizer2, SourceTargetUtility> SOURCE_CACHE = new HashMap<Normalizer2, SourceTargetUtility>();

    static void register() {
        Transliterator.registerFactory("Any-NFC", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String ID2) {
                return new NormalizationTransliterator("NFC", Normalizer2.getNFCInstance());
            }
        });
        Transliterator.registerFactory("Any-NFD", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String ID2) {
                return new NormalizationTransliterator("NFD", Normalizer2.getNFDInstance());
            }
        });
        Transliterator.registerFactory("Any-NFKC", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String ID2) {
                return new NormalizationTransliterator("NFKC", Normalizer2.getNFKCInstance());
            }
        });
        Transliterator.registerFactory("Any-NFKD", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String ID2) {
                return new NormalizationTransliterator("NFKD", Normalizer2.getNFKDInstance());
            }
        });
        Transliterator.registerFactory("Any-FCD", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String ID2) {
                return new NormalizationTransliterator("FCD", Norm2AllModes.getFCDNormalizer2());
            }
        });
        Transliterator.registerFactory("Any-FCC", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String ID2) {
                return new NormalizationTransliterator("FCC", Norm2AllModes.getNFCInstance().fcc);
            }
        });
        Transliterator.registerSpecialInverse("NFC", "NFD", true);
        Transliterator.registerSpecialInverse("NFKC", "NFKD", true);
        Transliterator.registerSpecialInverse("FCC", "NFD", false);
        Transliterator.registerSpecialInverse("FCD", "FCD", false);
    }

    private NormalizationTransliterator(String id, Normalizer2 n2) {
        super(id, null);
        this.norm2 = n2;
    }

    @Override
    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean isIncremental) {
        int start2 = offsets.start;
        int limit = offsets.limit;
        if (start2 >= limit) {
            return;
        }
        StringBuilder segment = new StringBuilder();
        StringBuilder normalized = new StringBuilder();
        int c = text.char32At(start2);
        do {
            int prev = start2;
            segment.setLength(0);
            do {
                segment.appendCodePoint(c);
            } while ((start2 += Character.charCount(c)) < limit && !this.norm2.hasBoundaryBefore(c = text.char32At(start2)));
            if (start2 == limit && isIncremental && !this.norm2.hasBoundaryAfter(c)) {
                start2 = prev;
                break;
            }
            this.norm2.normalize((CharSequence)segment, normalized);
            if (Normalizer2Impl.UTF16Plus.equal(segment, normalized)) continue;
            text.replace(prev, start2, normalized.toString());
            int delta = normalized.length() - (start2 - prev);
            start2 += delta;
            limit += delta;
        } while (start2 < limit);
        offsets.start = start2;
        offsets.contextLimit += limit - offsets.limit;
        offsets.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourceTargetSet(UnicodeSet inputFilter, UnicodeSet sourceSet, UnicodeSet targetSet) {
        SourceTargetUtility cache2;
        Map<Normalizer2, SourceTargetUtility> map2 = SOURCE_CACHE;
        synchronized (map2) {
            cache2 = SOURCE_CACHE.get(this.norm2);
            if (cache2 == null) {
                cache2 = new SourceTargetUtility(new NormalizingTransform(this.norm2), this.norm2);
                SOURCE_CACHE.put(this.norm2, cache2);
            }
        }
        cache2.addSourceTargetSet(this, inputFilter, sourceSet, targetSet);
    }

    static class NormalizingTransform
    implements Transform<String, String> {
        final Normalizer2 norm2;

        public NormalizingTransform(Normalizer2 norm2) {
            this.norm2 = norm2;
        }

        @Override
        public String transform(String source) {
            return this.norm2.normalize(source);
        }
    }
}

