/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.number;

import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.number.FormattedNumberRange;
import com.ibm.icu.number.NumberRangeFormatterImpl;
import com.ibm.icu.number.NumberRangeFormatterSettings;

public class LocalizedNumberRangeFormatter
extends NumberRangeFormatterSettings<LocalizedNumberRangeFormatter> {
    private volatile NumberRangeFormatterImpl fImpl;

    LocalizedNumberRangeFormatter(NumberRangeFormatterSettings<?> parent, int key, Object value) {
        super(parent, key, value);
    }

    public FormattedNumberRange formatRange(int first2, int second2) {
        DecimalQuantity_DualStorageBCD dq1 = new DecimalQuantity_DualStorageBCD(first2);
        DecimalQuantity_DualStorageBCD dq2 = new DecimalQuantity_DualStorageBCD(second2);
        return this.formatImpl(dq1, dq2, first2 == second2);
    }

    public FormattedNumberRange formatRange(double first2, double second2) {
        DecimalQuantity_DualStorageBCD dq1 = new DecimalQuantity_DualStorageBCD(first2);
        DecimalQuantity_DualStorageBCD dq2 = new DecimalQuantity_DualStorageBCD(second2);
        return this.formatImpl(dq1, dq2, first2 == second2);
    }

    public FormattedNumberRange formatRange(Number first2, Number second2) {
        if (first2 == null || second2 == null) {
            throw new IllegalArgumentException("Cannot format null values in range");
        }
        DecimalQuantity_DualStorageBCD dq1 = new DecimalQuantity_DualStorageBCD(first2);
        DecimalQuantity_DualStorageBCD dq2 = new DecimalQuantity_DualStorageBCD(second2);
        return this.formatImpl(dq1, dq2, first2.equals(second2));
    }

    FormattedNumberRange formatImpl(DecimalQuantity first2, DecimalQuantity second2, boolean equalBeforeRounding) {
        if (this.fImpl == null) {
            this.fImpl = new NumberRangeFormatterImpl(this.resolve());
        }
        return this.fImpl.format(first2, second2, equalBeforeRounding);
    }

    @Override
    LocalizedNumberRangeFormatter create(int key, Object value) {
        return new LocalizedNumberRangeFormatter(this, key, value);
    }
}

