/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.impl.CharacterPropertiesImpl;
import com.ibm.icu.impl.EmojiProps;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.CodePointMap;
import com.ibm.icu.util.CodePointTrie;
import com.ibm.icu.util.MutableCodePointTrie;

public final class CharacterProperties {
    private static final UnicodeSet[] sets = new UnicodeSet[72];
    private static final CodePointMap[] maps = new CodePointMap[25];

    private CharacterProperties() {
    }

    private static UnicodeSet makeSet(int property2) {
        UnicodeSet set2 = new UnicodeSet();
        if (65 <= property2 && property2 <= 71) {
            EmojiProps.INSTANCE.addStrings(property2, set2);
            if (property2 != 65 && property2 != 71) {
                return set2.freeze();
            }
        }
        UnicodeSet inclusions = CharacterPropertiesImpl.getInclusionsForProperty(property2);
        int numRanges = inclusions.getRangeCount();
        int startHasProperty = -1;
        for (int i = 0; i < numRanges; ++i) {
            int rangeEnd = inclusions.getRangeEnd(i);
            for (int c = inclusions.getRangeStart(i); c <= rangeEnd; ++c) {
                if (UCharacter.hasBinaryProperty(c, property2)) {
                    if (startHasProperty >= 0) continue;
                    startHasProperty = c;
                    continue;
                }
                if (startHasProperty < 0) continue;
                set2.add(startHasProperty, c - 1);
                startHasProperty = -1;
            }
        }
        if (startHasProperty >= 0) {
            set2.add(startHasProperty, 0x10FFFF);
        }
        return set2.freeze();
    }

    private static CodePointMap makeMap(int property2) {
        int nullValue = property2 == 4106 ? 103 : 0;
        MutableCodePointTrie mutableTrie = new MutableCodePointTrie(nullValue, nullValue);
        UnicodeSet inclusions = CharacterPropertiesImpl.getInclusionsForProperty(property2);
        int numRanges = inclusions.getRangeCount();
        int start2 = 0;
        int value = nullValue;
        for (int i = 0; i < numRanges; ++i) {
            int rangeEnd = inclusions.getRangeEnd(i);
            for (int c = inclusions.getRangeStart(i); c <= rangeEnd; ++c) {
                int nextValue = UCharacter.getIntPropertyValue(c, property2);
                if (value == nextValue) continue;
                if (value != nullValue) {
                    mutableTrie.setRange(start2, c - 1, value);
                }
                start2 = c;
                value = nextValue;
            }
        }
        if (value != 0) {
            mutableTrie.setRange(start2, 0x10FFFF, value);
        }
        CodePointTrie.Type type2 = property2 == 4096 || property2 == 4101 ? CodePointTrie.Type.FAST : CodePointTrie.Type.SMALL;
        int max = UCharacter.getIntPropertyMaxValue(property2);
        CodePointTrie.ValueWidth valueWidth = max <= 255 ? CodePointTrie.ValueWidth.BITS_8 : (max <= 65535 ? CodePointTrie.ValueWidth.BITS_16 : CodePointTrie.ValueWidth.BITS_32);
        return mutableTrie.buildImmutable(type2, valueWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final UnicodeSet getBinaryPropertySet(int property2) {
        if (property2 < 0 || 72 <= property2) {
            throw new IllegalArgumentException("" + property2 + " is not a constant for a UProperty binary property");
        }
        UnicodeSet[] unicodeSetArray = sets;
        synchronized (sets) {
            UnicodeSet set2 = sets[property2];
            if (set2 == null) {
                CharacterProperties.sets[property2] = set2 = CharacterProperties.makeSet(property2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return set2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CodePointMap getIntPropertyMap(int property2) {
        if (property2 < 4096 || 4121 <= property2) {
            throw new IllegalArgumentException("" + property2 + " is not a constant for a UProperty int property");
        }
        CodePointMap[] codePointMapArray = maps;
        synchronized (maps) {
            CodePointMap map2 = maps[property2 - 4096];
            if (map2 == null) {
                CharacterProperties.maps[property2 - 4096] = map2 = CharacterProperties.makeMap(property2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return map2;
        }
    }
}

