/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.ReplaceableString;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeMatcher;

public class UtilityExtensions {
    public static void appendToRule(StringBuffer rule, String text, boolean isLiteral, boolean escapeUnprintable, StringBuffer quoteBuf) {
        for (int i = 0; i < text.length(); ++i) {
            Utility.appendToRule(rule, text.charAt(i), isLiteral, escapeUnprintable, quoteBuf);
        }
    }

    public static void appendToRule(StringBuffer rule, UnicodeMatcher matcher, boolean escapeUnprintable, StringBuffer quoteBuf) {
        if (matcher != null) {
            UtilityExtensions.appendToRule(rule, matcher.toPattern(escapeUnprintable), true, escapeUnprintable, quoteBuf);
        }
    }

    public static String formatInput(ReplaceableString input2, Transliterator.Position pos) {
        StringBuffer appendTo = new StringBuffer();
        UtilityExtensions.formatInput(appendTo, input2, pos);
        return Utility.escape(appendTo.toString());
    }

    public static StringBuffer formatInput(StringBuffer appendTo, ReplaceableString input2, Transliterator.Position pos) {
        if (0 <= pos.contextStart && pos.contextStart <= pos.start && pos.start <= pos.limit && pos.limit <= pos.contextLimit && pos.contextLimit <= input2.length()) {
            String b = input2.substring(pos.contextStart, pos.start);
            String c = input2.substring(pos.start, pos.limit);
            String d = input2.substring(pos.limit, pos.contextLimit);
            appendTo.append('{').append(b).append('|').append(c).append('|').append(d).append('}');
        } else {
            appendTo.append("INVALID Position {cs=" + pos.contextStart + ", s=" + pos.start + ", l=" + pos.limit + ", cl=" + pos.contextLimit + "} on " + input2);
        }
        return appendTo;
    }

    public static String formatInput(Replaceable input2, Transliterator.Position pos) {
        return UtilityExtensions.formatInput((ReplaceableString)input2, pos);
    }

    public static StringBuffer formatInput(StringBuffer appendTo, Replaceable input2, Transliterator.Position pos) {
        return UtilityExtensions.formatInput(appendTo, (ReplaceableString)input2, pos);
    }
}

