/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.terminal.TerminalRecorder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0006\u00a8\u0006\u0007"}, d2={"asCssRules", "", "", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "escapeHtml", "outputAsHtml", "Lcom/github/ajalt/mordant/terminal/TerminalRecorder;", "mordant"})
public final class HtmlRendererKt {
    @NotNull
    public static final String outputAsHtml(@NotNull TerminalRecorder $this$outputAsHtml) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$outputAsHtml, "<this>");
        StringBuilder $this$outputAsHtml_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Lines lines = ParsingKt.parseText($this$outputAsHtml.output(), ConstantsKt.getDEFAULT_STYLE());
        StringBuilder stringBuilder2 = $this$outputAsHtml_u24lambda_u240.append("<html><body>");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
        $this$outputAsHtml_u24lambda_u240.append("<pre style=\"font-family: Menlo, Consolas, Monaco, Liberation Mono, Lucida Console, monospace\">");
        StringBuilder stringBuilder3 = $this$outputAsHtml_u24lambda_u240.append("<code>");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append('\\n')");
        for (Line line : lines.getLines()) {
            for (Span span : line) {
                String href = span.getStyle().getHyperlink();
                if (href != null) {
                    $this$outputAsHtml_u24lambda_u240.append("<a href=\"").append(href).append('\"');
                } else {
                    $this$outputAsHtml_u24lambda_u240.append("<span");
                }
                List<String> rules = HtmlRendererKt.asCssRules(span.getStyle());
                if (!((Collection)rules).isEmpty()) {
                    CollectionsKt.joinTo$default(rules, $this$outputAsHtml_u24lambda_u240, "; ", " style=\"", "\"", 0, null, null, 112, null);
                }
                $this$outputAsHtml_u24lambda_u240.append(">");
                $this$outputAsHtml_u24lambda_u240.append(HtmlRendererKt.escapeHtml(span.getText())).append("</span>");
            }
            Intrinsics.checkNotNullExpressionValue($this$outputAsHtml_u24lambda_u240.append('\n'), "append('\\n')");
        }
        StringBuilder stringBuilder4 = $this$outputAsHtml_u24lambda_u240.append("</code></pre>");
        Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append('\\n')");
        $this$outputAsHtml_u24lambda_u240.append("</body></html>");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final List<String> asCssRules(TextStyle $this$asCssRules) {
        Color it;
        List rules = new ArrayList();
        Pair<Color, Color> pair2 = Intrinsics.areEqual($this$asCssRules.getInverse(), true) ? TuplesKt.to($this$asCssRules.getBgColor(), $this$asCssRules.getColor()) : TuplesKt.to($this$asCssRules.getColor(), $this$asCssRules.getBgColor());
        Color fg = pair2.component1();
        Color bg = pair2.component2();
        Color color = fg;
        if (color != null) {
            it = color;
            boolean bl = false;
            rules.add("color: " + RGB.toHex$default(it.toSRGB(), false, null, 3, null));
        }
        Color color2 = bg;
        if (color2 != null) {
            it = color2;
            boolean bl = false;
            rules.add("background-color: " + RGB.toHex$default(it.toSRGB(), false, null, 3, null));
        }
        if (Intrinsics.areEqual($this$asCssRules.getBold(), true)) {
            rules.add("font-weight: bold");
        }
        if (Intrinsics.areEqual($this$asCssRules.getItalic(), true)) {
            rules.add("font-style: italic");
        }
        if (Intrinsics.areEqual($this$asCssRules.getUnderline(), true)) {
            rules.add("text-decoration: underline");
        }
        if (Intrinsics.areEqual($this$asCssRules.getDim(), true)) {
            rules.add("opacity: 0.5");
        }
        if (Intrinsics.areEqual($this$asCssRules.getStrikethrough(), true)) {
            rules.add("text-decoration: line-through");
        }
        return rules;
    }

    private static final String escapeHtml(String $this$escapeHtml) {
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default($this$escapeHtml, "&", "&amp;", false, 4, null), "<", "&lt;", false, 4, null), ">", "&gt;", false, 4, null), "\"", "&quot;", false, 4, null), "\\", "&#x27;", false, 4, null);
    }
}

