/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.transform.HueAdjustments;
import com.github.ajalt.colormath.transform.InterpolateKt;
import com.github.ajalt.colormath.transform.Interpolator;
import com.github.ajalt.colormath.transform.InterpolatorBuilder;
import com.github.ajalt.colormath.transform.InterpolatorBuilderImpl;
import com.github.ajalt.colormath.transform.PremultiplyKt;
import com.github.ajalt.colormath.transform.Stop;
import com.github.ajalt.colormath.transform.TransformKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u001aU\u0010\u0011\u001a\u00020\u00122\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r21\u0010\u0013\u001a-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001j\u0002`\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0002H\u0002\u001a<\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u000f2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u001a \u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a$\u0010\u001d\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u001e\u001a\u00020\u001f2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0005\u001a\u00020\u001fH\u0002\u001ah\u0010 \u001a\u0002H!\"\b\b\u0000\u0010!*\u00020\"*\u0002H!2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010\u000e\u001a\u00020\u000f23\b\u0002\u0010\u0013\u001a-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001j\u0002`\u0007\u00a2\u0006\u0002\u0010&\u001a9\u0010'\u001a\b\u0012\u0004\u0012\u0002H!0(\"\b\b\u0000\u0010!*\u00020\"*\b\u0012\u0004\u0012\u0002H!0\r2\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00120\u0001\u00a2\u0006\u0002\b+\u001aC\u0010'\u001a\b\u0012\u0004\u0012\u0002H!0(\"\b\b\u0000\u0010!*\u00020\"*\b\u0012\u0004\u0012\u0002H!0\r2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0-\"\u00020\"2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010.\u001a(\u0010/\u001a\b\u0012\u0004\u0012\u0002H!00\"\b\b\u0000\u0010!*\u00020\"*\b\u0012\u0004\u0012\u0002H!0(2\u0006\u00101\u001a\u000202\"A\u0010\u0000\u001a-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001j\u0002`\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\t*X\u00103\")\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012)\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001*,\u00104\"\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u00120\u0001\u00a2\u0006\u0002\b+2\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u00120\u0001\u00a2\u0006\u0002\b+\u00a8\u00066"}, d2={"alphaAdjustment", "Lkotlin/Function1;", "", "", "Lkotlin/ParameterName;", "name", "hues", "Lcom/github/ajalt/colormath/transform/ComponentAdjustment;", "getAlphaAdjustment$annotations", "()V", "div", "", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "premultiplyAlpha", "", "components", "fixupHues", "", "hueAdjustment", "entries", "Lcom/github/ajalt/colormath/transform/Stop;", "interpolateComponents", "l", "r", "out", "amount", "divideAlpha", "lerp", "mult", "requireComponentName", "", "interpolate", "T", "Lcom/github/ajalt/colormath/Color;", "other", "t", "", "(Lcom/github/ajalt/colormath/Color;Lcom/github/ajalt/colormath/Color;Ljava/lang/Number;ZLkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "interpolator", "Lcom/github/ajalt/colormath/transform/Interpolator;", "builder", "Lcom/github/ajalt/colormath/transform/InterpolatorBuilder;", "Lkotlin/ExtensionFunctionType;", "stops", "", "(Lcom/github/ajalt/colormath/ColorSpace;[Lcom/github/ajalt/colormath/Color;Z)Lcom/github/ajalt/colormath/transform/Interpolator;", "sequence", "Lkotlin/sequences/Sequence;", "length", "", "ComponentAdjustment", "InterpolatorStopBuilderContext", "Lcom/github/ajalt/colormath/transform/InterpolatorStopBuilder;", "colormath"})
@SourceDebugExtension(value={"SMAP\nInterpolate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpolate.kt\ncom/github/ajalt/colormath/transform/InterpolateKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,402:1\n1#2:403\n1549#3:404\n1620#3,3:405\n1864#3,3:408\n1747#3,3:411\n1549#3:414\n1620#3,3:415\n*S KotlinDebug\n*F\n+ 1 Interpolate.kt\ncom/github/ajalt/colormath/transform/InterpolateKt\n*L\n348#1:404\n348#1:405,3\n348#1:408,3\n369#1:411,3\n371#1:414\n371#1:415,3\n*E\n"})
public final class InterpolateKt {
    @NotNull
    private static final Function1<List<Float>, List<Float>> alphaAdjustment = alphaAdjustment.1.INSTANCE;

    @NotNull
    public static final <T extends Color> T interpolate(@NotNull T $this$interpolate, @NotNull Color other, @NotNull Number t, boolean premultiplyAlpha, @NotNull Function1<? super List<Float>, ? extends List<Float>> hueAdjustment) {
        Intrinsics.checkNotNullParameter($this$interpolate, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(t, "t");
        Intrinsics.checkNotNullParameter(hueAdjustment, "hueAdjustment");
        return TransformKt.map($this$interpolate, new Function2<ColorSpace<T>, float[], float[]>(premultiplyAlpha, other, hueAdjustment, t, $this$interpolate){
            final /* synthetic */ boolean $premultiplyAlpha;
            final /* synthetic */ Color $other;
            final /* synthetic */ Function1<List<Float>, List<Float>> $hueAdjustment;
            final /* synthetic */ Number $t;
            final /* synthetic */ T $this_interpolate;
            {
                this.$premultiplyAlpha = $premultiplyAlpha;
                this.$other = $other;
                this.$hueAdjustment = $hueAdjustment;
                this.$t = $t;
                this.$this_interpolate = $receiver;
                super(2);
            }

            @NotNull
            public final float[] invoke(@NotNull ColorSpace<T> $this$map, @NotNull float[] components) {
                Intrinsics.checkNotNullParameter($this$map, "$this$map");
                Intrinsics.checkNotNullParameter(components, "components");
                float[] l = InterpolateKt.access$mult($this$map, this.$premultiplyAlpha, components);
                float[] r = InterpolateKt.access$mult($this$map, this.$premultiplyAlpha, $this$map.convert(this.$other).toArray());
                Stop[] stopArray = new Stop[]{new Stop(l, 0.0f), new Stop(r, 1.0f)};
                InterpolateKt.access$fixupHues($this$map, this.$hueAdjustment, CollectionsKt.listOf(stopArray));
                return InterpolateKt.access$interpolateComponents(l, r, new float[components.length], this.$t.floatValue(), this.$premultiplyAlpha, this.$this_interpolate.getSpace());
            }
        });
    }

    public static /* synthetic */ Color interpolate$default(Color color, Color color2, Number number, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            function1 = HueAdjustments.INSTANCE.getShorter();
        }
        return InterpolateKt.interpolate(color, color2, number, bl, function1);
    }

    @NotNull
    public static final <T extends Color> Interpolator<T> interpolator(@NotNull ColorSpace<T> $this$interpolator, @NotNull Function1<? super InterpolatorBuilder, Unit> builder2) {
        Intrinsics.checkNotNullParameter($this$interpolator, "<this>");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        InterpolatorBuilderImpl<T> interpolatorBuilderImpl = new InterpolatorBuilderImpl<T>($this$interpolator);
        builder2.invoke(interpolatorBuilderImpl);
        return interpolatorBuilderImpl.build();
    }

    @NotNull
    public static final <T extends Color> Interpolator<T> interpolator(@NotNull ColorSpace<T> $this$interpolator, @NotNull Color[] stops, boolean premultiplyAlpha) {
        Intrinsics.checkNotNullParameter($this$interpolator, "<this>");
        Intrinsics.checkNotNullParameter(stops, "stops");
        if (!(stops.length > 1)) {
            boolean bl = false;
            String string = "interpolators require at least two stops";
            throw new IllegalArgumentException(string.toString());
        }
        return InterpolateKt.interpolator($this$interpolator, (Function1<? super InterpolatorBuilder, Unit>)new Function1<InterpolatorBuilder, Unit>(premultiplyAlpha, stops){
            final /* synthetic */ boolean $premultiplyAlpha;
            final /* synthetic */ Color[] $stops;
            {
                this.$premultiplyAlpha = $premultiplyAlpha;
                this.$stops = $stops;
                super(1);
            }

            public final void invoke(@NotNull InterpolatorBuilder $this$interpolator) {
                Intrinsics.checkNotNullParameter($this$interpolator, "$this$interpolator");
                $this$interpolator.setPremultiplyAlpha(this.$premultiplyAlpha);
                Color[] $this$forEach$iv = this.$stops;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    Color element$iv;
                    Color it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    InterpolatorBuilder.DefaultImpls.stop$default($this$interpolator, it, null, 2, null);
                }
            }
        });
    }

    public static /* synthetic */ Interpolator interpolator$default(ColorSpace colorSpace, Color[] colorArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return InterpolateKt.interpolator(colorSpace, colorArray, bl);
    }

    @NotNull
    public static final <T extends Color> Sequence<T> sequence(@NotNull Interpolator<T> $this$sequence, int length) {
        Intrinsics.checkNotNullParameter($this$sequence, "<this>");
        if (!(length > 1)) {
            boolean bl = false;
            String string = "length must be 2 or greater, was " + length;
            throw new IllegalArgumentException(string.toString());
        }
        return SequencesKt.map(CollectionsKt.asSequence(RangesKt.until(0, length)), new Function1<Integer, T>($this$sequence, length){
            final /* synthetic */ Interpolator<T> $this_sequence;
            final /* synthetic */ int $length;
            {
                this.$this_sequence = $receiver;
                this.$length = $length;
                super(1);
            }

            @NotNull
            public final T invoke(int it) {
                return this.$this_sequence.interpolate(Float.valueOf((float)it / (float)(this.$length - 1)));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void fixupHues(ColorSpace<?> space, Function1<? super List<Float>, ? extends List<Float>> hueAdjustment, List<Stop> entries2) {
        Iterator<ColorComponentInfo> iterator2 = space.getComponents().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int i = n++;
            ColorComponentInfo c = iterator2.next();
            if (!c.isPolar()) continue;
            Iterable iterable = entries2;
            Function1<? super List<Float>, ? extends List<Float>> function1 = hueAdjustment;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Stop stop2 = (Stop)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf(it.getComponents()[i]));
            }
            Iterable $this$forEachIndexed$iv = function1.invoke((List)destination$iv$iv);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void hue;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float item$iv$iv = ((Number)item$iv).floatValue();
                int j = n2;
                boolean bl = false;
                entries2.get((int)j).getComponents()[i] = hue;
            }
        }
    }

    private static final float[] interpolateComponents(float[] l, float[] r, float[] out2, float amount, boolean divideAlpha2, ColorSpace<?> space) {
        int n = out2.length;
        for (int i = 0; i < n; ++i) {
            out2[i] = InterpolateKt.lerp(l[i], r[i], amount);
        }
        return InterpolateKt.div(space, divideAlpha2, out2);
    }

    /*
     * WARNING - void declaration
     */
    private static final String requireComponentName(ColorSpace<?> space, String name) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = space.getComponents();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ColorComponentInfo it = (ColorComponentInfo)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals(it.getName(), name, true)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (!bl) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl3 = false;
            Iterable iterable = space.getComponents();
            StringBuilder stringBuilder = new StringBuilder().append("Unknown component name \"").append(name).append("\" for color model ").append(space.getName()).append(". Valid names are ");
            boolean $i$f$map = false;
            void bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColorComponentInfo colorComponentInfo = (ColorComponentInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getName());
            }
            String string = stringBuilder.append((List)destination$iv$iv).toString();
            throw new IllegalArgumentException(string.toString());
        }
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string;
    }

    private static /* synthetic */ void getAlphaAdjustment$annotations() {
    }

    private static final float[] mult(ColorSpace<?> space, boolean premultiplyAlpha, float[] components) {
        if (premultiplyAlpha) {
            PremultiplyKt.multiplyAlphaInPlace(space, components);
        }
        return components;
    }

    private static final float[] div(ColorSpace<?> space, boolean premultiplyAlpha, float[] components) {
        if (premultiplyAlpha) {
            PremultiplyKt.divideAlphaInPlace(space, components);
        }
        return components;
    }

    private static final float lerp(float l, float r, float amount) {
        return Float.isNaN(l) ? r : (Float.isNaN(r) ? l : l + amount * (r - l));
    }

    public static final /* synthetic */ String access$requireComponentName(ColorSpace space, String name) {
        return InterpolateKt.requireComponentName(space, name);
    }

    public static final /* synthetic */ float[] access$div(ColorSpace space, boolean premultiplyAlpha, float[] components) {
        return InterpolateKt.div(space, premultiplyAlpha, components);
    }

    public static final /* synthetic */ Function1 access$getAlphaAdjustment$p() {
        return alphaAdjustment;
    }

    public static final /* synthetic */ float access$lerp(float l, float r, float amount) {
        return InterpolateKt.lerp(l, r, amount);
    }

    public static final /* synthetic */ float[] access$mult(ColorSpace space, boolean premultiplyAlpha, float[] components) {
        return InterpolateKt.mult(space, premultiplyAlpha, components);
    }

    public static final /* synthetic */ void access$fixupHues(ColorSpace space, Function1 hueAdjustment, List entries2) {
        InterpolateKt.fixupHues(space, hueAdjustment, entries2);
    }

    public static final /* synthetic */ float[] access$interpolateComponents(float[] l, float[] r, float[] out2, float amount, boolean divideAlpha2, ColorSpace space) {
        return InterpolateKt.interpolateComponents(l, r, out2, amount, divideAlpha2, space);
    }
}

