/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.ConstantsKt;
import com.github.ajalt.colormath.internal.Matrix;
import com.github.ajalt.colormath.internal.MatrixKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.ICtCpKt;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LABKt;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.LUVKt;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpaces;
import com.github.ajalt.colormath.model.XYZColorSpace;
import com.github.ajalt.colormath.model.XYZColorSpaces;
import com.github.ajalt.colormath.model.XYZKt;
import com.github.ajalt.colormath.model.xyY;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 A2\u00020\u0001:\u0001AB/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J-\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J;\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\b\u0010'\u001a\u00020\u0013H\u0016J\u0006\u0010(\u001a\u00020)J1\u0010*\u001a\u0002H+\"\b\b\u0000\u0010+*\u00020\u00012\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H+0-\u00a2\u0006\u0002\b.H\u0082\b\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000209H\u0016J\u000e\u0010:\u001a\u00020;2\u0006\u0010\u0007\u001a\u00020<J\b\u0010=\u001a\u00020;H\u0016J\t\u0010>\u001a\u00020?H\u00d6\u0001J\b\u0010@\u001a\u00020\u0000H\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006B"}, d2={"Lcom/github/ajalt/colormath/model/XYZ;", "Lcom/github/ajalt/colormath/Color;", "x", "", "y", "z", "alpha", "space", "Lcom/github/ajalt/colormath/model/XYZColorSpace;", "(FFFFLcom/github/ajalt/colormath/model/XYZColorSpace;)V", "getAlpha", "()F", "getSpace", "()Lcom/github/ajalt/colormath/model/XYZColorSpace;", "getX", "getY", "getZ", "adaptTo", "transformationMatrix", "", "inverseTransformationMatrix", "adaptToM", "m", "Lcom/github/ajalt/colormath/internal/Matrix;", "mi", "adaptToM-bk-Ujj4", "(Lcom/github/ajalt/colormath/model/XYZColorSpace;[F[F)Lcom/github/ajalt/colormath/model/XYZ;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "toCIExyY", "Lcom/github/ajalt/colormath/model/xyY;", "toD65", "T", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "toICtCp", "Lcom/github/ajalt/colormath/model/ICtCp;", "toJzAzBz", "Lcom/github/ajalt/colormath/model/JzAzBz;", "toLAB", "Lcom/github/ajalt/colormath/model/LAB;", "toLUV", "Lcom/github/ajalt/colormath/model/LUV;", "toOklab", "Lcom/github/ajalt/colormath/model/Oklab;", "toRGB", "Lcom/github/ajalt/colormath/model/RGB;", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "toSRGB", "toString", "", "toXYZ", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nXYZ.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XYZ.kt\ncom/github/ajalt/colormath/model/XYZ\n+ 2 Matrix.kt\ncom/github/ajalt/colormath/internal/MatrixKt\n*L\n1#1,221:1\n203#1:230\n203#1:231\n70#2,4:222\n70#2,4:226\n*S KotlinDebug\n*F\n+ 1 XYZ.kt\ncom/github/ajalt/colormath/model/XYZ\n*L\n150#1:230\n167#1:231\n93#1:222,4\n102#1:226,4\n*E\n"})
public final class XYZ
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private final float z;
    private final float alpha;
    @NotNull
    private final XYZColorSpace space;

    public XYZ(float x, float y, float z, float alpha, @NotNull XYZColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        this.x = x;
        this.y = y;
        this.z = z;
        this.alpha = alpha;
        this.space = space;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getZ() {
        return this.z;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @NotNull
    public XYZColorSpace getSpace() {
        return this.space;
    }

    @NotNull
    public final XYZ adaptTo(@NotNull XYZColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        return this.adaptToM-bk-Ujj4(space, ConstantsKt.getCAT02_XYZ_TO_LMS(), ConstantsKt.getCAT02_LMS_TO_XYZ());
    }

    @NotNull
    public final XYZ adaptTo(@NotNull XYZColorSpace space, @NotNull float[] transformationMatrix) {
        Intrinsics.checkNotNullParameter(space, "space");
        Intrinsics.checkNotNullParameter(transformationMatrix, "transformationMatrix");
        return this.adaptToM-bk-Ujj4(space, Matrix.constructor-impl(transformationMatrix), MatrixKt.inverse-M2Qqt3Q$default(Matrix.constructor-impl(transformationMatrix), false, 1, null));
    }

    @NotNull
    public final XYZ adaptTo(@NotNull XYZColorSpace space, @NotNull float[] transformationMatrix, @NotNull float[] inverseTransformationMatrix) {
        Intrinsics.checkNotNullParameter(space, "space");
        Intrinsics.checkNotNullParameter(transformationMatrix, "transformationMatrix");
        Intrinsics.checkNotNullParameter(inverseTransformationMatrix, "inverseTransformationMatrix");
        return this.adaptToM-bk-Ujj4(space, Matrix.constructor-impl(transformationMatrix), Matrix.constructor-impl(inverseTransformationMatrix));
    }

    /*
     * WARNING - void declaration
     */
    private final XYZ adaptToM-bk-Ujj4(XYZColorSpace space, float[] m, float[] mi) {
        void zz;
        void yy;
        void v1$iv;
        void v0$iv;
        void $this$dot_u2dlwRpc58$iv;
        float[] transform2;
        if (Intrinsics.areEqual(space.getWhitePoint(), this.getSpace().getWhitePoint())) {
            return this;
        }
        float[] fArray = transform2 = XYZKt.chromaticAdaptationMatrix-8v-9jzY(space, this.getSpace().getWhitePoint().getChromaticity(), m, mi);
        float f = this.x;
        float f2 = this.y;
        float v2$iv = this.z;
        boolean bl = false;
        float f3 = Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 0, 2) * v0$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 1, 2) * v1$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 2, 2) * v2$iv;
        float f4 = Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 0, 1) * v0$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 1, 1) * v1$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 2, 1) * v2$iv;
        float xx = Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 0, 0) * v0$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 1, 0) * v1$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 2, 0) * v2$iv;
        boolean bl2 = false;
        return space.invoke(xx, (float)yy, (float)zz, this.getAlpha());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RGB toRGB(@NotNull RGBColorSpace space) {
        void b;
        void g;
        Intrinsics.checkNotNullParameter(space, "space");
        XYZ xYZ = this.adaptTo(XYZKt.XYZColorSpace(space.getWhitePoint()));
        float x = xYZ.component1();
        float y = xYZ.component2();
        float z = xYZ.component3();
        RGBColorSpace.TransferFunctions f = space.getTransferFunctions();
        float[] $this$dot_u2dlwRpc58$iv = Matrix.constructor-impl(space.getMatrixFromXyz());
        boolean bl = false;
        float f2 = Matrix.get-impl($this$dot_u2dlwRpc58$iv, 0, 2) * x + Matrix.get-impl($this$dot_u2dlwRpc58$iv, 1, 2) * y + Matrix.get-impl($this$dot_u2dlwRpc58$iv, 2, 2) * z;
        float f3 = Matrix.get-impl($this$dot_u2dlwRpc58$iv, 0, 1) * x + Matrix.get-impl($this$dot_u2dlwRpc58$iv, 1, 1) * y + Matrix.get-impl($this$dot_u2dlwRpc58$iv, 2, 1) * z;
        float r = Matrix.get-impl($this$dot_u2dlwRpc58$iv, 0, 0) * x + Matrix.get-impl($this$dot_u2dlwRpc58$iv, 1, 0) * y + Matrix.get-impl($this$dot_u2dlwRpc58$iv, 2, 0) * z;
        boolean bl2 = false;
        return space.invoke(f.oetf(r), f.oetf((float)g), f.oetf((float)b), this.getAlpha());
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.toRGB(RGBColorSpaces.INSTANCE.getSRGB());
    }

    @Override
    @NotNull
    public LAB toLAB() {
        double fx = XYZ.toLAB$f((double)this.x / (double)this.getSpace().getWhitePoint().getChromaticity().getAbsoluteX());
        double fy = XYZ.toLAB$f((double)this.y / (double)this.getSpace().getWhitePoint().getChromaticity().getAbsoluteY());
        double fz = XYZ.toLAB$f((double)this.z / (double)this.getSpace().getWhitePoint().getChromaticity().getAbsoluteZ());
        double l = (double)116 * fy - (double)16;
        double a = (double)500 * (fx - fy);
        double b = (double)200 * (fy - fz);
        return LABKt.LABColorSpace(this.getSpace().getWhitePoint()).invoke(l, a, b, Float.valueOf(this.getAlpha()));
    }

    @Override
    @NotNull
    public LUV toLUV() {
        xyY wp = this.getSpace().getWhitePoint().getChromaticity();
        double denominator = (double)this.x + 15.0 * (double)this.y + 3.0 * (double)this.z;
        double uPrime = denominator == 0.0 ? 0.0 : (double)((float)4 * this.x) / denominator;
        double vPrime = denominator == 0.0 ? 0.0 : (double)((float)9 * this.y) / denominator;
        double denominatorReference = (double)wp.getAbsoluteX() + 15.0 * (double)wp.getAbsoluteY() + 3.0 * (double)wp.getAbsoluteZ();
        double uPrimeReference = 4.0 * (double)wp.getAbsoluteX() / denominatorReference;
        double vPrimeReference = 9.0 * (double)wp.getAbsoluteY() / denominatorReference;
        double yr = (double)this.y / (double)wp.getAbsoluteY();
        double l = yr > 0.008856451679035631 ? (double)116 * Math.cbrt(yr) - (double)16 : 903.2962962962963 * yr;
        double u = 13.0 * l * (uPrime - uPrimeReference);
        double v = 13.0 * l * (vPrime - vPrimeReference);
        return LUVKt.LUVColorSpace(this.getSpace().getWhitePoint()).invoke(RangesKt.coerceIn(l, 0.0, 100.0), u, v, Float.valueOf(this.getAlpha()));
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        XYZ this_$iv = this;
        boolean $i$f$toD65 = false;
        if (Intrinsics.areEqual(this_$iv.getSpace(), XYZColorSpaces.INSTANCE.getXYZ65())) {
            XYZ $this$toOklab_u24lambda_u242 = this_$iv;
            boolean bl = false;
            double l = 0.8189330101 * (double)$this$toOklab_u24lambda_u242.x + 0.3618667424 * (double)$this$toOklab_u24lambda_u242.y - 0.1288597137 * (double)$this$toOklab_u24lambda_u242.z;
            double m = 0.0329845436 * (double)$this$toOklab_u24lambda_u242.x + 0.9293118715 * (double)$this$toOklab_u24lambda_u242.y + 0.0361456387 * (double)$this$toOklab_u24lambda_u242.z;
            double s = 0.0482003018 * (double)$this$toOklab_u24lambda_u242.x + 0.2643662691 * (double)$this$toOklab_u24lambda_u242.y + 0.633851707 * (double)$this$toOklab_u24lambda_u242.z;
            double ll = Math.cbrt(l);
            double mm = Math.cbrt(m);
            double ss = Math.cbrt(s);
            return new Oklab(0.2104542553 * ll + 0.793617785 * mm - 0.0040720468 * ss, 1.9779984951 * ll - 2.428592205 * mm + 0.4505937099 * ss, 0.0259040371 * ll + 0.7827717662 * mm - 0.808675766 * ss, Float.valueOf($this$toOklab_u24lambda_u242.getAlpha()));
        }
        XYZ $this$toOklab_u24lambda_u242 = this_$iv.adaptTo(XYZColorSpaces.INSTANCE.getXYZ65());
        boolean bl = false;
        double l = 0.8189330101 * (double)$this$toOklab_u24lambda_u242.x + 0.3618667424 * (double)$this$toOklab_u24lambda_u242.y - 0.1288597137 * (double)$this$toOklab_u24lambda_u242.z;
        double m = 0.0329845436 * (double)$this$toOklab_u24lambda_u242.x + 0.9293118715 * (double)$this$toOklab_u24lambda_u242.y + 0.0361456387 * (double)$this$toOklab_u24lambda_u242.z;
        double s = 0.0482003018 * (double)$this$toOklab_u24lambda_u242.x + 0.2643662691 * (double)$this$toOklab_u24lambda_u242.y + 0.633851707 * (double)$this$toOklab_u24lambda_u242.z;
        double ll = Math.cbrt(l);
        double mm = Math.cbrt(m);
        double ss = Math.cbrt(s);
        return new Oklab(0.2104542553 * ll + 0.793617785 * mm - 0.0040720468 * ss, 1.9779984951 * ll - 2.428592205 * mm + 0.4505937099 * ss, 0.0259040371 * ll + 0.7827717662 * mm - 0.808675766 * ss, Float.valueOf($this$toOklab_u24lambda_u242.getAlpha()));
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        XYZ this_$iv = this;
        boolean $i$f$toD65 = false;
        if (Intrinsics.areEqual(this_$iv.getSpace(), XYZColorSpaces.INSTANCE.getXYZ65())) {
            XYZ $this$toJzAzBz_u24lambda_u243 = this_$iv;
            boolean bl = false;
            double lp = XYZ.toJzAzBz$lambda$3$pq(0.674207838 * (double)$this$toJzAzBz_u24lambda_u243.x + 0.38279934 * (double)$this$toJzAzBz_u24lambda_u243.y - 0.047570458 * (double)$this$toJzAzBz_u24lambda_u243.z);
            double mp = XYZ.toJzAzBz$lambda$3$pq(0.14928416 * (double)$this$toJzAzBz_u24lambda_u243.x + 0.73962834 * (double)$this$toJzAzBz_u24lambda_u243.y + 0.0833273 * (double)$this$toJzAzBz_u24lambda_u243.z);
            double sp = XYZ.toJzAzBz$lambda$3$pq(0.07094108 * (double)$this$toJzAzBz_u24lambda_u243.x + 0.174768 * (double)$this$toJzAzBz_u24lambda_u243.y + 0.67097002 * (double)$this$toJzAzBz_u24lambda_u243.z);
            double iz = 0.5 * (lp + mp);
            return new JzAzBz(0.44 * iz / (1.0 - 0.56 * iz) - 1.6295499532821565E-11, 3.524 * lp - 4.066708 * mp + 0.542708 * sp, 0.199076 * lp + 1.096799 * mp - 1.295875 * sp, Float.valueOf($this$toJzAzBz_u24lambda_u243.getAlpha()));
        }
        XYZ $this$toJzAzBz_u24lambda_u243 = this_$iv.adaptTo(XYZColorSpaces.INSTANCE.getXYZ65());
        boolean bl = false;
        double lp = XYZ.toJzAzBz$lambda$3$pq(0.674207838 * (double)$this$toJzAzBz_u24lambda_u243.x + 0.38279934 * (double)$this$toJzAzBz_u24lambda_u243.y - 0.047570458 * (double)$this$toJzAzBz_u24lambda_u243.z);
        double mp = XYZ.toJzAzBz$lambda$3$pq(0.14928416 * (double)$this$toJzAzBz_u24lambda_u243.x + 0.73962834 * (double)$this$toJzAzBz_u24lambda_u243.y + 0.0833273 * (double)$this$toJzAzBz_u24lambda_u243.z);
        double sp = XYZ.toJzAzBz$lambda$3$pq(0.07094108 * (double)$this$toJzAzBz_u24lambda_u243.x + 0.174768 * (double)$this$toJzAzBz_u24lambda_u243.y + 0.67097002 * (double)$this$toJzAzBz_u24lambda_u243.z);
        double iz = 0.5 * (lp + mp);
        return new JzAzBz(0.44 * iz / (1.0 - 0.56 * iz) - 1.6295499532821565E-11, 3.524 * lp - 4.066708 * mp + 0.542708 * sp, 0.199076 * lp + 1.096799 * mp - 1.295875 * sp, Float.valueOf($this$toJzAzBz_u24lambda_u243.getAlpha()));
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return ICtCpKt.convertXYZToICtCp(this);
    }

    @NotNull
    public final xyY toCIExyY() {
        if (this.x == 0.0f && this.y == 0.0f && this.z == 0.0f) {
            return new xyY(this.getSpace().getWhitePoint().getChromaticity().getX(), this.getSpace().getWhitePoint().getChromaticity().getY(), 0.0f);
        }
        float sum = this.x + this.y + this.z;
        return new xyY(this.x / sum, this.y / sum, this.y);
    }

    private final <T extends Color> T toD65(Function1<? super XYZ, ? extends T> block2) {
        boolean $i$f$toD65 = false;
        return (T)(Intrinsics.areEqual(this.getSpace(), XYZColorSpaces.INSTANCE.getXYZ65()) ? (Color)block2.invoke(this) : (Color)block2.invoke(this.adaptTo(XYZColorSpaces.INSTANCE.getXYZ65())));
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.x, this.y, this.z, this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final XYZColorSpace component5() {
        return this.space;
    }

    @NotNull
    public final XYZ copy(float x, float y, float z, float alpha, @NotNull XYZColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        return new XYZ(x, y, z, alpha, space);
    }

    public static /* synthetic */ XYZ copy$default(XYZ xYZ, float f, float f2, float f3, float f4, XYZColorSpace xYZColorSpace, int n, Object object) {
        if ((n & 1) != 0) {
            f = xYZ.x;
        }
        if ((n & 2) != 0) {
            f2 = xYZ.y;
        }
        if ((n & 4) != 0) {
            f3 = xYZ.z;
        }
        if ((n & 8) != 0) {
            f4 = xYZ.alpha;
        }
        if ((n & 0x10) != 0) {
            xYZColorSpace = xYZ.space;
        }
        return xYZ.copy(f, f2, f3, f4, xYZColorSpace);
    }

    @NotNull
    public String toString() {
        return "XYZ(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", alpha=" + this.alpha + ", space=" + this.space + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.x);
        result2 = result2 * 31 + Float.hashCode(this.y);
        result2 = result2 * 31 + Float.hashCode(this.z);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        result2 = result2 * 31 + this.space.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XYZ)) {
            return false;
        }
        XYZ xYZ = (XYZ)other;
        if (Float.compare(this.x, xYZ.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, xYZ.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, xYZ.z) != 0) {
            return false;
        }
        if (Float.compare(this.alpha, xYZ.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.space, xYZ.space);
    }

    private static final double toLAB$f(double t) {
        return t > 0.008856451679035631 ? Math.cbrt(t) : (t * 903.2962962962963 + (double)16) / (double)116;
    }

    private static final double toJzAzBz$lambda$3$pq(double x) {
        double xx = Math.pow(x * 1.0E-4, 0.1593017578125);
        double v = Math.pow((0.8359375 + 18.8515625 * xx) / (1.0 + 18.6875 * xx), 134.034375);
        return Double.isNaN(v) ? 0.0 : v;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0011\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0015H\u0096\u0001J+\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u0018H\u0096\u0003J+\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001c2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0096\u0003R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/github/ajalt/colormath/model/XYZ$Companion;", "Lcom/github/ajalt/colormath/model/XYZColorSpace;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "convert", "Lcom/github/ajalt/colormath/model/XYZ;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "invoke", "x", "", "y", "z", "alpha", "", "colormath"})
    public static final class Companion
    implements XYZColorSpace {
        private final /* synthetic */ XYZColorSpace $$delegate_0;

        private Companion() {
            this.$$delegate_0 = XYZColorSpaces.INSTANCE.getXYZ65();
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return this.$$delegate_0.getComponents();
        }

        @Override
        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        @Override
        @NotNull
        public WhitePoint getWhitePoint() {
            return this.$$delegate_0.getWhitePoint();
        }

        @Override
        @NotNull
        public XYZ convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return (XYZ)this.$$delegate_0.convert(color);
        }

        @Override
        @NotNull
        public XYZ create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter(components, "components");
            return (XYZ)this.$$delegate_0.create(components);
        }

        @Override
        @NotNull
        public XYZ invoke(float x, float y, float z, float alpha) {
            return this.$$delegate_0.invoke(x, y, z, alpha);
        }

        @Override
        @NotNull
        public XYZ invoke(@NotNull Number x, @NotNull Number y, @NotNull Number z, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter(x, "x");
            Intrinsics.checkNotNullParameter(y, "y");
            Intrinsics.checkNotNullParameter(z, "z");
            Intrinsics.checkNotNullParameter(alpha, "alpha");
            return this.$$delegate_0.invoke(x, y, z, alpha);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

