/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.calculate;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorKt;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpaces;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\u001a+\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a-\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a#\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\t\u001a\u0012\u0010\n\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a\n\u0010\f\u001a\u00020\u0005*\u00020\u0001\u00a8\u0006\r"}, d2={"firstWithContrast", "Lcom/github/ajalt/colormath/Color;", "colors", "", "targetContrast", "", "(Lcom/github/ajalt/colormath/Color;[Lcom/github/ajalt/colormath/Color;F)Lcom/github/ajalt/colormath/Color;", "firstWithContrastOrNull", "mostContrasting", "(Lcom/github/ajalt/colormath/Color;[Lcom/github/ajalt/colormath/Color;)Lcom/github/ajalt/colormath/Color;", "wcagContrastRatio", "other", "wcagLuminance", "colormath"})
@SourceDebugExtension(value={"SMAP\nContrast.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Contrast.kt\ncom/github/ajalt/colormath/calculate/ContrastKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1#2:69\n14166#3,14:70\n1282#3,2:84\n1282#3,2:86\n1963#4,14:88\n*S KotlinDebug\n*F\n+ 1 Contrast.kt\ncom/github/ajalt/colormath/calculate/ContrastKt\n*L\n41#1:70,14\n53#1:84,2\n65#1:86,2\n66#1:88,14\n*E\n"})
public final class ContrastKt {
    public static final float wcagLuminance(@NotNull Color $this$wcagLuminance) {
        Intrinsics.checkNotNullParameter($this$wcagLuminance, "<this>");
        RGB rGB = (RGB)ColorKt.convertTo($this$wcagLuminance, RGBColorSpaces.INSTANCE.getLinearSRGB());
        float rs = rGB.component1();
        float gs = rGB.component2();
        float bs = rGB.component3();
        return (float)(0.2126 * (double)rs + 0.7152 * (double)gs + 0.0722 * (double)bs);
    }

    public static final float wcagContrastRatio(@NotNull Color $this$wcagContrastRatio, @NotNull Color other) {
        Intrinsics.checkNotNullParameter($this$wcagContrastRatio, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        float l = ContrastKt.wcagLuminance($this$wcagContrastRatio);
        float r = ContrastKt.wcagLuminance(other);
        return (float)(((double)Math.max(l, r) + 0.05) / ((double)Math.min(l, r) + 0.05));
    }

    @NotNull
    public static final Color mostContrasting(@NotNull Color $this$mostContrasting, Color ... colors) {
        Color color;
        Intrinsics.checkNotNullParameter($this$mostContrasting, "<this>");
        Intrinsics.checkNotNullParameter(colors, "colors");
        if (!(!(colors.length == 0))) {
            boolean $i$a$-require-ContrastKt$mostContrasting$22 = false;
            String $i$a$-require-ContrastKt$mostContrasting$22 = "colors cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ContrastKt$mostContrasting$22.toString());
        }
        Color[] $this$maxByOrNull$iv = colors;
        boolean $i$f$maxByOrNull = false;
        if ($this$maxByOrNull$iv.length == 0) {
            color = null;
        } else {
            Color maxElem$iv = $this$maxByOrNull$iv[0];
            int lastIndex$iv = ArraysKt.getLastIndex($this$maxByOrNull$iv);
            if (lastIndex$iv == 0) {
                color = maxElem$iv;
            } else {
                Color it = maxElem$iv;
                boolean bl = false;
                float maxValue$iv = ContrastKt.wcagContrastRatio($this$mostContrasting, it);
                IntIterator intIterator = new IntRange(1, lastIndex$iv).iterator();
                while (intIterator.hasNext()) {
                    Color e$iv;
                    int i$iv = intIterator.nextInt();
                    Color it2 = e$iv = $this$maxByOrNull$iv[i$iv];
                    $i$a$-maxByOrNull-ContrastKt$mostContrasting$2 = false;
                    float v$iv = ContrastKt.wcagContrastRatio($this$mostContrasting, it2);
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                }
                color = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(color);
        return color;
    }

    @Nullable
    public static final Color firstWithContrastOrNull(@NotNull Color $this$firstWithContrastOrNull, @NotNull Color[] colors, float targetContrast) {
        Color color;
        block2: {
            Intrinsics.checkNotNullParameter($this$firstWithContrastOrNull, "<this>");
            Intrinsics.checkNotNullParameter(colors, "colors");
            if (!(!(colors.length == 0))) {
                boolean $i$a$-require-ContrastKt$firstWithContrastOrNull$22 = false;
                String $i$a$-require-ContrastKt$firstWithContrastOrNull$22 = "colors cannot be empty";
                throw new IllegalArgumentException($i$a$-require-ContrastKt$firstWithContrastOrNull$22.toString());
            }
            Color[] $this$firstOrNull$iv = colors;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Color element$iv;
                Color it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!(ContrastKt.wcagContrastRatio($this$firstWithContrastOrNull, it) >= targetContrast)) continue;
                color = element$iv;
                break block2;
            }
            color = null;
        }
        return color;
    }

    @NotNull
    public static final Color firstWithContrast(@NotNull Color $this$firstWithContrast, @NotNull Color[] colors, float targetContrast) {
        Color color;
        Color color2;
        Color[] $this$firstOrNull$iv;
        block8: {
            Intrinsics.checkNotNullParameter($this$firstWithContrast, "<this>");
            Intrinsics.checkNotNullParameter(colors, "colors");
            if (!(!(colors.length == 0))) {
                boolean $i$a$-require-ContrastKt$firstWithContrast$22 = false;
                String $i$a$-require-ContrastKt$firstWithContrast$22 = "colors cannot be empty";
                throw new IllegalArgumentException($i$a$-require-ContrastKt$firstWithContrast$22.toString());
            }
            $this$firstOrNull$iv = colors;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Color element$iv;
                Color it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!(ContrastKt.wcagContrastRatio($this$firstWithContrast, it) >= targetContrast)) continue;
                color2 = element$iv;
                break block8;
            }
            color2 = color = null;
        }
        if (color2 == null) {
            Object v2;
            $this$firstOrNull$iv = new RGB[]{RGBColorSpace.DefaultImpls.invoke$default((RGBColorSpace)RGB.Companion, 0.0f, 0.0f, 0.0f, 0.0f, 8, null), RGBColorSpace.DefaultImpls.invoke$default((RGBColorSpace)RGB.Companion, 1.0f, 1.0f, 1.0f, 0.0f, 8, null)};
            Iterable $this$maxByOrNull$iv = CollectionsKt.listOf($this$firstOrNull$iv);
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = maxElem$iv;
                } else {
                    RGB it = (RGB)maxElem$iv;
                    boolean bl = false;
                    float maxValue$iv = ContrastKt.wcagContrastRatio($this$firstWithContrast, it);
                    do {
                        Object e$iv = iterator$iv.next();
                        RGB it2 = (RGB)e$iv;
                        $i$a$-maxByOrNull-ContrastKt$firstWithContrast$3 = false;
                        float v$iv = ContrastKt.wcagContrastRatio($this$firstWithContrast, it2);
                        if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v2);
            color = v2;
        }
        return color;
    }
}

