/*
 * Decompiled with CFR 0.152.
 */
package chapi.ast.kotlinast;

import chapi.ast.antlr.KotlinParser;
import chapi.ast.kotlinast.KotlinBasicIdentListener;
import chapi.domain.core.CallType;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeField;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodeImport;
import chapi.domain.core.CodePosition;
import chapi.domain.core.CodeProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\f\u0010 \u001a\u00020\u0012*\u00020\u0012H\u0002J\u0016\u0010!\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0016\u0010\"\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020#H\u0002J\u0016\u0010$\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020%H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lchapi/ast/kotlinast/KotlinFullIdentListener;", "Lchapi/ast/kotlinast/KotlinBasicIdentListener;", "fileName", "", "(Ljava/lang/String;)V", "VARIABLE_POOL", "", "VAR_IN_STRING", "Lkotlin/text/Regex;", "postClassHandler", "", "Lkotlin/Function1;", "Lchapi/domain/core/CodeDataStruct;", "", "buildClass", "ctx", "Lchapi/ast/antlr/KotlinParser$ClassDeclarationContext;", "buildFunctionCall", "Lchapi/domain/core/CodeCall;", "it", "Lchapi/ast/antlr/KotlinParser$StatementContext;", "enterPostfixUnaryExpression", "Lchapi/ast/antlr/KotlinParser$PostfixUnaryExpressionContext;", "enterPropertyDeclaration", "Lchapi/ast/antlr/KotlinParser$PropertyDeclarationContext;", "parseParameter", "Lchapi/domain/core/CodeProperty;", "text", "textFromPrimaryExpr", "child", "Lchapi/ast/antlr/KotlinParser$PrimaryExpressionContext;", "typeFromText", "refineIfExistsCreator", "refineWithClass", "refineWithField", "Lchapi/domain/core/CodeField;", "refineWithImport", "Lchapi/domain/core/CodeImport;", "chapi-ast-kotlin"})
public class KotlinFullIdentListener
extends KotlinBasicIdentListener {
    @NotNull
    private final List<Function1<CodeDataStruct, Unit>> postClassHandler;
    @NotNull
    private Map<String, String> VARIABLE_POOL;
    @NotNull
    private final Regex VAR_IN_STRING;

    public KotlinFullIdentListener(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        super(fileName);
        this.postClassHandler = new ArrayList();
        this.VARIABLE_POOL = new LinkedHashMap();
        this.VAR_IN_STRING = new Regex("(\\$[a-zA-Z_]+)");
    }

    private final CodeCall buildFunctionCall(KotlinParser.StatementContext it) {
        Regex regex = new Regex("(\\w+\\.?)+\\((.*)\\)");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue(string, "it.text");
        MatchResult matchResult = Regex.find$default(regex, string, 0, 2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result2 = matchResult;
        String matchedExpression = result2.getValue();
        String functionName = result2.getGroupValues().get(1);
        List<CodeProperty> parameters2 = CollectionsKt.listOf(this.parseParameter(result2.getGroupValues().get(2)));
        MatchGroup matchGroup = result2.getGroups().get(0);
        Intrinsics.checkNotNull(matchGroup);
        int matchedStart = matchGroup.getRange().getFirst();
        MatchGroup matchGroup2 = result2.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup2);
        int functionStart = matchGroup2.getRange().getFirst();
        String string2 = matchedExpression.substring(0, Math.max(functionStart - matchedStart - 1, 0));
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        String nodeName = string2;
        return this.refineIfExistsCreator(new CodeCall(null, Character.isUpperCase(functionName.charAt(0)) ? CallType.CREATOR : CallType.FUNCTION, nodeName, functionName, parameters2, this.getPosition(it), null, 65, null));
    }

    @Override
    public void enterPropertyDeclaration(@Nullable KotlinParser.PropertyDeclarationContext ctx) {
        KotlinParser.PropertyDeclarationContext propertyDeclarationContext = ctx;
        Intrinsics.checkNotNull(propertyDeclarationContext);
        if (propertyDeclarationContext.variableDeclaration() != null) {
            Object object;
            KotlinParser.VariableDeclarationContext varDecl = ctx.variableDeclaration();
            String key = varDecl.simpleIdentifier().getText();
            if (ctx.ASSIGNMENT() != null) {
                String string;
                if (ctx.propertyDelegate() != null) {
                    Intrinsics.checkNotNullExpressionValue(key, "key");
                    string = ctx.propertyDelegate().getText();
                    Intrinsics.checkNotNullExpressionValue(string, "ctx.propertyDelegate().text");
                    this.VARIABLE_POOL.put(key, string);
                }
                if (ctx.expression() != null) {
                    Intrinsics.checkNotNullExpressionValue(key, "key");
                    string = ctx.expression().getText();
                    Intrinsics.checkNotNullExpressionValue(string, "ctx.expression().text");
                    this.VARIABLE_POOL.put(key, string);
                }
            }
            Object varType = "";
            if (varDecl.type() != null) {
                object = varDecl.type().getText();
                Intrinsics.checkNotNullExpressionValue(object, "varDecl.type().text");
                varType = object;
            }
            object = this.getCurrentFunction();
            Collection collection = ((CodeFunction)object).getLocalVariables();
            Intrinsics.checkNotNullExpressionValue(key, "key");
            ((CodeFunction)object).setLocalVariables(CollectionsKt.plus(collection, new CodeProperty(null, null, key, (String)varType, null, null, null, null, 243, null)));
        }
    }

    private final String typeFromText(String text) {
        CharSequence charSequence = text;
        String typeType = new Regex("\".*\"").matches(charSequence) ? this.getTypeFullName("String") : (new Regex("\\d+").matches(charSequence = (CharSequence)text) ? this.getTypeFullName("Number") : "");
        return typeType;
    }

    private final CodeProperty parseParameter(String text) {
        String typeType = this.typeFromText(text);
        String value = null;
        value = StringsKt.removeSuffix(StringsKt.removePrefix(text, (CharSequence)"\""), (CharSequence)"\"");
        if (Intrinsics.areEqual(typeType, "") && this.VARIABLE_POOL.get(value) != null) {
            MatchResult matches;
            value = String.valueOf(this.VARIABLE_POOL.get(value));
            MatchResult matchResult = matches = Regex.find$default(this.VAR_IN_STRING, value, 0, 2, null);
            if (matchResult != null) {
                MatchGroupCollection matchGroupCollection = matchResult.getGroups();
                if (matchGroupCollection != null) {
                    Iterable $this$forEach$iv = matchGroupCollection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String variable;
                        String withoutVariable;
                        String pool;
                        MatchGroup it = (MatchGroup)element$iv;
                        boolean bl = false;
                        MatchGroup matchGroup = it;
                        if ((matchGroup == null ? null : matchGroup.getValue()) == null || (pool = this.VARIABLE_POOL.get(withoutVariable = StringsKt.removePrefix(variable = it.getValue(), (CharSequence)"$"))) == null) continue;
                        String poolText = pool;
                        if (StringsKt.startsWith$default(poolText, "\"", false, 2, null) && StringsKt.endsWith$default(poolText, "\"", false, 2, null)) {
                            poolText = StringsKt.removeSuffix(StringsKt.removePrefix(poolText, (CharSequence)"\""), (CharSequence)"\"");
                        }
                        value = StringsKt.replace$default(value, variable, poolText, false, 4, null);
                    }
                }
            }
            typeType = this.typeFromText(value);
        }
        return new CodeProperty(null, null, value, typeType, null, null, null, null, 243, null);
    }

    private final CodeCall refineIfExistsCreator(CodeCall $this$refineIfExistsCreator) {
        for (CodeDataStruct clazz : this.getClasses()) {
            if (this.refineWithClass($this$refineIfExistsCreator, clazz) != null) continue;
            return $this$refineIfExistsCreator;
        }
        for (CodeImport codeImport : this.getImports()) {
            if (this.refineWithImport($this$refineIfExistsCreator, codeImport) != null) continue;
            return $this$refineIfExistsCreator;
        }
        for (CodeField field : this.getCurrentNode().getFields()) {
            if (this.refineWithField($this$refineIfExistsCreator, field) != null) continue;
            return $this$refineIfExistsCreator;
        }
        this.postClassHandler.add(new Function1<CodeDataStruct, Unit>(this, $this$refineIfExistsCreator){
            final /* synthetic */ KotlinFullIdentListener this$0;
            final /* synthetic */ CodeCall $this_refineIfExistsCreator;
            {
                this.this$0 = $receiver;
                this.$this_refineIfExistsCreator = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull CodeDataStruct it) {
                Intrinsics.checkNotNullParameter(it, "it");
                KotlinFullIdentListener.access$refineWithClass(this.this$0, this.$this_refineIfExistsCreator, it);
            }
        });
        return $this$refineIfExistsCreator;
    }

    private final CodeCall refineWithClass(CodeCall $this$refineWithClass, CodeDataStruct it) {
        if (Intrinsics.areEqual(it.getNodeName(), $this$refineWithClass.getFunctionName())) {
            $this$refineWithClass.setType(CallType.CREATOR);
            $this$refineWithClass.setPackage(it.getPackage());
            return null;
        }
        return $this$refineWithClass;
    }

    private final CodeCall refineWithImport(CodeCall $this$refineWithImport, CodeImport it) {
        if (Intrinsics.areEqual(it.getAsName(), $this$refineWithImport.getNodeName())) {
            $this$refineWithImport.setPackage(StringsKt.substringBeforeLast$default(it.getSource(), '.', null, 2, null));
            return null;
        }
        if (Intrinsics.areEqual(it.getAsName(), $this$refineWithImport.getFunctionName()) && Character.isUpperCase($this$refineWithImport.getFunctionName().charAt(0))) {
            $this$refineWithImport.setPackage(it.getSource());
            $this$refineWithImport.setNodeName($this$refineWithImport.getFunctionName());
            return null;
        }
        if (Intrinsics.areEqual(it.getAsName(), $this$refineWithImport.getFunctionName())) {
            String fullNodeName = StringsKt.substringBeforeLast$default(it.getSource(), '.', null, 2, null);
            $this$refineWithImport.setPackage(StringsKt.substringBeforeLast$default(fullNodeName, '.', null, 2, null));
            $this$refineWithImport.setNodeName(StringsKt.substringAfterLast$default(fullNodeName, '.', null, 2, null));
            return null;
        }
        return $this$refineWithImport;
    }

    private final CodeCall refineWithField(CodeCall $this$refineWithField, CodeField it) {
        if (Intrinsics.areEqual(it.getTypeKey(), $this$refineWithField.getNodeName())) {
            String fullNodeName = it.getTypeType();
            $this$refineWithField.setPackage(StringsKt.substringBeforeLast$default(fullNodeName, '.', null, 2, null));
            $this$refineWithField.setNodeName(StringsKt.substringAfterLast$default(fullNodeName, '.', null, 2, null));
            return null;
        }
        return $this$refineWithField;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enterPostfixUnaryExpression(@Nullable KotlinParser.PostfixUnaryExpressionContext ctx) {
        List calls = null;
        calls = new ArrayList();
        String lastIdentifier = null;
        lastIdentifier = "";
        String lastPackage = null;
        lastPackage = "";
        String lastFunctionName = null;
        lastFunctionName = "";
        String lastNodeName = null;
        lastNodeName = "";
        String lastPostfixChildType = null;
        lastPostfixChildType = "";
        KotlinParser.PostfixUnaryExpressionContext postfixUnaryExpressionContext = ctx;
        Intrinsics.checkNotNull(postfixUnaryExpressionContext);
        Object object = postfixUnaryExpressionContext.children;
        Intrinsics.checkNotNullExpressionValue(object, "ctx!!.children");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeCall call;
            List list;
            List parameters2;
            ParseTree child = (ParseTree)element$iv;
            boolean bl = false;
            ParseTree parseTree = child;
            if (parseTree instanceof KotlinParser.PrimaryExpressionContext) {
                Intrinsics.checkNotNullExpressionValue(child, "child");
                lastIdentifier = this.textFromPrimaryExpr((KotlinParser.PrimaryExpressionContext)child);
                continue;
            }
            if (!(parseTree instanceof KotlinParser.PostfixUnarySuffixContext)) continue;
            ParseTree postfix = (ParseTree)((KotlinParser.PostfixUnarySuffixContext)child).children.get(0);
            if (postfix instanceof KotlinParser.CallSuffixContext) {
                KotlinParser.ValueArgumentsContext valueArguments = ((KotlinParser.CallSuffixContext)postfix).valueArguments();
                parameters2 = CollectionsKt.emptyList();
                if (valueArguments != null) {
                    void $this$mapTo$iv$iv;
                    List<KotlinParser.ValueArgumentContext> list2 = valueArguments.valueArgument();
                    Intrinsics.checkNotNullExpressionValue(list2, "valueArguments.valueArgument()");
                    List $this$map$iv = list2;
                    boolean $i$f$map = false;
                    list = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KotlinParser.ValueArgumentContext valueArgumentContext = (KotlinParser.ValueArgumentContext)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        String string = it.getText();
                        Intrinsics.checkNotNullExpressionValue(string, "it.text");
                        collection.add(this.parseParameter(string));
                    }
                    parameters2 = (List)destination$iv$iv;
                }
                if (Intrinsics.areEqual(lastPostfixChildType, "NavigationSuffixContext")) {
                    calls = CollectionsKt.toMutableList(CollectionsKt.dropLast(calls, 1));
                    lastIdentifier = lastFunctionName;
                }
                call = this.refineIfExistsCreator(new CodeCall(null, null, lastNodeName, lastIdentifier, parameters2, this.getPosition(ctx), null, 67, null));
                ((Collection)calls).add(call);
                lastPostfixChildType = "CallSuffixContext";
                continue;
            }
            if (postfix instanceof KotlinParser.NavigationSuffixContext) {
                if (((KotlinParser.NavigationSuffixContext)postfix).simpleIdentifier() != null) {
                    String navigationName = ((KotlinParser.NavigationSuffixContext)postfix).simpleIdentifier().getText();
                    parameters2 = CollectionsKt.emptyList();
                    if (((KotlinParser.NavigationSuffixContext)postfix).parenthesizedExpression() != null) {
                        String param = ((KotlinParser.NavigationSuffixContext)postfix).parenthesizedExpression().expression().getText();
                        Collection collection = parameters2;
                        Intrinsics.checkNotNullExpressionValue(param, "param");
                        parameters2 = CollectionsKt.plus(collection, this.parseParameter(param));
                    }
                    Intrinsics.checkNotNullExpressionValue(navigationName, "navigationName");
                    lastFunctionName = navigationName;
                    String string = lastIdentifier;
                    list = parameters2;
                    String string2 = lastPackage;
                    CodePosition codePosition = this.getPosition(ctx);
                    call = this.refineIfExistsCreator(new CodeCall(string2, null, string, navigationName, list, codePosition, null, 66, null));
                    lastPackage = call.getPackage();
                    lastNodeName = call.getNodeName();
                    ((Collection)calls).add(call);
                }
                lastPostfixChildType = "NavigationSuffixContext";
                continue;
            }
            String string = ((KotlinParser.PostfixUnarySuffixContext)child).children.get(0).getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue(string, "child.children[0].javaClass.simpleName");
            lastPostfixChildType = string;
        }
        if (!((Collection)calls).isEmpty()) {
            if (this.isEnteredIndividualFunction()) {
                object = this.getCurrentIndividualFunction();
                ((CodeFunction)object).setFunctionCalls(CollectionsKt.plus((Collection)((CodeFunction)object).getFunctionCalls(), (Iterable)calls));
            } else {
                object = this.getCurrentFunction();
                ((CodeFunction)object).setFunctionCalls(CollectionsKt.plus((Collection)((CodeFunction)object).getFunctionCalls(), (Iterable)calls));
            }
        }
    }

    private final String textFromPrimaryExpr(KotlinParser.PrimaryExpressionContext child) {
        String string;
        if (child.simpleIdentifier() != null) {
            String string2 = child.simpleIdentifier().getText();
            Intrinsics.checkNotNullExpressionValue(string2, "{\n                child.\u2026fier().text\n            }");
            string = string2;
        } else if (child.stringLiteral() != null) {
            String string3 = child.stringLiteral().getText();
            Intrinsics.checkNotNullExpressionValue(string3, "{\n                child.\u2026eral().text\n            }");
            string = string3;
        } else {
            String string4 = child.getText();
            Intrinsics.checkNotNullExpressionValue(string4, "{\n                child.text\n            }");
            string = string4;
        }
        return string;
    }

    @Override
    @NotNull
    public CodeDataStruct buildClass(@NotNull KotlinParser.ClassDeclarationContext ctx) {
        CodeDataStruct codeDataStruct;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        CodeDataStruct it = codeDataStruct = super.buildClass(ctx);
        boolean bl = false;
        Iterable $this$forEach$iv = this.postClassHandler;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 callback = (Function1)element$iv;
            boolean bl2 = false;
            callback.invoke(it);
        }
        return codeDataStruct;
    }

    public static final /* synthetic */ CodeCall access$refineWithClass(KotlinFullIdentListener $this, CodeCall $receiver, CodeDataStruct it) {
        return $this.refineWithClass($receiver, it);
    }
}

