/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.net.URL;

public class ConfigurationWatchListUtil {
    static final ConfigurationWatchListUtil origin = new ConfigurationWatchListUtil();

    private ConfigurationWatchListUtil() {
    }

    public static void registerConfigurationWatchList(Context context2, ConfigurationWatchList cwl) {
        context2.putObject("CONFIGURATION_WATCH_LIST", cwl);
    }

    public static void setMainWatchURL(Context context2, URL url2) {
        ConfigurationWatchList cwl = ConfigurationWatchListUtil.getConfigurationWatchList(context2);
        if (cwl == null) {
            cwl = new ConfigurationWatchList();
            cwl.setContext(context2);
            context2.putObject("CONFIGURATION_WATCH_LIST", cwl);
        } else {
            cwl.clear();
        }
        cwl.setMainURL(url2);
    }

    public static URL getMainWatchURL(Context context2) {
        ConfigurationWatchList cwl = ConfigurationWatchListUtil.getConfigurationWatchList(context2);
        if (cwl == null) {
            return null;
        }
        return cwl.getMainURL();
    }

    public static void addToWatchList(Context context2, URL url2) {
        ConfigurationWatchList cwl = ConfigurationWatchListUtil.getConfigurationWatchList(context2);
        if (cwl == null) {
            ConfigurationWatchListUtil.addWarn(context2, "Null ConfigurationWatchList. Cannot add " + String.valueOf(url2));
        } else {
            ConfigurationWatchListUtil.addInfo(context2, "Adding [" + String.valueOf(url2) + "] to configuration watch list.");
            cwl.addToWatchList(url2);
        }
    }

    public static ConfigurationWatchList getConfigurationWatchList(Context context2) {
        return (ConfigurationWatchList)context2.getObject("CONFIGURATION_WATCH_LIST");
    }

    static void addStatus(Context context2, Status s) {
        if (context2 == null) {
            System.out.println("Null context in " + ConfigurationWatchList.class.getName());
            return;
        }
        StatusManager sm = context2.getStatusManager();
        if (sm == null) {
            return;
        }
        sm.add(s);
    }

    static void addInfo(Context context2, String msg) {
        ConfigurationWatchListUtil.addStatus(context2, new InfoStatus(msg, origin));
    }

    static void addWarn(Context context2, String msg) {
        ConfigurationWatchListUtil.addStatus(context2, new WarnStatus(msg, origin));
    }
}

