/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.quality.testbadsmell;

import cc.unitmesh.quality.QualityAnalyser;
import cc.unitmesh.quality.testbadsmell.TbsResult;
import cc.unitmesh.quality.testbadsmell.TestBadSmell;
import chapi.domain.core.CodeAnnotation;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.archguard.rule.core.Issue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J2\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u0011H\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0002J:\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001d0\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J@\u0010&\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u000b2.\u0010\u001c\u001a*\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001d0'j\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001d`(H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006)"}, d2={"Lcc/unitmesh/quality/testbadsmell/TestBadsmellAnalyser;", "Lcc/unitmesh/quality/QualityAnalyser;", "thresholds", "", "", "", "(Ljava/util/Map;)V", "getThresholds", "()Ljava/util/Map;", "addExtractAssertMethodCall", "", "Lchapi/domain/core/CodeCall;", "method", "Lchapi/domain/core/CodeFunction;", "node", "Lchapi/domain/core/CodeDataStruct;", "callMethodMap", "", "analysis", "Lorg/archguard/rule/core/Issue;", "nodes", "appendUnknownTest", "", "filePath", "tbsResult", "Lcc/unitmesh/quality/testbadsmell/TbsResult;", "buildCallMethodMap", "checkDuplicateAssertTest", "methodCallMap", "", "checkEmptyTest", "annotation", "Lchapi/domain/core/CodeAnnotation;", "checkIgnoreTest", "checkRedundantAssertionTest", "funcCall", "checkRedundantPrintTest", "checkSleepyTest", "updateMethodCallMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "code-quality"})
@SourceDebugExtension(value={"SMAP\nTestBadsmellAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestBadsmellAnalyser.kt\ncc/unitmesh/quality/testbadsmell/TestBadsmellAnalyser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,229:1\n11065#2:230\n11400#2,3:231\n*S KotlinDebug\n*F\n+ 1 TestBadsmellAnalyser.kt\ncc/unitmesh/quality/testbadsmell/TestBadsmellAnalyser\n*L\n59#1:230\n59#1:231,3\n*E\n"})
public final class TestBadsmellAnalyser
implements QualityAnalyser {
    @NotNull
    private final Map<String, Integer> thresholds;

    public TestBadsmellAnalyser(@NotNull Map<String, Integer> thresholds) {
        Intrinsics.checkNotNullParameter(thresholds, "thresholds");
        this.thresholds = thresholds;
    }

    public /* synthetic */ TestBadsmellAnalyser(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(map2);
    }

    @NotNull
    public final Map<String, Integer> getThresholds() {
        return this.thresholds;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Issue> analysis(@NotNull List<CodeDataStruct> nodes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodes, "nodes");
        TbsResult tbsResult = new TbsResult(new TestBadSmell[0]);
        Map<String, CodeFunction> callMethodMap = this.buildCallMethodMap(nodes);
        for (CodeDataStruct node : nodes) {
            for (CodeFunction method : node.getFunctions()) {
                if (!method.isJUnitTest()) continue;
                List<CodeCall> currentMethodCalls = this.addExtractAssertMethodCall(method, node, callMethodMap);
                method.setFunctionCalls(currentMethodCalls);
                for (CodeAnnotation annotation2 : method.getAnnotations()) {
                    this.checkIgnoreTest(node.getFilePath(), annotation2, tbsResult, method);
                    this.checkEmptyTest(node.getFilePath(), annotation2, tbsResult, method);
                }
                HashMap<String, CodeCall[]> methodCallMap = new HashMap<String, CodeCall[]>();
                boolean hasAssert = false;
                Iterator<CodeCall> iterator2 = currentMethodCalls.iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    boolean lastFuncCall;
                    int index = n++;
                    CodeCall funcCall = iterator2.next();
                    if (Intrinsics.areEqual(funcCall.getFunctionName(), "")) {
                        lastFuncCall = index == currentMethodCalls.size() - 1;
                        if (!lastFuncCall || hasAssert) continue;
                        this.appendUnknownTest(node.getFilePath(), method, tbsResult);
                        continue;
                    }
                    this.updateMethodCallMap(funcCall, methodCallMap);
                    this.checkRedundantPrintTest(node.getFilePath(), funcCall, tbsResult);
                    this.checkSleepyTest(node.getFilePath(), funcCall, tbsResult);
                    this.checkRedundantAssertionTest(node.getFilePath(), funcCall, tbsResult);
                    if (funcCall.hasAssertion()) {
                        hasAssert = true;
                    }
                    if (!(lastFuncCall = index == currentMethodCalls.size() - 1) || hasAssert) continue;
                    this.appendUnknownTest(node.getFilePath(), method, tbsResult);
                }
                this.checkDuplicateAssertTest(node, method, (Map<String, CodeCall[]>)methodCallMap, tbsResult);
            }
        }
        TestBadSmell[] $this$map$iv = tbsResult.getResults();
        boolean $i$f$map = false;
        TestBadSmell[] testBadSmellArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_18 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toIssue());
        }
        return CollectionsKt.toMutableList((List)destination$iv$iv);
    }

    private final List<CodeCall> addExtractAssertMethodCall(CodeFunction method, CodeDataStruct node, Map<String, CodeFunction> callMethodMap) {
        List<CodeCall> methodCalls = method.getFunctionCalls();
        for (CodeCall methodCall : methodCalls) {
            CodeFunction mapFunc;
            if (!Intrinsics.areEqual(methodCall.getNodeName(), node.getNodeName()) || (mapFunc = callMethodMap.get(methodCall.buildFullMethodName())) == null || Intrinsics.areEqual(mapFunc.getName(), "")) continue;
            methodCalls = CollectionsKt.plus((Collection)methodCalls, (Iterable)mapFunc.getFunctionCalls());
        }
        return methodCalls;
    }

    private final void updateMethodCallMap(CodeCall funcCall, HashMap<String, CodeCall[]> methodCallMap) {
        CodeCall[] calls = new CodeCall[]{};
        String buildFullMethodName = funcCall.buildFullMethodName();
        if (methodCallMap.get(buildFullMethodName) != null) {
            CodeCall[] codeCallArray = methodCallMap.get(buildFullMethodName);
            Intrinsics.checkNotNull(codeCallArray);
            calls = codeCallArray;
        }
        calls = ArraysKt.plus(calls, funcCall);
        ((Map)methodCallMap).put(buildFullMethodName, calls);
    }

    private final void checkDuplicateAssertTest(CodeDataStruct node, CodeFunction method, Map<String, CodeCall[]> methodCallMap, TbsResult tbsResult) {
        boolean isDuplicateTest = false;
        for (Map.Entry<String, CodeCall[]> entry : methodCallMap.entrySet()) {
            int duplicatedLimitLength;
            CodeCall[] methodCalls = entry.getValue();
            if (methodCalls.length < (duplicatedLimitLength = 5) || !ArraysKt.last(methodCalls).hasAssertion()) continue;
            isDuplicateTest = true;
        }
        if (isDuplicateTest) {
            TestBadSmell testBadSmell = new TestBadSmell(node.getFilePath(), "DuplicateAssertTest", "", method.getPosition().getStartLine());
            tbsResult.setResults(ArraysKt.plus(tbsResult.getResults(), testBadSmell));
        }
    }

    private final void appendUnknownTest(String filePath, CodeFunction method, TbsResult tbsResult) {
        TestBadSmell testBadSmell = new TestBadSmell(filePath, "UnknownTest", "", method.getPosition().getStartLine());
        tbsResult.setResults(ArraysKt.plus(tbsResult.getResults(), testBadSmell));
    }

    private final void checkRedundantAssertionTest(String filePath, CodeCall funcCall, TbsResult tbsResult) {
        int assertParametersSize = 2;
        if (funcCall.getParameters().size() == assertParametersSize && Intrinsics.areEqual(funcCall.getParameters().get(0).getTypeValue(), funcCall.getParameters().get(1).getTypeValue())) {
            TestBadSmell testBadSmell = new TestBadSmell(filePath, "RedundantAssertionTest", "", funcCall.getPosition().getStartLine());
            tbsResult.setResults(ArraysKt.plus(tbsResult.getResults(), testBadSmell));
        }
    }

    private final void checkSleepyTest(String filePath, CodeCall funcCall, TbsResult tbsResult) {
        if (funcCall.isThreadSleep()) {
            TestBadSmell testBadSmell = new TestBadSmell(filePath, "SleepyTest", "", funcCall.getPosition().getStartLine());
            tbsResult.setResults(ArraysKt.plus(tbsResult.getResults(), testBadSmell));
        }
    }

    private final void checkRedundantPrintTest(String filePath, CodeCall funcCall, TbsResult tbsResult) {
        if (funcCall.isSystemOutput()) {
            TestBadSmell testBadSmell = new TestBadSmell(filePath, "RedundantPrintTest", "", funcCall.getPosition().getStartLine());
            tbsResult.setResults(ArraysKt.plus(tbsResult.getResults(), testBadSmell));
        }
    }

    private final void checkIgnoreTest(String filePath, CodeAnnotation annotation2, TbsResult tbsResult, CodeFunction method) {
        if (annotation2.isIgnore()) {
            TestBadSmell testBadSmell = new TestBadSmell(filePath, "IgnoreTest", "", method.getPosition().getStartLine());
            tbsResult.setResults(ArraysKt.plus(tbsResult.getResults(), testBadSmell));
        }
    }

    private final void checkEmptyTest(String filePath, CodeAnnotation annotation2, TbsResult tbsResult, CodeFunction method) {
        boolean isJavaTest = StringsKt.endsWith$default(filePath, ".java", false, 2, null) && annotation2.isTest();
        boolean isGoTest = StringsKt.endsWith$default(filePath, "_test.go", false, 2, null);
        if ((isJavaTest || isGoTest) && method.getFunctionCalls().size() <= 1) {
            TestBadSmell badSmell = new TestBadSmell(filePath, "EmptyTest", "", method.getPosition().getStartLine());
            tbsResult.setResults(ArraysKt.plus(tbsResult.getResults(), badSmell));
        }
    }

    private final Map<String, CodeFunction> buildCallMethodMap(List<CodeDataStruct> nodes) {
        Map callMethodMap = new LinkedHashMap();
        for (CodeDataStruct node : nodes) {
            for (CodeFunction method : node.getFunctions()) {
                callMethodMap.put(method.buildFullMethodName(node), method);
            }
        }
        return callMethodMap;
    }

    public TestBadsmellAnalyser() {
        this(null, 1, null);
    }
}

