/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.quality.badsmell;

import cc.unitmesh.quality.QualityAnalyser;
import cc.unitmesh.quality.badsmell.BadSmellGraphCall;
import cc.unitmesh.quality.badsmell.BadSmellModel;
import cc.unitmesh.quality.badsmell.BadsmellAnalyserKt;
import cc.unitmesh.quality.badsmell.BsThresholds;
import cc.unitmesh.quality.badsmell.SmellType;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodePosition;
import chapi.domain.core.DataStructType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.archguard.rule.core.Issue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\"\u0010\u0016\u001a\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J$\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001c\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001c\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J$\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J$\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001c\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J$\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\n\u0010 \u001a\u00020\u0019*\u00020\rJ$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\n*\u00020\r2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcc/unitmesh/quality/badsmell/BadsmellAnalyser;", "Lcc/unitmesh/quality/QualityAnalyser;", "thresholds", "", "", "", "(Ljava/util/Map;)V", "bsThresholds", "Lcc/unitmesh/quality/badsmell/BsThresholds;", "analysis", "", "Lorg/archguard/rule/core/Issue;", "nodes", "Lchapi/domain/core/CodeDataStruct;", "checkComplexIf", "", "method", "Lchapi/domain/core/CodeFunction;", "node", "badSmellList", "", "Lcc/unitmesh/quality/badsmell/BadSmellModel;", "checkConnectedGraphCall", "checkDataClass", "onlyHaveGetterAndSetter", "", "checkLargeClass", "checkLazyElement", "checkLongMethod", "checkLongParameterList", "checkRefusedBequest", "checkRepeatedSwitches", "HasCallSuper", "getCalledClasses", "maps", "code-quality"})
@SourceDebugExtension(value={"SMAP\nBadsmellAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BadsmellAnalyser.kt\ncc/unitmesh/quality/badsmell/BadsmellAnalyser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1549#2:203\n1620#2,3:204\n766#2:207\n857#2,2:208\n*S KotlinDebug\n*F\n+ 1 BadsmellAnalyser.kt\ncc/unitmesh/quality/badsmell/BadsmellAnalyser\n*L\n48#1:203\n48#1:204,3\n136#1:207\n136#1:208,2\n*E\n"})
public final class BadsmellAnalyser
implements QualityAnalyser {
    @NotNull
    private BsThresholds bsThresholds;

    public BadsmellAnalyser(@NotNull Map<String, Integer> thresholds) {
        Intrinsics.checkNotNullParameter(thresholds, "thresholds");
        this.bsThresholds = new BsThresholds(0, 0, 0, 0, 0, 31, null);
        this.bsThresholds = this.bsThresholds.from(thresholds);
    }

    public /* synthetic */ BadsmellAnalyser(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new BsThresholds(0, 0, 0, 0, 0, 31, null).toThresholds();
        }
        this(map2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Issue> analysis(@NotNull List<CodeDataStruct> nodes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodes, "nodes");
        List badSmellList = new ArrayList();
        for (CodeDataStruct node : nodes) {
            this.checkLazyElement(node, badSmellList);
            boolean onlyHaveGetterAndSetter = true;
            for (CodeFunction method : node.getFunctions()) {
                this.checkLongMethod(method, node, badSmellList);
                if (!method.isGetterSetter()) {
                    onlyHaveGetterAndSetter = false;
                }
                this.checkLongParameterList(method, node, badSmellList);
                this.checkComplexIf(method, node, badSmellList);
            }
            this.checkDataClass(onlyHaveGetterAndSetter, node, badSmellList);
            this.checkRefusedBequest(node, badSmellList);
            this.checkLargeClass(node, badSmellList);
        }
        this.checkConnectedGraphCall(nodes, badSmellList);
        Iterable $this$map$iv = badSmellList;
        boolean $i$f$map = false;
        Iterable onlyHaveGetterAndSetter = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BadSmellModel badSmellModel = (BadSmellModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toIssue());
        }
        return CollectionsKt.toMutableList((List)destination$iv$iv);
    }

    public final void checkConnectedGraphCall(@NotNull List<CodeDataStruct> nodes, @NotNull List<BadSmellModel> badSmellList) {
        Intrinsics.checkNotNullParameter(nodes, "nodes");
        Intrinsics.checkNotNullParameter(badSmellList, "badSmellList");
        Map classNodes = new LinkedHashMap();
        Map classNodeMaps = new LinkedHashMap();
        for (CodeDataStruct node : nodes) {
            classNodeMaps.put(node.getClassFullName(), true);
        }
        for (CodeDataStruct node : nodes) {
            classNodes.put(node.getClassFullName(), this.getCalledClasses(node, classNodeMaps));
        }
        BadSmellGraphCall badSmellGraphCall = new BadSmellGraphCall();
        List<String> descriptions = badSmellGraphCall.analysisGraphCallPath(classNodes);
        for (String description2 : descriptions) {
            badSmellList.add(new BadSmellModel(null, null, SmellType.SMELL_GARPH_CONNECTED_CALL, description2, null, 19, null));
        }
    }

    @NotNull
    public final List<String> getCalledClasses(@NotNull CodeDataStruct $this$getCalledClasses, @NotNull Map<String, Boolean> maps) {
        Intrinsics.checkNotNullParameter($this$getCalledClasses, "<this>");
        Intrinsics.checkNotNullParameter(maps, "maps");
        Map calledClassesMap = new LinkedHashMap();
        List calledClasses = new ArrayList();
        for (CodeCall methodCalled : $this$getCalledClasses.getFunctionCalls()) {
            if (Intrinsics.areEqual(methodCalled.getNodeName(), "")) continue;
            Boolean bl = maps.get(methodCalled.buildClassFullName());
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue() || Intrinsics.areEqual($this$getCalledClasses.getClassFullName(), methodCalled.buildClassFullName())) continue;
            calledClassesMap.put(methodCalled.buildClassFullName(), true);
        }
        for (String key : calledClassesMap.keySet()) {
            calledClasses.add(key);
        }
        return calledClasses;
    }

    public final void checkLazyElement(@NotNull CodeDataStruct node, @NotNull List<BadSmellModel> badSmellList) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(badSmellList, "badSmellList");
        if (node.getType() == DataStructType.CLASS && node.getFunctions().isEmpty()) {
            badSmellList.add(new BadSmellModel(node.getFilePath(), null, SmellType.SMELL_LAZY_ELEMENT, null, null, 26, null));
        }
    }

    public final void checkLongMethod(@NotNull CodeFunction method, @NotNull CodeDataStruct node, @NotNull List<BadSmellModel> badSmellList) {
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(badSmellList, "badSmellList");
        int methodLength = method.getPosition().getStopLine() - method.getPosition().getStartLine();
        if (methodLength > this.bsThresholds.getBsMethodLength()) {
            String description2 = "method length: " + methodLength;
            BadSmellModel longMethod = new BadSmellModel(node.getFilePath(), String.valueOf(method.getPosition().getStartLine()), SmellType.SMELL_LONG_METHOD, description2, methodLength);
            badSmellList.add(longMethod);
        }
    }

    public final void checkDataClass(boolean onlyHaveGetterAndSetter, @NotNull CodeDataStruct node, @NotNull List<BadSmellModel> badSmellList) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(badSmellList, "badSmellList");
        if (onlyHaveGetterAndSetter && node.getType() == DataStructType.CLASS && !((Collection)node.getFunctions()).isEmpty()) {
            BadSmellModel dataClass = new BadSmellModel(node.getFilePath(), null, SmellType.SMELL_DATA_CLASS, null, node.getFunctions().size(), 10, null);
            badSmellList.add(dataClass);
        }
    }

    public final void checkRefusedBequest(@NotNull CodeDataStruct node, @NotNull List<BadSmellModel> badSmellList) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(badSmellList, "badSmellList");
        if (!Intrinsics.areEqual(node.getExtend(), "") && this.HasCallSuper(node)) {
            badSmellList.add(new BadSmellModel(node.getFilePath(), null, SmellType.SMELL_REFUSED_BEQUEST, null, null, 26, null));
        }
    }

    public final boolean HasCallSuper(@NotNull CodeDataStruct $this$HasCallSuper) {
        Intrinsics.checkNotNullParameter($this$HasCallSuper, "<this>");
        boolean hasCallSuperMethod = false;
        for (CodeCall methodCall : $this$HasCallSuper.getFunctionCalls()) {
            if (!Intrinsics.areEqual(methodCall.getNodeName(), $this$HasCallSuper.getExtend())) continue;
            hasCallSuperMethod = true;
        }
        return hasCallSuperMethod;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkLargeClass(@NotNull CodeDataStruct node, @NotNull List<BadSmellModel> badSmellList) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(badSmellList, "badSmellList");
        Iterable $this$filter$iv = node.getFunctions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CodeFunction it = (CodeFunction)element$iv$iv;
            boolean bl = false;
            if (!(!it.isGetterSetter())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int normalClassLength = ((List)destination$iv$iv).size();
        if (node.getType() == DataStructType.CLASS && normalClassLength >= this.bsThresholds.getBsLargeLength()) {
            String description2 = "methods number (without getter/setter): " + normalClassLength;
            badSmellList.add(new BadSmellModel(node.getFilePath(), null, SmellType.SMELL_LARGE_CLASS, description2, normalClassLength, 2, null));
        }
    }

    public final void checkComplexIf(@NotNull CodeFunction method, @NotNull CodeDataStruct node, @NotNull List<BadSmellModel> badSmellList) {
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(badSmellList, "badSmellList");
        for (CodePosition info : BadsmellAnalyserKt.access$getIfInfo(method)) {
            if (info.getStopLine() - info.getStartLine() < this.bsThresholds.getBsIfLinesLength()) continue;
            BadSmellModel longParams = new BadSmellModel(node.getFilePath(), String.valueOf(info.getStartLine()), SmellType.SMELL_COMPLEX_CONDITION, "SMELL_COMPLEX_CONDITION", null, 16, null);
            badSmellList.add(longParams);
        }
    }

    public final void checkRepeatedSwitches(@NotNull CodeFunction method, @NotNull CodeDataStruct node, @NotNull List<BadSmellModel> badSmellList) {
        BadSmellModel longParams;
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(badSmellList, "badSmellList");
        if (BadsmellAnalyserKt.access$getIfSize(method) >= this.bsThresholds.getBsIfSwitchLength()) {
            longParams = new BadSmellModel(node.getFilePath(), String.valueOf(method.getPosition().getStartLine()), SmellType.SMELL_REPEATED_SWITCHES, "ifSize", BadsmellAnalyserKt.access$getIfSize(method));
            badSmellList.add(longParams);
        }
        if (BadsmellAnalyserKt.access$getSwitchSize(method) >= this.bsThresholds.getBsIfSwitchLength()) {
            longParams = new BadSmellModel(node.getFilePath(), String.valueOf(method.getPosition().getStartLine()), SmellType.SMELL_REPEATED_SWITCHES, "switchSize", BadsmellAnalyserKt.access$getSwitchSize(method));
            badSmellList.add(longParams);
        }
    }

    public final void checkLongParameterList(@NotNull CodeFunction method, @NotNull CodeDataStruct node, @NotNull List<BadSmellModel> badSmellList) {
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(badSmellList, "badSmellList");
        if (method.getParameters().size() > this.bsThresholds.getBsLongParasLength()) {
            String paramsJson = CollectionsKt.joinToString$default(method.getParameters(), ", ", null, null, 0, null, null, 62, null);
            BadSmellModel longParams = new BadSmellModel(node.getFilePath(), String.valueOf(method.getPosition().getStartLine()), SmellType.SMELL_LONG_PARAMETER_LIST, paramsJson, method.getParameters().size());
            badSmellList.add(longParams);
        }
    }
}

