/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.rag;

import cc.unitmesh.cf.core.dsl.Dsl;
import cc.unitmesh.rag.DocumentDsl;
import cc.unitmesh.rag.EmbeddingEngine;
import cc.unitmesh.rag.EngineType;
import cc.unitmesh.rag.LlmConnector;
import cc.unitmesh.rag.LlmType;
import cc.unitmesh.rag.PromptScript;
import cc.unitmesh.rag.Store;
import cc.unitmesh.rag.StoreType;
import cc.unitmesh.rag.TextDsl;
import cc.unitmesh.rag.base.ApplyDsl;
import io.github.cdimascio.dotenv.Dotenv;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApplyDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003J\u0014\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0(J\u0014\u0010)\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0(J\u0014\u0010*\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060(J\u001f\u0010+\u001a\u00020,2\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020&0.\u00a2\u0006\u0002\b/J\u0014\u00100\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0(J)\u00101\u001a\u00020&2!\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b2\u0012\b\b\u0002\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020&0.J\u001c\u00103\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0(J\u000e\u00104\u001a\u0002052\u0006\u00104\u001a\u00020\u0003R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00066"}, d2={"Lcc/unitmesh/rag/Workflow;", "", "name", "", "(Ljava/lang/String;)V", "dsl", "Lcc/unitmesh/cf/core/dsl/Dsl;", "value", "Lcc/unitmesh/rag/EmbeddingEngine;", "embedding", "getEmbedding", "()Lcc/unitmesh/rag/EmbeddingEngine;", "setEmbedding", "(Lcc/unitmesh/rag/EmbeddingEngine;)V", "env", "Lio/github/cdimascio/dotenv/Dotenv;", "getEnv", "()Lio/github/cdimascio/dotenv/Dotenv;", "setEnv", "(Lio/github/cdimascio/dotenv/Dotenv;)V", "llm", "Lcc/unitmesh/rag/LlmConnector;", "getLlm", "()Lcc/unitmesh/rag/LlmConnector;", "setLlm", "(Lcc/unitmesh/rag/LlmConnector;)V", "getName", "()Ljava/lang/String;", "store", "Lcc/unitmesh/rag/Store;", "getStore", "()Lcc/unitmesh/rag/Store;", "setStore", "(Lcc/unitmesh/rag/Store;)V", "document", "Lcc/unitmesh/rag/DocumentDsl;", "file", "indexing", "", "function", "Lkotlin/Function0;", "prepare", "problem", "prompt", "Lcc/unitmesh/rag/PromptScript;", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "querying", "solution", "Lkotlin/ParameterName;", "step", "text", "Lcc/unitmesh/rag/TextDsl;", "rag-script"})
public final class Workflow {
    @NotNull
    private final String name;
    @Nullable
    private Dotenv env;
    @NotNull
    private LlmConnector llm;
    @NotNull
    private Store store;
    @NotNull
    private EmbeddingEngine embedding;
    @Nullable
    private Dsl dsl;

    public Workflow(@NotNull String name) {
        Dotenv dotenv;
        Workflow workflow;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        Workflow workflow2 = this;
        try {
            workflow = workflow2;
            dotenv = Dotenv.load();
        }
        catch (Exception exception) {
            workflow = workflow2;
            dotenv = null;
        }
        workflow.env = dotenv;
        this.llm = new LlmConnector(LlmType.OpenAI, "", "");
        this.store = new Store(StoreType.MemoryEnglish);
        this.embedding = new EmbeddingEngine(EngineType.EnglishTextEmbedding);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Dotenv getEnv() {
        return this.env;
    }

    public final void setEnv(@Nullable Dotenv dotenv) {
        this.env = dotenv;
    }

    @NotNull
    public final LlmConnector getLlm() {
        return this.llm;
    }

    public final void setLlm(@NotNull LlmConnector llmConnector) {
        Intrinsics.checkNotNullParameter((Object)llmConnector, (String)"<set-?>");
        this.llm = llmConnector;
    }

    @NotNull
    public final Store getStore() {
        return this.store;
    }

    public final void setStore(@NotNull Store store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"<set-?>");
        this.store = store;
    }

    @NotNull
    public final EmbeddingEngine getEmbedding() {
        return this.embedding;
    }

    public final void setEmbedding(@NotNull EmbeddingEngine value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.embedding = value;
        this.store.updateEmbedding(value.getProvider());
    }

    @NotNull
    public final DocumentDsl document(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new DocumentDsl(file);
    }

    @NotNull
    public final TextDsl text(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new TextDsl(text);
    }

    public final void prepare(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        function.invoke();
    }

    public final void indexing(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.store.updateEmbedding(this.embedding.getProvider());
        function.invoke();
    }

    public final void querying(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        function.invoke();
    }

    public final void problem(@NotNull Function0<? extends Dsl> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.dsl = (Dsl)function.invoke();
    }

    public final void solution(@NotNull Function1<? super Dsl, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Dsl dsl = this.dsl;
        Intrinsics.checkNotNull((Object)dsl);
        function.invoke((Object)dsl);
    }

    public final void step(@NotNull String name, @NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        function.invoke();
    }

    @NotNull
    public final PromptScript prompt(@NotNull Function1<? super PromptScript, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        PromptScript prompt = new PromptScript();
        init.invoke((Object)prompt);
        return prompt;
    }
}

