/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.rag;

import cc.unitmesh.nlp.embedding.EmbeddingProvider;
import cc.unitmesh.nlp.embedding.text.EnglishTextEmbeddingProvider;
import cc.unitmesh.rag.StoreType;
import cc.unitmesh.rag.document.Document;
import cc.unitmesh.rag.store.EmbeddingMatch;
import cc.unitmesh.rag.store.EmbeddingStore;
import cc.unitmesh.rag.store.InMemoryEmbeddingStore;
import cc.unitmesh.rag.store.InMemoryEnglishTextStore;
import cc.unitmesh.store.ElasticsearchStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/rag/Store;", "", "storeType", "Lcc/unitmesh/rag/StoreType;", "(Lcc/unitmesh/rag/StoreType;)V", "embedding", "Lcc/unitmesh/nlp/embedding/EmbeddingProvider;", "store", "Lcc/unitmesh/rag/store/EmbeddingStore;", "Lcc/unitmesh/rag/document/Document;", "findRelevant", "", "Lcc/unitmesh/rag/store/EmbeddingMatch;", "input", "", "indexing", "", "chunks", "updateEmbedding", "", "value", "rag-script"})
@SourceDebugExtension(value={"SMAP\nStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Store.kt\ncc/unitmesh/rag/Store\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1549#2:45\n1620#2,3:46\n*S KotlinDebug\n*F\n+ 1 Store.kt\ncc/unitmesh/rag/Store\n*L\n27#1:45\n27#1:46,3\n*E\n"})
public final class Store {
    @Nullable
    private EmbeddingProvider embedding;
    @NotNull
    private final EmbeddingStore<Document> store;

    public Store(@NotNull StoreType storeType) {
        Intrinsics.checkNotNullParameter((Object)((Object)storeType), (String)"storeType");
        this.embedding = (EmbeddingProvider)new EnglishTextEmbeddingProvider();
        this.store = switch (WhenMappings.$EnumSwitchMapping$0[storeType.ordinal()]) {
            case 1 -> (EmbeddingStore)new ElasticsearchStore(null, null, null, null, null, 31, null);
            case 2 -> (EmbeddingStore)new InMemoryEmbeddingStore();
            case 3 -> (EmbeddingStore)new InMemoryEnglishTextStore();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final List<EmbeddingMatch<Document>> findRelevant(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        EmbeddingProvider embeddingProvider = this.embedding;
        Intrinsics.checkNotNull((Object)embeddingProvider);
        List embedded = embeddingProvider.embed(input);
        return this.store.findRelevant(embedded, 20);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean indexing(@NotNull List<Document> chunks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Iterable $this$map$iv = chunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Document document = (Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EmbeddingProvider embeddingProvider = this.embedding;
            Intrinsics.checkNotNull((Object)embeddingProvider);
            collection.add(embeddingProvider.embed(it.getText()));
        }
        List embeddings = (List)destination$iv$iv;
        this.store.addAll(embeddings, chunks);
        return true;
    }

    public final void updateEmbedding(@NotNull EmbeddingProvider value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.embedding = value;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StoreType.values().length];
            try {
                nArray[StoreType.Elasticsearch.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoreType.Memory.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoreType.MemoryEnglish.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

