/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.rag;

import cc.unitmesh.document.parser.MsOfficeDocumentParser;
import cc.unitmesh.document.parser.PdfDocumentParser;
import cc.unitmesh.document.parser.TextDocumentParser;
import cc.unitmesh.rag.document.Document;
import cc.unitmesh.rag.document.DocumentParser;
import cc.unitmesh.rag.document.DocumentType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcc/unitmesh/rag/DocumentDsl;", "", "file", "", "(Ljava/lang/String;)V", "documentParser", "Lcc/unitmesh/rag/document/DocumentParser;", "getFile", "()Ljava/lang/String;", "inputStream", "Ljava/io/FileInputStream;", "split", "", "Lcc/unitmesh/rag/document/Document;", "rag-script"})
public final class DocumentDsl {
    @NotNull
    private final String file;
    @NotNull
    private final DocumentParser documentParser;
    @NotNull
    private final FileInputStream inputStream;

    public DocumentDsl(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        String extension = StringsKt.substringAfterLast$default((String)this.file, (String)".", null, (int)2, null);
        DocumentType documentType = DocumentType.Companion.of(extension);
        this.documentParser = switch (WhenMappings.$EnumSwitchMapping$0[documentType.ordinal()]) {
            case 1 -> (DocumentParser)new TextDocumentParser(documentType, null, 2, null);
            case 2 -> (DocumentParser)new PdfDocumentParser();
            case 3 -> (DocumentParser)new TextDocumentParser(documentType, null, 2, null);
            case 4 -> (DocumentParser)new MsOfficeDocumentParser(documentType);
            case 5 -> (DocumentParser)new MsOfficeDocumentParser(documentType);
            case 6 -> (DocumentParser)new MsOfficeDocumentParser(documentType);
            default -> throw new NoWhenBranchMatchedException();
        };
        this.inputStream = new FileInputStream(new File(this.file));
    }

    @NotNull
    public final String getFile() {
        return this.file;
    }

    @NotNull
    public final List<Document> split() {
        return this.documentParser.parse((InputStream)this.inputStream);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocumentType.values().length];
            try {
                nArray[DocumentType.TXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentType.PDF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentType.HTML.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentType.DOC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentType.XLS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentType.PPT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

