/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.cf.language;

import cc.unitmesh.cf.language.Language;
import cc.unitmesh.cf.language.LanguageFeature;
import cc.unitmesh.cf.language.Quote;
import cc.unitmesh.cf.language.TokenType;
import cc.unitmesh.cf.language.Trie;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.internal.HashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0006J$\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0016\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u0006J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u0006J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u000e\u0010#\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcc/unitmesh/cf/language/LanguageService;", "", "()V", "Complexity", "", "SHE_BANG", "", "extToLanguages", "", "", "extensionCache", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "filenameToLanguage", "languageFeatures", "Lcc/unitmesh/cf/language/LanguageFeature;", "languageMap", "Lcc/unitmesh/cf/language/Language;", "shebangLookup", "detectLanguages", "filename", "detectSheBang", "content", "determineLanguage", "fallbackLanguage", "possibleLanguages", "", "getExtension", "name", "getLanguageFeature", "language", "guessLineComment", "processLanguageFeatures", "", "value", "scanForSheBang", "Companion", "LanguageGuess", "code-splitter"})
@SourceDebugExtension(value={"SMAP\nLanguageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageService.kt\ncc/unitmesh/cf/language/LanguageService\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,337:1\n96#2:338\n215#3:339\n216#3:351\n215#3,2:356\n1855#4:340\n1856#4:348\n1855#4,2:349\n1855#4:352\n1855#4,2:353\n1856#4:355\n1855#4,2:361\n1855#4,2:363\n1855#4,2:365\n1855#4,2:367\n372#5,7:341\n1099#6,3:358\n*S KotlinDebug\n*F\n+ 1 LanguageService.kt\ncc/unitmesh/cf/language/LanguageService\n*L\n18#1:338\n20#1:339\n20#1:351\n123#1:356,2\n22#1:340\n22#1:348\n26#1:349,2\n76#1:352\n80#1:353,2\n76#1:355\n275#1:361,2\n286#1:363,2\n293#1:365,2\n300#1:367,2\n23#1:341,7\n200#1:358,3\n*E\n"})
public final class LanguageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, String> extensionCache = new HashMap();
    @NotNull
    private final String SHE_BANG;
    @NotNull
    private Map<String, List<String>> extToLanguages = new LinkedHashMap();
    @NotNull
    private Map<String, String> filenameToLanguage = new LinkedHashMap();
    @NotNull
    private Map<String, LanguageFeature> languageFeatures = new LinkedHashMap();
    @NotNull
    private Map<String, List<String>> shebangLookup = new LinkedHashMap();
    @NotNull
    private Map<String, Language> languageMap = new LinkedHashMap();
    private boolean Complexity;

    public LanguageService() {
        this.SHE_BANG = "#!";
        URL uRL = this.getClass().getClassLoader().getResource("languages.json");
        Intrinsics.checkNotNull((Object)uRL);
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String fileContent = new String(byArray, charset);
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        HashMap languageMap = (HashMap)this_$iv.decodeFromString((DeserializationStrategy)new HashMapSerializer((KSerializer)StringSerializer.INSTANCE, Language.Companion.serializer()), fileContent);
        Map $this$forEach$iv = languageMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            Language lang = (Language)entry.getValue();
            lang.setName(name);
            Iterable $this$forEach$iv2 = lang.getExtensions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                List list;
                String it = (String)element$iv2;
                boolean bl2 = false;
                Map<String, List<String>> $this$getOrPut$iv = this.extToLanguages;
                boolean $i$f$getOrPut = false;
                List<String> value$iv = $this$getOrPut$iv.get(it);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = CollectionsKt.emptyList();
                    $this$getOrPut$iv.put(it, answer$iv);
                }
                $this$getOrPut$iv = this.extToLanguages;
                List<String> list2 = this.extToLanguages.get(it);
                Intrinsics.checkNotNull((Object)(list2 != null ? CollectionsKt.plus((Collection)list2, (Object)name) : null));
                list = list;
                $this$getOrPut$iv.put(it, list);
            }
            List<String> list = lang.getFileNames();
            if (list != null) {
                Iterable $this$forEach$iv3 = list;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    String it = (String)element$iv3;
                    boolean bl4 = false;
                    this.filenameToLanguage.put(it, name);
                }
            }
            if (lang.getSheBangs() != null) {
                this.shebangLookup.put(name, lang.getSheBangs());
            }
            this.processLanguageFeatures(name, lang);
        }
        this.languageMap = languageMap;
        this.Complexity = true;
    }

    @Nullable
    public final String guessLineComment(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object object = this.languageMap.get(language);
        return object != null && (object = ((Language)object).getLineComment()) != null ? (String)object.get(0) : null;
    }

    @NotNull
    public final String determineLanguage(@NotNull String fallbackLanguage, @NotNull List<String> possibleLanguages, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)fallbackLanguage, (String)"fallbackLanguage");
        Intrinsics.checkNotNullParameter(possibleLanguages, (String)"possibleLanguages");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (possibleLanguages.isEmpty()) {
            return fallbackLanguage;
        }
        if (possibleLanguages.size() == 1) {
            return possibleLanguages.get(0);
        }
        String toCheck = content.length > 20000 ? new String(ArraysKt.sliceArray((byte[])content, (IntRange)new IntRange(0, 20000)), Charsets.UTF_8) : new String(content, Charsets.UTF_8);
        String primary = null;
        primary = "";
        List toSort = new ArrayList();
        Iterable $this$forEach$iv = possibleLanguages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguageFeature langFeatures;
            String lang = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)this.languageFeatures.get(lang));
            int count = 0;
            List<String> list = langFeatures.getKeywords();
            if (list != null) {
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String key = (String)element$iv2;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)toCheck, (CharSequence)key, (boolean)false, (int)2, null)) continue;
                    ++count;
                }
            }
            List<String> list2 = langFeatures.getKeywords();
            boolean bl3 = list2 != null ? list2.isEmpty() : false;
            if (bl3) {
                primary = lang;
            }
            toSort.add(new LanguageGuess(lang, count));
        }
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                LanguageGuess it = (LanguageGuess)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getCount());
                it = (LanguageGuess)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getCount()));
            }
        };
        CollectionsKt.sortWith((List)toSort, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    LanguageGuess it = (LanguageGuess)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (LanguageGuess)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
                return n;
            }
        });
        if (((CharSequence)primary).length() > 0 && !((Collection)toSort).isEmpty() && ((LanguageGuess)toSort.get(0)).getCount() < 3) {
            return primary;
        }
        if (!((Collection)toSort).isEmpty()) {
            return ((LanguageGuess)toSort.get(0)).getName();
        }
        return fallbackLanguage;
    }

    @Nullable
    public final String detectSheBang(@NotNull String content) {
        String shebang;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (!StringsKt.startsWith$default((String)content, (String)this.SHE_BANG, (boolean)false, (int)2, null)) {
            return null;
        }
        int index = StringsKt.indexOf$default((CharSequence)content, (String)"\n", (int)0, (boolean)false, (int)6, null);
        String string = shebang = index != -1 ? StringsKt.slice((String)content, (IntRange)new IntRange(0, index)) : content;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String cmd = this.scanForSheBang(byArray);
        Map<String, List<String>> $this$forEach$iv = this.shebangLookup;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> entry = element$iv = iterator.next();
            boolean bl = false;
            String k = entry.getKey();
            List<String> v = entry.getValue();
            if (!v.contains(cmd)) continue;
            return k;
        }
        return null;
    }

    @NotNull
    public final String scanForSheBang(@NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        int state = 0;
        int lastSlash = 0;
        String candidate1 = "";
        String candidate2 = "";
        int n = content.length;
        block6: for (int i = 0; i < n; ++i) {
            switch (state) {
                case 0: {
                    if (content[i] != 47) continue block6;
                    lastSlash = i;
                    state = 1;
                    continue block6;
                }
                case 1: {
                    if (content[i] == 47) {
                        lastSlash = i;
                    }
                    if (i == content.length - 1) {
                        candidate1 = new String(ArraysKt.sliceArray((byte[])content, (IntRange)new IntRange(lastSlash + 1, i)), Charsets.UTF_8);
                    }
                    if (!Companion.isWhitespace(content[i])) continue block6;
                    candidate1 = new String(ArraysKt.sliceArray((byte[])content, (IntRange)RangesKt.until((int)(lastSlash + 1), (int)i)), Charsets.UTF_8);
                    state = 2;
                    continue block6;
                }
                case 2: {
                    if (Companion.isWhitespace(content[i])) continue block6;
                    lastSlash = i;
                    state = 3;
                    continue block6;
                }
                case 3: {
                    if (i == content.length - 1) {
                        candidate2 = new String(ArraysKt.sliceArray((byte[])content, (IntRange)new IntRange(lastSlash, i)), Charsets.UTF_8);
                    }
                    if (!Companion.isWhitespace(content[i])) continue block6;
                    candidate2 = new String(ArraysKt.sliceArray((byte[])content, (IntRange)RangesKt.until((int)lastSlash, (int)i)), Charsets.UTF_8);
                    state = 4;
                }
            }
        }
        return Intrinsics.areEqual((Object)candidate1, (Object)"env") ? candidate2 : (!Intrinsics.areEqual((Object)candidate1, (Object)"") ? candidate1 : "");
    }

    @NotNull
    public final List<String> detectLanguages(@NotNull String filename) {
        boolean ifNeedToCheckFullName;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        List language = new ArrayList();
        CharSequence $this$count$iv = filename;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '.')) continue;
            ++count$iv;
        }
        int dotCount = count$iv;
        boolean isDotFile = filename.charAt(0) == '.' && dotCount == 1;
        boolean notExtensionName = dotCount == 0;
        boolean bl = ifNeedToCheckFullName = notExtensionName || isDotFile;
        if (ifNeedToCheckFullName) {
            String string = filename.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String optFilenameLang = this.filenameToLanguage.get(string);
            if (optFilenameLang != null) {
                return CollectionsKt.listOf((Object)optFilenameLang);
            }
            ((Collection)language).add(this.SHE_BANG);
        }
        String string = filename.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        List<String> fullNameExt = this.extToLanguages.get(string);
        if (fullNameExt != null) {
            return fullNameExt;
        }
        String ext = this.getExtension(filename);
        String string2 = ext.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        List<String> optLang = this.extToLanguages.get(string2);
        if (optLang != null) {
            return optLang;
        }
        String secondExt = this.getExtension(ext);
        String string3 = secondExt.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        List<String> fallbackLang = this.extToLanguages.get(string3);
        if (fallbackLang != null) {
            return fallbackLang;
        }
        return language;
    }

    @NotNull
    public final String getExtension(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String lowercase = string;
        String extension = this.extensionCache.get(lowercase);
        if (extension != null) {
            return extension;
        }
        String ext = FilesKt.getExtension((File)new File(name));
        if (Intrinsics.areEqual((Object)ext, (Object)"") || StringsKt.last((CharSequence)name) == '.') {
            extension = name;
        } else {
            String subExt = FilesKt.getExtension((File)new File(StringsKt.removeSuffix((String)name, (CharSequence)("." + ext))));
            extension = StringsKt.removePrefix((String)(subExt + "." + ext), (CharSequence)".");
        }
        ((Map)this.extensionCache).put(name, extension);
        return extension;
    }

    private final void processLanguageFeatures(String name, Language value) {
        Object it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Trie complexityTrie = new Trie(null, null, null, 7, null);
        Trie slCommentTrie = new Trie(null, null, null, 7, null);
        Trie mlCommentTrie = new Trie(null, null, null, 7, null);
        Trie stringTrie = new Trie(null, null, null, 7, null);
        Trie tokenTrie = new Trie(null, null, null, 7, null);
        byte complexityMask = 0;
        byte singleLineCommentMask = 0;
        byte multiLineCommentMask = 0;
        byte stringMask = 0;
        byte processMask = 0;
        List<String> list = value.getComplexityChecks();
        if (list != null) {
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                complexityMask = (byte)(complexityMask | (byte)((String)it).charAt(0));
                complexityTrie.insert(TokenType.TComplexity, (String)it);
                if (this.Complexity) continue;
                tokenTrie.insert(TokenType.TComplexity, (String)it);
            }
        }
        if (!this.Complexity) {
            processMask = (byte)(processMask | complexityMask);
        }
        List<String> list2 = value.getLineComment();
        if (list2 != null) {
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                singleLineCommentMask = (byte)(singleLineCommentMask | (byte)((String)it).charAt(0));
                slCommentTrie.insert(TokenType.TSlcomment, (String)it);
                tokenTrie.insert(TokenType.TSlcomment, (String)it);
            }
        }
        processMask = (byte)(processMask | singleLineCommentMask);
        List<List<String>> list3 = value.getMultiLine();
        if (list3 != null) {
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (List)element$iv;
                boolean bl = false;
                multiLineCommentMask = (byte)(multiLineCommentMask | (byte)((String)it.get(0)).charAt(0));
                mlCommentTrie.insertClose(TokenType.TMlcomment, (String)it.get(0), (String)it.get(1));
                tokenTrie.insertClose(TokenType.TMlcomment, (String)it.get(0), (String)it.get(1));
            }
        }
        processMask = (byte)(processMask | multiLineCommentMask);
        List<Quote> list4 = value.getQuotes();
        if (list4 != null) {
            $this$forEach$iv = list4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Quote)element$iv;
                boolean bl = false;
                stringMask = (byte)(stringMask | (byte)((Quote)it).getStart().charAt(0));
                stringTrie.insertClose(TokenType.TString, ((Quote)it).getStart(), ((Quote)it).getEnd());
                tokenTrie.insertClose(TokenType.TString, ((Quote)it).getStart(), ((Quote)it).getEnd());
            }
        }
        processMask = (byte)(processMask | stringMask);
        this.languageFeatures.put(name, new LanguageFeature(complexityTrie, mlCommentTrie, slCommentTrie, stringTrie, tokenTrie, value.getNestedMultiLine(), complexityMask, multiLineCommentMask, singleLineCommentMask, stringMask, processMask, value.getKeywords(), value.getQuotes()));
    }

    @Nullable
    public final LanguageFeature getLanguageFeature(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.languageFeatures.get(language);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lcc/unitmesh/cf/language/LanguageService$Companion;", "", "()V", "isBinary", "", "index", "", "currentByte", "", "isWhitespace", "byte", "code-splitter"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isWhitespace(byte by) {
            return by == 32 || by == 9 || by == 10 || by == 13;
        }

        public final boolean isBinary(int index, byte currentByte) {
            return index < 10000 && currentByte == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/cf/language/LanguageService$LanguageGuess;", "", "name", "", "count", "", "(Ljava/lang/String;I)V", "getCount", "()I", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "code-splitter"})
    public static final class LanguageGuess {
        @NotNull
        private final String name;
        private final int count;

        public LanguageGuess(@NotNull String name, int count) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.count = count;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getCount() {
            return this.count;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final LanguageGuess copy(@NotNull String name, int count) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new LanguageGuess(name, count);
        }

        public static /* synthetic */ LanguageGuess copy$default(LanguageGuess languageGuess, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = languageGuess.name;
            }
            if ((n2 & 2) != 0) {
                n = languageGuess.count;
            }
            return languageGuess.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "LanguageGuess(name=" + this.name + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LanguageGuess)) {
                return false;
            }
            LanguageGuess languageGuess = (LanguageGuess)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)languageGuess.name)) {
                return false;
            }
            return this.count == languageGuess.count;
        }
    }
}

