/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.quality.testbadsmell;

import cc.unitmesh.quality.QualityAnalyser;
import cc.unitmesh.quality.testbadsmell.TbsResult;
import cc.unitmesh.quality.testbadsmell.TestBadSmell;
import chapi.domain.core.CodeAnnotation;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodeProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.archguard.rule.core.Issue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J2\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0002J:\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u001f0\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010'\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010(\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J@\u0010)\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\r2.\u0010\u001e\u001a*\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u001f0*j\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u001f`+H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006,"}, d2={"Lcc/unitmesh/quality/testbadsmell/TestBadsmellAnalyser;", "Lcc/unitmesh/quality/QualityAnalyser;", "thresholds", "", "", "", "(Ljava/util/Map;)V", "ASSERT_PARAMETER_SIZE", "DUPLICATED_LIMIT_SIZE", "getThresholds", "()Ljava/util/Map;", "addExtractAssertMethodCall", "", "Lchapi/domain/core/CodeCall;", "method", "Lchapi/domain/core/CodeFunction;", "node", "Lchapi/domain/core/CodeDataStruct;", "callMethodMap", "", "analysis", "Lorg/archguard/rule/core/Issue;", "nodes", "appendUnknownTest", "", "filePath", "tbsResult", "Lcc/unitmesh/quality/testbadsmell/TbsResult;", "buildCallMethodMap", "checkDuplicateAssertTest", "methodCallMap", "", "checkEmptyTest", "annotation", "Lchapi/domain/core/CodeAnnotation;", "checkIgnoreTest", "path", "checkRedundantAssertionTest", "funcCall", "checkRedundantPrintTest", "checkSleepyTest", "updateMethodCallMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "code-quality"})
@SourceDebugExtension(value={"SMAP\nTestBadsmellAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestBadsmellAnalyser.kt\ncc/unitmesh/quality/testbadsmell/TestBadsmellAnalyser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1549#2:195\n1620#2,3:196\n*S KotlinDebug\n*F\n+ 1 TestBadsmellAnalyser.kt\ncc/unitmesh/quality/testbadsmell/TestBadsmellAnalyser\n*L\n62#1:195\n62#1:196,3\n*E\n"})
public final class TestBadsmellAnalyser
implements QualityAnalyser {
    @NotNull
    private final Map<String, Integer> thresholds;
    private final int ASSERT_PARAMETER_SIZE;
    private final int DUPLICATED_LIMIT_SIZE;

    public TestBadsmellAnalyser(@NotNull Map<String, Integer> thresholds) {
        Intrinsics.checkNotNullParameter(thresholds, (String)"thresholds");
        this.thresholds = thresholds;
        this.ASSERT_PARAMETER_SIZE = 2;
        this.DUPLICATED_LIMIT_SIZE = 5;
    }

    public /* synthetic */ TestBadsmellAnalyser(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    @NotNull
    public final Map<String, Integer> getThresholds() {
        return this.thresholds;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Issue> analysis(@NotNull List<CodeDataStruct> nodes) {
        void $this$mapTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        TbsResult tbsResult = new TbsResult(CollectionsKt.emptyList());
        Map<String, CodeFunction> callMethodMap = this.buildCallMethodMap(nodes);
        for (CodeDataStruct node : nodes) {
            for (CodeFunction method : node.getFunctions()) {
                if (!method.isJUnitTest()) continue;
                List<CodeCall> currentMethodCalls = this.addExtractAssertMethodCall(method, node, callMethodMap);
                method.setFunctionCalls(currentMethodCalls);
                for (CodeAnnotation annotation : method.getAnnotations()) {
                    this.checkIgnoreTest(node.getFilePath(), annotation, tbsResult, method);
                    this.checkEmptyTest(node.getFilePath(), annotation, tbsResult, method);
                }
                HashMap<String, CodeCall[]> methodCallMap = new HashMap<String, CodeCall[]>();
                boolean hasAssert = false;
                object = currentMethodCalls.iterator();
                int n = 0;
                while (object.hasNext()) {
                    boolean lastFuncCall;
                    int index = n++;
                    CodeCall funcCall = (CodeCall)object.next();
                    if (Intrinsics.areEqual((Object)funcCall.getFunctionName(), (Object)"")) {
                        lastFuncCall = index == currentMethodCalls.size() - 1;
                        if (!lastFuncCall || hasAssert) continue;
                        this.appendUnknownTest(node.getFilePath(), method, tbsResult);
                        continue;
                    }
                    this.updateMethodCallMap(funcCall, methodCallMap);
                    this.checkRedundantPrintTest(node.getFilePath(), funcCall, tbsResult);
                    this.checkSleepyTest(node.getFilePath(), funcCall, tbsResult);
                    this.checkRedundantAssertionTest(node.getFilePath(), funcCall, tbsResult);
                    if (funcCall.hasAssertion()) {
                        hasAssert = true;
                    }
                    if (!(lastFuncCall = index == currentMethodCalls.size() - 1) || hasAssert) continue;
                    this.appendUnknownTest(node.getFilePath(), method, tbsResult);
                }
                this.checkDuplicateAssertTest(node, method, (Map<String, CodeCall[]>)methodCallMap, tbsResult);
            }
        }
        Iterable $this$map$iv = tbsResult.getResults();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (TestBadSmell)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toIssue());
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    private final List<CodeCall> addExtractAssertMethodCall(CodeFunction method, CodeDataStruct node, Map<String, CodeFunction> callMethodMap) {
        List methodCalls = method.getFunctionCalls();
        for (CodeCall methodCall : methodCalls) {
            CodeFunction mapFunc;
            if (!Intrinsics.areEqual((Object)methodCall.getNodeName(), (Object)node.getNodeName()) || (mapFunc = callMethodMap.get(methodCall.buildFullMethodName())) == null || Intrinsics.areEqual((Object)mapFunc.getName(), (Object)"")) continue;
            methodCalls = CollectionsKt.plus((Collection)methodCalls, (Iterable)mapFunc.getFunctionCalls());
        }
        return methodCalls;
    }

    private final void updateMethodCallMap(CodeCall funcCall, HashMap<String, CodeCall[]> methodCallMap) {
        Object[] calls = new CodeCall[]{};
        String buildFullMethodName = funcCall.buildFullMethodName();
        if (methodCallMap.get(buildFullMethodName) != null) {
            CodeCall[] codeCallArray = methodCallMap.get(buildFullMethodName);
            Intrinsics.checkNotNull((Object)codeCallArray);
            calls = codeCallArray;
        }
        calls = (CodeCall[])ArraysKt.plus((Object[])calls, (Object)funcCall);
        ((Map)methodCallMap).put(buildFullMethodName, calls);
    }

    private final void checkDuplicateAssertTest(CodeDataStruct node, CodeFunction method, Map<String, CodeCall[]> methodCallMap, TbsResult tbsResult) {
        boolean isDuplicateTest = false;
        for (Map.Entry<String, CodeCall[]> entry : methodCallMap.entrySet()) {
            Object[] methodCalls = entry.getValue();
            if (methodCalls.length < this.DUPLICATED_LIMIT_SIZE || !((CodeCall)ArraysKt.last((Object[])methodCalls)).hasAssertion()) continue;
            isDuplicateTest = true;
        }
        if (isDuplicateTest) {
            tbsResult.setResults(CollectionsKt.plus((Collection)tbsResult.getResults(), (Object)new TestBadSmell(node.getFilePath(), "DuplicateAssertTest", "", method.getPosition().getStartLine())));
        }
    }

    private final void appendUnknownTest(String filePath, CodeFunction method, TbsResult tbsResult) {
        tbsResult.setResults(CollectionsKt.plus((Collection)tbsResult.getResults(), (Object)new TestBadSmell(filePath, "UnknownTest", "", method.getPosition().getStartLine())));
    }

    private final void checkRedundantAssertionTest(String filePath, CodeCall funcCall, TbsResult tbsResult) {
        if (funcCall.getParameters().size() != this.ASSERT_PARAMETER_SIZE) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((CodeProperty)funcCall.getParameters().get(0)).getTypeValue(), (Object)((CodeProperty)funcCall.getParameters().get(1)).getTypeValue())) {
            return;
        }
        tbsResult.setResults(CollectionsKt.plus((Collection)tbsResult.getResults(), (Object)new TestBadSmell(filePath, "RedundantAssertionTest", "", funcCall.getPosition().getStartLine())));
    }

    private final void checkSleepyTest(String filePath, CodeCall funcCall, TbsResult tbsResult) {
        if (!funcCall.isThreadSleep()) {
            return;
        }
        tbsResult.setResults(CollectionsKt.plus((Collection)tbsResult.getResults(), (Object)new TestBadSmell(filePath, "SleepyTest", "", funcCall.getPosition().getStartLine())));
    }

    private final void checkRedundantPrintTest(String filePath, CodeCall funcCall, TbsResult tbsResult) {
        if (!funcCall.isSystemOutput()) {
            return;
        }
        tbsResult.setResults(CollectionsKt.plus((Collection)tbsResult.getResults(), (Object)new TestBadSmell(filePath, "RedundantPrintTest", "", funcCall.getPosition().getStartLine())));
    }

    private final void checkIgnoreTest(String path, CodeAnnotation annotation, TbsResult tbsResult, CodeFunction method) {
        if (!annotation.isIgnore()) {
            return;
        }
        tbsResult.setResults(CollectionsKt.plus((Collection)tbsResult.getResults(), (Object)new TestBadSmell(path, "IgnoreTest", "", method.getPosition().getStartLine())));
    }

    private final void checkEmptyTest(String filePath, CodeAnnotation annotation, TbsResult tbsResult, CodeFunction method) {
        boolean isJavaTest = StringsKt.endsWith$default((String)filePath, (String)".java", (boolean)false, (int)2, null) && annotation.isTest();
        boolean isGoTest = StringsKt.endsWith$default((String)filePath, (String)"_test.go", (boolean)false, (int)2, null);
        if (!isJavaTest && !isGoTest) {
            return;
        }
        if (method.getFunctionCalls().size() > 1) {
            return;
        }
        tbsResult.setResults(CollectionsKt.plus((Collection)tbsResult.getResults(), (Object)new TestBadSmell(filePath, "EmptyTest", "", method.getPosition().getStartLine())));
    }

    private final Map<String, CodeFunction> buildCallMethodMap(List<CodeDataStruct> nodes) {
        Map callMethodMap = new LinkedHashMap();
        for (CodeDataStruct node : nodes) {
            for (CodeFunction method : node.getFunctions()) {
                callMethodMap.put(method.buildFullMethodName(node), method);
            }
        }
        return callMethodMap;
    }

    public TestBadsmellAnalyser() {
        this(null, 1, null);
    }
}

