/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.rag.retriever;

import cc.unitmesh.rag.document.Document;
import cc.unitmesh.rag.retriever.Retriever;
import cc.unitmesh.rag.store.EmbeddingMatch;
import cc.unitmesh.rag.store.EmbeddingStore;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B%\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004J&\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\t0\u000ej\u0002`\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/rag/retriever/EmbeddingStoreRetriever;", "Lcc/unitmesh/rag/retriever/Retriever;", "Lcc/unitmesh/rag/document/Document;", "vectorStore", "Lcc/unitmesh/rag/store/EmbeddingStore;", "k", "", "(Lcc/unitmesh/rag/store/EmbeddingStore;I)V", "threshold", "", "(Lcc/unitmesh/rag/store/EmbeddingStore;ID)V", "Ljava/util/Optional;", "getEmbeddingStore", "retrieve", "", "Lcc/unitmesh/rag/store/EmbeddingMatch;", "query", "Lcc/unitmesh/nlp/embedding/Embedding;", "cocoa-core"})
public final class EmbeddingStoreRetriever
implements Retriever<Document> {
    @NotNull
    private EmbeddingStore<Document> vectorStore;
    private int k;
    @NotNull
    private Optional<Double> threshold;

    public EmbeddingStoreRetriever(@NotNull EmbeddingStore<Document> vectorStore, int k) {
        Intrinsics.checkNotNullParameter(vectorStore, (String)"vectorStore");
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.threshold = optional;
        this.vectorStore = vectorStore;
        this.k = k;
    }

    public /* synthetic */ EmbeddingStoreRetriever(EmbeddingStore embeddingStore, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 4;
        }
        this(embeddingStore, n);
    }

    public EmbeddingStoreRetriever(@NotNull EmbeddingStore<Document> vectorStore, int k, double threshold) {
        Intrinsics.checkNotNullParameter(vectorStore, (String)"vectorStore");
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.threshold = optional;
        this.vectorStore = vectorStore;
        this.k = k;
        Optional<Double> optional2 = Optional.of(threshold);
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
        this.threshold = optional2;
    }

    @NotNull
    public final EmbeddingStore<Document> getEmbeddingStore() {
        return this.vectorStore;
    }

    @Override
    @NotNull
    public List<EmbeddingMatch<Document>> retrieve(@NotNull List<Double> query) {
        List<EmbeddingMatch<Document>> list;
        Intrinsics.checkNotNullParameter(query, (String)"query");
        if (this.threshold.isPresent()) {
            Double d = this.threshold.get();
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"get(...)");
            list = this.vectorStore.findRelevant(query, this.k, ((Number)d).doubleValue());
        } else {
            list = this.vectorStore.findRelevant(query, this.k);
        }
        return list;
    }
}

