/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.process;

import cc.jinhx.process.ProcessException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class SpringUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringUtils.class);
    private static ApplicationContext applicationContext;

    public SpringUtils() {
        log.info("SpringUtils init");
    }

    public void setApplicationContext(ApplicationContext context) {
        applicationContext = context;
    }

    public static void load(ApplicationContext context) {
        applicationContext = context;
    }

    public static ApplicationContext getApplicationContext() {
        if (Objects.isNull(applicationContext)) {
            throw new ProcessException("ApplicationContext is null");
        }
        return applicationContext;
    }

    public static <T> void registerBean(Class<T> clazz, String beanName) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName(clazz.getName());
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    public static <T> T getBean(String name) {
        return (T)SpringUtils.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringUtils.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringUtils.getApplicationContext().getBean(name, clazz);
    }

    public static boolean containsBean(String name) {
        return SpringUtils.getApplicationContext().containsBean(name);
    }

    public static boolean isSingleton(String name) {
        return SpringUtils.getApplicationContext().isSingleton(name);
    }

    public static boolean isTypeMatch(String name, Class<?> clazz) {
        return SpringUtils.getApplicationContext().isTypeMatch(name, clazz);
    }

    public static String getProperty(String key) {
        return ((Environment)SpringUtils.getApplicationContext().getBean(Environment.class)).getProperty(key);
    }
}

