/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.process;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class ProcessResult<T>
implements Serializable {
    private static final long serialVersionUID = 8431670825594478958L;
    private T data;
    private Integer code;
    private String msg;

    private ProcessResult() {
    }

    public ProcessResult(T data) {
        this.data = data;
        this.code = BaseEnum.SUCCESS.getCode();
        this.msg = BaseEnum.SUCCESS.getMsg();
    }

    public ProcessResult(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public boolean isSuccess() {
        return BaseEnum.SUCCESS.getCode().equals(this.code);
    }

    public boolean isBusinessFail() {
        return BaseEnum.BUSINESS_FAIL.getCode().equals(this.code);
    }

    public boolean isUnknowFail() {
        return BaseEnum.UNKNOW_FAIL.getCode().equals(this.code);
    }

    public T getData() {
        return this.data;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessResult)) {
            return false;
        }
        ProcessResult other = (ProcessResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "ProcessResult(data=" + this.getData() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }

    public static enum BaseEnum {
        SUCCESS(1, "success"),
        BUSINESS_FAIL(0, "business fail"),
        UNKNOW_FAIL(-1, "unknown fail");

        private final Integer code;
        private final String msg;
        private static final Map<Integer, BaseEnum> MAP;

        public static Boolean containsCode(Integer code) {
            return MAP.containsKey(code);
        }

        public static String getMsg(Integer code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code).getMsg();
        }

        public static BaseEnum getEnum(Integer code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code);
        }

        private BaseEnum(Integer code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        static {
            MAP = Arrays.stream(BaseEnum.values()).collect(Collectors.toMap(BaseEnum::getCode, obj -> obj));
        }
    }
}

