/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.process;

import cc.jinhx.process.BusinessException;
import cc.jinhx.process.NodeChainContext;
import cc.jinhx.process.ProcessException;
import cc.jinhx.process.ProcessResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNode<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractNode.class);
    private final String NODE_LOG = "nodeLog ";
    private final String LOG_END = " execute success";
    private final String NODE_CHAIN_NAME = " nodeChainName=";
    private final String NODE_NAME = " nodeName=";
    private final String LOG_SKIP = " skip=";
    private final String LOG_TIME = " time=";
    private final String BEFORE_EXECUTE_PARAMS = " beforeExecuteParams=";
    private final String AFTER_EXECUTE_PARAMS = " afterExecuteParams=";
    private final String TRUE = "true";
    private final String FALSE = "false";
    private FailHandleEnum failHandle = FailHandleEnum.INTERRUPT;
    private Long timeout = TimeoutEnum.COMMONLY.getCode();
    private RetryTimesEnum retryTimes = RetryTimesEnum.ONE;

    protected abstract boolean getSkip(NodeChainContext<T> var1);

    protected void checkParams(NodeChainContext<T> nodeChainContext) {
    }

    protected abstract void process(NodeChainContext<T> var1);

    public void execute(NodeChainContext<T> nodeChainContext, LogLevelEnum logLevel, String nodeChainName) {
        String logStr = "nodeLog " + nodeChainContext.getLogStr();
        String nodeName = this.getClass().getName();
        try {
            StringBuilder logInfo = new StringBuilder(logStr);
            this.buildLogInfo(logInfo, Arrays.asList(" execute success", " nodeChainName=", nodeChainName, " nodeName=", nodeName), logLevel, LogLevelEnum.BASE, false);
            this.buildLogInfo(logInfo, Arrays.asList(" beforeExecuteParams=", nodeChainContext.toString()), logLevel, LogLevelEnum.BASE_AND_TIME_AND_PARAMS, false);
            long startTime = System.currentTimeMillis();
            if (this.getSkip(nodeChainContext)) {
                this.buildLogInfo(logInfo, Arrays.asList(" skip=", "true"), logLevel, LogLevelEnum.BASE, false);
            } else {
                try {
                    this.checkParams(nodeChainContext);
                }
                catch (ProcessException e) {
                    throw e;
                }
                catch (BusinessException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw e;
                }
                this.buildLogInfo(logInfo, Arrays.asList(" skip=", "false"), logLevel, LogLevelEnum.BASE, false);
                try {
                    this.process(nodeChainContext);
                }
                catch (ProcessException e) {
                    throw e;
                }
                catch (BusinessException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw e;
                }
            }
            long endTime = System.currentTimeMillis();
            this.buildLogInfo(logInfo, Arrays.asList(" afterExecuteParams=", nodeChainContext.toString()), logLevel, LogLevelEnum.BASE_AND_TIME_AND_PARAMS, false);
            this.buildLogInfo(logInfo, Arrays.asList(" time=", endTime - startTime), logLevel, LogLevelEnum.BASE_AND_TIME, true);
        }
        catch (ProcessException e) {
            throw e;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void buildLogInfo(StringBuilder logInfo, List<Object> logInfos, LogLevelEnum logLevel, LogLevelEnum thisLogLevel, Boolean print) {
        if (Objects.isNull((Object)logLevel) || !LogLevelEnum.containsCode(logLevel.getCode()).booleanValue()) {
            logLevel = LogLevelEnum.BASE_AND_TIME;
        }
        if (thisLogLevel.getCode() <= logLevel.getCode() && !LogLevelEnum.NO.getCode().equals(logLevel.getCode())) {
            logInfos.forEach(logInfo::append);
        }
        if (print.booleanValue() && !LogLevelEnum.NO.getCode().equals(logLevel.getCode())) {
            log.info(logInfo.toString());
            logInfo.setLength(0);
        }
    }

    protected void businessFail(Integer code, String msg) {
        throw new BusinessException(code, msg);
    }

    protected void businessFail(String msg) {
        throw new BusinessException(ProcessResult.BaseEnum.BUSINESS_FAIL.getCode(), msg);
    }

    protected <T> T getContextInfo(NodeChainContext<T> nodeChainContext) {
        if (Objects.isNull(nodeChainContext)) {
            return null;
        }
        return nodeChainContext.getContextInfo();
    }

    protected void onSuccess(NodeChainContext<T> nodeChainContext) {
    }

    protected abstract void onTimeoutFail(NodeChainContext<T> var1);

    protected abstract void onBusinessFail(NodeChainContext<T> var1, BusinessException var2);

    protected abstract void onUnknowFail(NodeChainContext<T> var1, Exception var2);

    protected void afterProcess(NodeChainContext<T> nodeChainContext) {
    }

    public String getNODE_LOG() {
        return this.NODE_LOG;
    }

    public String getLOG_END() {
        return this.LOG_END;
    }

    public String getNODE_CHAIN_NAME() {
        return this.NODE_CHAIN_NAME;
    }

    public String getNODE_NAME() {
        return this.NODE_NAME;
    }

    public String getLOG_SKIP() {
        return this.LOG_SKIP;
    }

    public String getLOG_TIME() {
        return this.LOG_TIME;
    }

    public String getBEFORE_EXECUTE_PARAMS() {
        return this.BEFORE_EXECUTE_PARAMS;
    }

    public String getAFTER_EXECUTE_PARAMS() {
        return this.AFTER_EXECUTE_PARAMS;
    }

    public String getTRUE() {
        return this.TRUE;
    }

    public String getFALSE() {
        return this.FALSE;
    }

    public FailHandleEnum getFailHandle() {
        return this.failHandle;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public RetryTimesEnum getRetryTimes() {
        return this.retryTimes;
    }

    public void setFailHandle(FailHandleEnum failHandle) {
        this.failHandle = failHandle;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public void setRetryTimes(RetryTimesEnum retryTimes) {
        this.retryTimes = retryTimes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractNode)) {
            return false;
        }
        AbstractNode other = (AbstractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$NODE_LOG = this.getNODE_LOG();
        String other$NODE_LOG = other.getNODE_LOG();
        if (this$NODE_LOG == null ? other$NODE_LOG != null : !this$NODE_LOG.equals(other$NODE_LOG)) {
            return false;
        }
        String this$LOG_END = this.getLOG_END();
        String other$LOG_END = other.getLOG_END();
        if (this$LOG_END == null ? other$LOG_END != null : !this$LOG_END.equals(other$LOG_END)) {
            return false;
        }
        String this$NODE_CHAIN_NAME = this.getNODE_CHAIN_NAME();
        String other$NODE_CHAIN_NAME = other.getNODE_CHAIN_NAME();
        if (this$NODE_CHAIN_NAME == null ? other$NODE_CHAIN_NAME != null : !this$NODE_CHAIN_NAME.equals(other$NODE_CHAIN_NAME)) {
            return false;
        }
        String this$NODE_NAME = this.getNODE_NAME();
        String other$NODE_NAME = other.getNODE_NAME();
        if (this$NODE_NAME == null ? other$NODE_NAME != null : !this$NODE_NAME.equals(other$NODE_NAME)) {
            return false;
        }
        String this$LOG_SKIP = this.getLOG_SKIP();
        String other$LOG_SKIP = other.getLOG_SKIP();
        if (this$LOG_SKIP == null ? other$LOG_SKIP != null : !this$LOG_SKIP.equals(other$LOG_SKIP)) {
            return false;
        }
        String this$LOG_TIME = this.getLOG_TIME();
        String other$LOG_TIME = other.getLOG_TIME();
        if (this$LOG_TIME == null ? other$LOG_TIME != null : !this$LOG_TIME.equals(other$LOG_TIME)) {
            return false;
        }
        String this$BEFORE_EXECUTE_PARAMS = this.getBEFORE_EXECUTE_PARAMS();
        String other$BEFORE_EXECUTE_PARAMS = other.getBEFORE_EXECUTE_PARAMS();
        if (this$BEFORE_EXECUTE_PARAMS == null ? other$BEFORE_EXECUTE_PARAMS != null : !this$BEFORE_EXECUTE_PARAMS.equals(other$BEFORE_EXECUTE_PARAMS)) {
            return false;
        }
        String this$AFTER_EXECUTE_PARAMS = this.getAFTER_EXECUTE_PARAMS();
        String other$AFTER_EXECUTE_PARAMS = other.getAFTER_EXECUTE_PARAMS();
        if (this$AFTER_EXECUTE_PARAMS == null ? other$AFTER_EXECUTE_PARAMS != null : !this$AFTER_EXECUTE_PARAMS.equals(other$AFTER_EXECUTE_PARAMS)) {
            return false;
        }
        String this$TRUE = this.getTRUE();
        String other$TRUE = other.getTRUE();
        if (this$TRUE == null ? other$TRUE != null : !this$TRUE.equals(other$TRUE)) {
            return false;
        }
        String this$FALSE = this.getFALSE();
        String other$FALSE = other.getFALSE();
        if (this$FALSE == null ? other$FALSE != null : !this$FALSE.equals(other$FALSE)) {
            return false;
        }
        FailHandleEnum this$failHandle = this.getFailHandle();
        FailHandleEnum other$failHandle = other.getFailHandle();
        if (this$failHandle == null ? other$failHandle != null : !((Object)((Object)this$failHandle)).equals((Object)other$failHandle)) {
            return false;
        }
        RetryTimesEnum this$retryTimes = this.getRetryTimes();
        RetryTimesEnum other$retryTimes = other.getRetryTimes();
        return !(this$retryTimes == null ? other$retryTimes != null : !((Object)((Object)this$retryTimes)).equals((Object)other$retryTimes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $NODE_LOG = this.getNODE_LOG();
        result = result * 59 + ($NODE_LOG == null ? 43 : $NODE_LOG.hashCode());
        String $LOG_END = this.getLOG_END();
        result = result * 59 + ($LOG_END == null ? 43 : $LOG_END.hashCode());
        String $NODE_CHAIN_NAME = this.getNODE_CHAIN_NAME();
        result = result * 59 + ($NODE_CHAIN_NAME == null ? 43 : $NODE_CHAIN_NAME.hashCode());
        String $NODE_NAME = this.getNODE_NAME();
        result = result * 59 + ($NODE_NAME == null ? 43 : $NODE_NAME.hashCode());
        String $LOG_SKIP = this.getLOG_SKIP();
        result = result * 59 + ($LOG_SKIP == null ? 43 : $LOG_SKIP.hashCode());
        String $LOG_TIME = this.getLOG_TIME();
        result = result * 59 + ($LOG_TIME == null ? 43 : $LOG_TIME.hashCode());
        String $BEFORE_EXECUTE_PARAMS = this.getBEFORE_EXECUTE_PARAMS();
        result = result * 59 + ($BEFORE_EXECUTE_PARAMS == null ? 43 : $BEFORE_EXECUTE_PARAMS.hashCode());
        String $AFTER_EXECUTE_PARAMS = this.getAFTER_EXECUTE_PARAMS();
        result = result * 59 + ($AFTER_EXECUTE_PARAMS == null ? 43 : $AFTER_EXECUTE_PARAMS.hashCode());
        String $TRUE = this.getTRUE();
        result = result * 59 + ($TRUE == null ? 43 : $TRUE.hashCode());
        String $FALSE = this.getFALSE();
        result = result * 59 + ($FALSE == null ? 43 : $FALSE.hashCode());
        FailHandleEnum $failHandle = this.getFailHandle();
        result = result * 59 + ($failHandle == null ? 43 : ((Object)((Object)$failHandle)).hashCode());
        RetryTimesEnum $retryTimes = this.getRetryTimes();
        result = result * 59 + ($retryTimes == null ? 43 : ((Object)((Object)$retryTimes)).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractNode(NODE_LOG=" + this.getNODE_LOG() + ", LOG_END=" + this.getLOG_END() + ", NODE_CHAIN_NAME=" + this.getNODE_CHAIN_NAME() + ", NODE_NAME=" + this.getNODE_NAME() + ", LOG_SKIP=" + this.getLOG_SKIP() + ", LOG_TIME=" + this.getLOG_TIME() + ", BEFORE_EXECUTE_PARAMS=" + this.getBEFORE_EXECUTE_PARAMS() + ", AFTER_EXECUTE_PARAMS=" + this.getAFTER_EXECUTE_PARAMS() + ", TRUE=" + this.getTRUE() + ", FALSE=" + this.getFALSE() + ", failHandle=" + (Object)((Object)this.getFailHandle()) + ", timeout=" + this.getTimeout() + ", retryTimes=" + (Object)((Object)this.getRetryTimes()) + ")";
    }

    public static enum RetryTimesEnum {
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5);

        private final Integer code;
        private static final Map<Integer, RetryTimesEnum> MAP;

        public static Boolean containsCode(Integer code) {
            return MAP.containsKey(code);
        }

        public static RetryTimesEnum getEnum(Integer code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code);
        }

        private RetryTimesEnum(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return this.code;
        }

        static {
            MAP = Arrays.stream(RetryTimesEnum.values()).collect(Collectors.toMap(RetryTimesEnum::getCode, obj -> obj));
        }
    }

    public static enum FailHandleEnum {
        INTERRUPT(1, "\u4e2d\u65ad\u94fe\u8def"),
        ABANDON(2, "\u629b\u5f03\u8282\u70b9"),
        RETRY(3, "\u91cd\u8bd5\u8282\u70b9");

        private final Integer code;
        private final String msg;
        private static final Map<Integer, FailHandleEnum> MAP;

        public static Boolean containsCode(Integer code) {
            return MAP.containsKey(code);
        }

        public static String getMsg(Integer code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code).getMsg();
        }

        public static FailHandleEnum getEnum(Integer code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code);
        }

        private FailHandleEnum(Integer code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        static {
            MAP = Arrays.stream(FailHandleEnum.values()).collect(Collectors.toMap(FailHandleEnum::getCode, obj -> obj));
        }
    }

    public static enum LogLevelEnum {
        NO(1, "\u4e0d\u6253\u5370"),
        BASE(2, "\u6253\u5370\u57fa\u672c\u4fe1\u606f"),
        BASE_AND_TIME(3, "\u6253\u5370\u57fa\u672c\u4fe1\u606f\u548c\u8017\u65f6"),
        BASE_AND_TIME_AND_PARAMS(4, "\u6253\u5370\u57fa\u672c\u4fe1\u606f\u548c\u8017\u65f6\u548c\u53c2\u6570");

        private final Integer code;
        private final String msg;
        private static final Map<Integer, LogLevelEnum> MAP;

        public static Boolean containsCode(Integer code) {
            return MAP.containsKey(code);
        }

        public static String getMsg(Integer code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code).getMsg();
        }

        public static LogLevelEnum getEnum(Integer code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code);
        }

        private LogLevelEnum(Integer code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        static {
            MAP = Arrays.stream(LogLevelEnum.values()).collect(Collectors.toMap(LogLevelEnum::getCode, obj -> obj));
        }
    }

    public static enum TimeoutEnum {
        SHORT(50L, "\u77ed"),
        SHORTER(100L, "\u8f83\u77ed"),
        COMMONLY(200L, "\u4e00\u822c"),
        LONGER(500L, "\u8f83\u957f"),
        LONG(1000L, "\u957f");

        private final Long code;
        private final String msg;
        private static final Map<Long, TimeoutEnum> MAP;

        public static Boolean containsCode(Long code) {
            return MAP.containsKey(code);
        }

        public static String getMsg(Long code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code).getMsg();
        }

        public static TimeoutEnum getEnum(Long code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code);
        }

        private TimeoutEnum(Long code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public Long getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        static {
            MAP = Arrays.stream(TimeoutEnum.values()).collect(Collectors.toMap(TimeoutEnum::getCode, obj -> obj));
        }
    }
}

