/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.process;

import cc.jinhx.process.AbstractNodeChain;
import cc.jinhx.process.BusinessException;
import cc.jinhx.process.LogicHandlerBaseInfo;
import cc.jinhx.process.NodeChainContext;
import cc.jinhx.process.NodeChainManager;
import cc.jinhx.process.ProcessException;
import cc.jinhx.process.ProcessResult;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractLogicHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogicHandler.class);
    private LogicHandlerBaseInfo logicHandlerBaseInfo;

    protected AbstractLogicHandler() {
        this.init(new LogicHandlerBaseInfo(), null);
    }

    protected AbstractLogicHandler(LogicHandlerBaseInfo logicHandlerBaseInfo) {
        if (Objects.isNull(logicHandlerBaseInfo)) {
            throw new ProcessException(ProcessException.MsgEnum.LOGIC_HANDLER_BASE_INFO_NOT_NULL);
        }
        this.init(logicHandlerBaseInfo, null);
    }

    protected AbstractLogicHandler(LogicHandlerBaseInfo logicHandlerBaseInfo, String logStr) {
        if (Objects.isNull(logicHandlerBaseInfo)) {
            throw new ProcessException(ProcessException.MsgEnum.LOGIC_HANDLER_BASE_INFO_NOT_NULL);
        }
        if (StringUtils.isEmpty((Object)logStr)) {
            throw new ProcessException(ProcessException.MsgEnum.LOGIC_HANDLER_LOG_STR_NOT_NULL);
        }
        this.init(logicHandlerBaseInfo, logStr);
    }

    private void init(LogicHandlerBaseInfo logicHandlerBaseInfo, String logStr) {
        this.logicHandlerBaseInfo = logicHandlerBaseInfo;
        if (StringUtils.isEmpty((Object)logStr)) {
            logicHandlerBaseInfo.setLogStr("act=" + Thread.currentThread().getStackTrace()[4].getMethodName());
        } else {
            logicHandlerBaseInfo.setLogStr(logStr + " act=" + Thread.currentThread().getStackTrace()[4].getMethodName());
        }
    }

    protected abstract void checkParams();

    protected abstract ProcessResult<T> process();

    public ProcessResult<T> execute() {
        return this.doExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessResult<T> doExecute() {
        try {
            this.checkParams();
            log.info("handlerLog {} checkParams success req={}", (Object)this.logicHandlerBaseInfo.getLogStr(), (Object)this.logicHandlerBaseInfo.toString());
        }
        catch (ProcessException e) {
            log.error("handlerLog {} execute process fail msg={}", (Object)this.logicHandlerBaseInfo.getLogStr(), (Object)e.getMsg());
            this.onUnknowFail(e);
            return this.buildFailResult(e.getCode(), e.getMsg());
        }
        catch (BusinessException e) {
            log.error("handlerLog {} checkParams business fail req={} msg={}", new Object[]{this.logicHandlerBaseInfo.getLogStr(), this.logicHandlerBaseInfo.toString(), e.getMsg()});
            this.onBusinessFail(e);
            return this.buildBusinessFailResult(e.getCode(), e.getMsg());
        }
        catch (Exception e) {
            String exceptionLog = this.getExceptionLog(e);
            log.error("handlerLog {} checkParams fail req={} msg={}", new Object[]{this.logicHandlerBaseInfo.getLogStr(), this.logicHandlerBaseInfo.toString(), exceptionLog});
            this.onUnknowFail(e);
            return this.buildUnknownFailResult(exceptionLog);
        }
        try {
            long startTime = System.currentTimeMillis();
            ProcessResult<T> result = this.process();
            long endTime = System.currentTimeMillis();
            log.info("handlerLog {} execute success time={} rsp={}", new Object[]{this.logicHandlerBaseInfo.getLogStr(), endTime - startTime, result.toString()});
            this.onSuccess();
            ProcessResult<T> processResult = result;
            return processResult;
        }
        catch (ProcessException e) {
            log.error("handlerLog {} execute process fail msg={}", (Object)this.logicHandlerBaseInfo.getLogStr(), (Object)e.getMsg());
            this.onUnknowFail(e);
            ProcessResult<T> exceptionLog = this.buildFailResult(e.getCode(), e.getMsg());
            return exceptionLog;
        }
        catch (BusinessException e) {
            log.error("handlerLog {} execute business fail msg={}", (Object)this.logicHandlerBaseInfo.getLogStr(), (Object)e.getMsg());
            this.onBusinessFail(e);
            ProcessResult<T> exceptionLog = this.buildBusinessFailResult(e.getCode(), e.getMsg());
            return exceptionLog;
        }
        catch (Exception e) {
            String exceptionLog = this.getExceptionLog(e);
            log.error("handlerLog {} execute fail msg={}", (Object)this.logicHandlerBaseInfo.getLogStr(), (Object)exceptionLog);
            this.onUnknowFail(e);
            ProcessResult<T> processResult = this.buildUnknownFailResult(exceptionLog);
            return processResult;
        }
        finally {
            this.afterProcess();
        }
    }

    private String getExceptionLog(Exception e) {
        if (Objects.nonNull(e)) {
            StackTraceElement[] stackTrace;
            StringBuilder stringBuffer = new StringBuilder("\n");
            if (Objects.nonNull(e.getMessage())) {
                stringBuffer.append(e.getMessage()).append("\n");
            }
            if (Objects.nonNull(e.getCause()) && Objects.nonNull(stackTrace = e.getCause().getStackTrace()) && stackTrace.length > 0) {
                for (StackTraceElement stackTraceElement : stackTrace) {
                    stringBuffer.append(stackTraceElement.toString()).append("\n");
                }
                return stringBuffer.toString();
            }
        }
        return null;
    }

    protected void executeNodeChain(Class<? extends AbstractNodeChain> clazz, NodeChainContext<?> nodeChainContext, ThreadPoolExecutor threadPoolExecutor) {
        this.executeNodeChain(clazz, null, nodeChainContext, threadPoolExecutor);
    }

    protected void executeNodeChain(Class<? extends AbstractNodeChain> clazz, NodeChainContext<?> nodeChainContext) {
        this.executeNodeChain(clazz, null, nodeChainContext);
    }

    protected void executeNodeChain(Class<? extends AbstractNodeChain> clazz, AbstractNodeChain.LogLevelEnum logLevel, NodeChainContext<?> nodeChainContext, ThreadPoolExecutor threadPoolExecutor) {
        this.getNodeChain(clazz, logLevel).execute(nodeChainContext, threadPoolExecutor);
    }

    protected void executeNodeChain(Class<? extends AbstractNodeChain> clazz, AbstractNodeChain.LogLevelEnum logLevel, NodeChainContext<?> nodeChainContext) {
        this.getNodeChain(clazz, logLevel).execute(nodeChainContext);
    }

    private AbstractNodeChain getNodeChain(Class<? extends AbstractNodeChain> clazz, AbstractNodeChain.LogLevelEnum logLevel) {
        AbstractNodeChain abstractNodeChain = NodeChainManager.getNodeChain(clazz, logLevel);
        if (Objects.isNull(abstractNodeChain)) {
            throw new ProcessException(ProcessException.MsgEnum.NODE_CHAIN_UNREGISTERED.getMsg() + "=" + clazz.getName());
        }
        return abstractNodeChain;
    }

    protected void businessFail(Integer code, String msg) {
        throw new BusinessException(code, msg);
    }

    protected void businessFail(String msg) {
        throw new BusinessException(ProcessResult.BaseEnum.BUSINESS_FAIL.getCode(), msg);
    }

    protected void afterProcess() {
    }

    protected <T> NodeChainContext<T> buildNodeChainContext(Class<T> clazz) {
        return NodeChainContext.create(clazz);
    }

    protected ProcessResult<T> buildSuccessResult(T data) {
        return new ProcessResult<T>(data);
    }

    protected ProcessResult<T> buildFailResult(Integer code, String msg) {
        return new ProcessResult(code, msg);
    }

    protected ProcessResult<T> buildUnknownFailResult(String msg) {
        return new ProcessResult(ProcessResult.BaseEnum.UNKNOW_FAIL.getCode(), msg);
    }

    protected ProcessResult<T> buildBusinessFailResult(String msg) {
        return new ProcessResult(ProcessResult.BaseEnum.BUSINESS_FAIL.getCode(), msg);
    }

    protected ProcessResult<T> buildBusinessFailResult(Integer code, String msg) {
        return new ProcessResult(code, msg);
    }

    protected void onSuccess() {
    }

    protected void onBusinessFail(BusinessException e) {
    }

    protected void onUnknowFail(Exception e) {
    }
}

