/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.process;

import cc.jinhx.process.AbstractNode;
import cc.jinhx.process.SpringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeManager {
    private static final Logger log = LoggerFactory.getLogger(NodeManager.class);
    private static Map<String, AbstractNode> MAP = new HashMap<String, AbstractNode>();

    public void addNode(String key, AbstractNode abstractNode) {
        MAP.put(key, abstractNode);
    }

    public static AbstractNode getNode(Class<? extends AbstractNode> clazz, AbstractNode.FailHandleEnum failHandle, Long timeout, AbstractNode.RetryTimesEnum retryTimes) {
        String key = clazz.getName() + ":";
        key = Objects.isNull((Object)failHandle) ? key + null + ":" + timeout + ":" : key + failHandle.getCode() + ":" + timeout + ":";
        key = Objects.isNull((Object)retryTimes) ? key + null : key + retryTimes.getCode();
        if (MAP.containsKey(key)) {
            return MAP.get(key);
        }
        AbstractNode abstractNode = NodeManager.createNode(clazz, failHandle, timeout, retryTimes);
        if (Objects.nonNull(abstractNode)) {
            MAP.put(key, abstractNode);
        }
        return abstractNode;
    }

    private static AbstractNode createNode(Class<? extends AbstractNode> clazz, AbstractNode.FailHandleEnum failHandle, Long timeout, AbstractNode.RetryTimesEnum retryTimes) {
        try {
            Constructor<? extends AbstractNode> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            AbstractNode abstractNode = constructor.newInstance(new Object[0]);
            if (Objects.nonNull((Object)failHandle) && AbstractNode.FailHandleEnum.containsCode(failHandle.getCode()).booleanValue()) {
                Method setFailHandleMethod = clazz.getMethod("setFailHandle", AbstractNode.FailHandleEnum.class);
                setFailHandleMethod.setAccessible(true);
                setFailHandleMethod.invoke((Object)abstractNode, new Object[]{failHandle});
            }
            if (Objects.nonNull((Object)retryTimes) && AbstractNode.RetryTimesEnum.containsCode(retryTimes.getCode()).booleanValue()) {
                Method setRetryTimesMethod = clazz.getMethod("setRetryTimes", AbstractNode.RetryTimesEnum.class);
                setRetryTimesMethod.setAccessible(true);
                setRetryTimesMethod.invoke((Object)abstractNode, new Object[]{retryTimes});
            }
            if (Objects.nonNull(timeout) && timeout > 0L) {
                Method setTimeoutMethod = clazz.getMethod("setTimeout", Long.class);
                setTimeoutMethod.setAccessible(true);
                setTimeoutMethod.invoke((Object)abstractNode, timeout);
            }
            for (Field declaredField : clazz.getDeclaredFields()) {
                declaredField.setAccessible(true);
                if (!Objects.isNull(declaredField.get(abstractNode))) continue;
                if (Objects.nonNull(declaredField.getAnnotation(Resource.class))) {
                    declaredField.set(abstractNode, SpringUtils.getBean(declaredField.getName(), declaredField.getType()));
                    continue;
                }
                if (!Objects.nonNull(declaredField.getAnnotation(Autowired.class))) continue;
                declaredField.set(abstractNode, SpringUtils.getBean(declaredField.getType()));
            }
            return abstractNode;
        }
        catch (Exception e) {
            log.error("createNode reflex create object fail clazz={} failHandle={} timeout={} error={}", new Object[]{clazz, failHandle, timeout, e});
            return null;
        }
    }
}

