/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.process;

import cc.jinhx.process.AbstractNodeChain;
import cc.jinhx.process.SpringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeChainManager {
    private static final Logger log = LoggerFactory.getLogger(NodeChainManager.class);
    private static Map<String, AbstractNodeChain> MAP = new HashMap<String, AbstractNodeChain>();

    public void addNodeChain(String key, AbstractNodeChain abstractNodeChain) {
        MAP.put(key, abstractNodeChain);
    }

    public static AbstractNodeChain getNodeChain(Class<? extends AbstractNodeChain> clazz, AbstractNodeChain.LogLevelEnum logLevel) {
        String key = clazz.getName() + ":";
        key = Objects.isNull((Object)logLevel) ? key + null : key + logLevel.getCode();
        if (MAP.containsKey(key)) {
            return MAP.get(key);
        }
        AbstractNodeChain abstractNodeChain = NodeChainManager.createNodeChain(clazz, logLevel);
        if (Objects.nonNull(abstractNodeChain)) {
            MAP.put(key, abstractNodeChain);
        }
        return abstractNodeChain;
    }

    private static AbstractNodeChain createNodeChain(Class<? extends AbstractNodeChain> clazz, AbstractNodeChain.LogLevelEnum logLevel) {
        try {
            Constructor<? extends AbstractNodeChain> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            AbstractNodeChain abstractNodeChain = constructor.newInstance(new Object[0]);
            Method setNodeInfoMethod = clazz.getDeclaredMethod("setNodeInfo", new Class[0]);
            setNodeInfoMethod.setAccessible(true);
            setNodeInfoMethod.invoke((Object)abstractNodeChain, new Object[0]);
            if (Objects.nonNull((Object)logLevel) && AbstractNodeChain.LogLevelEnum.containsCode(logLevel.getCode()).booleanValue()) {
                Method setLogLevelMethod = clazz.getMethod("setLogLevel", AbstractNodeChain.LogLevelEnum.class);
                setLogLevelMethod.setAccessible(true);
                setLogLevelMethod.invoke((Object)abstractNodeChain, new Object[]{logLevel});
            }
            for (Field declaredField : clazz.getDeclaredFields()) {
                declaredField.setAccessible(true);
                if (!Objects.isNull(declaredField.get(abstractNodeChain))) continue;
                if (Objects.nonNull(declaredField.getAnnotation(Resource.class))) {
                    declaredField.set(abstractNodeChain, SpringUtils.getBean(declaredField.getName(), declaredField.getType()));
                    continue;
                }
                if (!Objects.nonNull(declaredField.getAnnotation(Autowired.class))) continue;
                declaredField.set(abstractNodeChain, SpringUtils.getBean(declaredField.getType()));
            }
            return abstractNodeChain;
        }
        catch (Exception e) {
            log.error("createNodeChain reflex create object fail clazz={} logLevel={} error={}", new Object[]{clazz, logLevel, e});
            return null;
        }
    }
}

