/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.process;

import cc.jinhx.process.ProcessException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NodeChainContext<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(NodeChainContext.class);
    private static final long serialVersionUID = -4351960350192549045L;
    protected T contextInfo;
    protected String logStr;
    protected Boolean exNextNodeGroup = true;

    private NodeChainContext(T contextInfo, String logStr) {
        this.contextInfo = contextInfo;
        this.setLogStr(logStr);
    }

    private NodeChainContext() {
    }

    public static <T> NodeChainContext<T> create(T contextInfo, String logStr) {
        if (Objects.isNull(contextInfo)) {
            throw new ProcessException(ProcessException.MsgEnum.NODE_CHAIN_CONTEXT_INFO_NOT_NULL);
        }
        if (StringUtils.isEmpty((Object)logStr)) {
            throw new ProcessException(ProcessException.MsgEnum.NODE_CHAIN_LOG_STR_NOT_NULL);
        }
        return new NodeChainContext<T>(contextInfo, logStr + " act=" + Thread.currentThread().getStackTrace()[4].getMethodName());
    }

    public static <T> NodeChainContext<T> create(Class<T> clazz) {
        return new NodeChainContext<T>(NodeChainContext.createNodeChainContext(clazz), "act=" + Thread.currentThread().getStackTrace()[4].getMethodName());
    }

    public static <T> NodeChainContext<T> create(T contextInfo) {
        return new NodeChainContext<T>(contextInfo, "act=" + Thread.currentThread().getStackTrace()[4].getMethodName());
    }

    public static <T> NodeChainContext<T> create(Class<T> clazz, String logStr) {
        if (Objects.isNull(clazz)) {
            throw new ProcessException(ProcessException.MsgEnum.NODE_CHAIN_CLASS_NOT_NULL);
        }
        if (StringUtils.isEmpty((Object)logStr)) {
            throw new ProcessException(ProcessException.MsgEnum.NODE_CHAIN_LOG_STR_NOT_NULL);
        }
        return new NodeChainContext<T>(NodeChainContext.createNodeChainContext(clazz), logStr + " act=" + Thread.currentThread().getStackTrace()[4].getMethodName());
    }

    public void setLogStr(String logStr) {
        this.logStr = StringUtils.isEmpty((Object)this.logStr) ? logStr : this.logStr + " " + logStr;
    }

    private static <T> T createNodeChainContext(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("createNodeChainContext reflex create object fail clazz={} error={}", clazz, (Object)e);
            return null;
        }
    }

    public T getContextInfo() {
        return this.contextInfo;
    }

    public String getLogStr() {
        return this.logStr;
    }

    public Boolean getExNextNodeGroup() {
        return this.exNextNodeGroup;
    }

    public void setContextInfo(T contextInfo) {
        this.contextInfo = contextInfo;
    }

    public void setExNextNodeGroup(Boolean exNextNodeGroup) {
        this.exNextNodeGroup = exNextNodeGroup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeChainContext)) {
            return false;
        }
        NodeChainContext other = (NodeChainContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$exNextNodeGroup = this.getExNextNodeGroup();
        Boolean other$exNextNodeGroup = other.getExNextNodeGroup();
        if (this$exNextNodeGroup == null ? other$exNextNodeGroup != null : !((Object)this$exNextNodeGroup).equals(other$exNextNodeGroup)) {
            return false;
        }
        T this$contextInfo = this.getContextInfo();
        T other$contextInfo = other.getContextInfo();
        if (this$contextInfo == null ? other$contextInfo != null : !this$contextInfo.equals(other$contextInfo)) {
            return false;
        }
        String this$logStr = this.getLogStr();
        String other$logStr = other.getLogStr();
        return !(this$logStr == null ? other$logStr != null : !this$logStr.equals(other$logStr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeChainContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $exNextNodeGroup = this.getExNextNodeGroup();
        result = result * 59 + ($exNextNodeGroup == null ? 43 : ((Object)$exNextNodeGroup).hashCode());
        T $contextInfo = this.getContextInfo();
        result = result * 59 + ($contextInfo == null ? 43 : $contextInfo.hashCode());
        String $logStr = this.getLogStr();
        result = result * 59 + ($logStr == null ? 43 : $logStr.hashCode());
        return result;
    }

    public String toString() {
        return "NodeChainContext(contextInfo=" + this.getContextInfo() + ", logStr=" + this.getLogStr() + ", exNextNodeGroup=" + this.getExNextNodeGroup() + ")";
    }
}

