/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.process;

import cc.jinhx.process.AbstractNode;
import cc.jinhx.process.BusinessException;
import cc.jinhx.process.NodeChainContext;
import cc.jinhx.process.NodeManager;
import cc.jinhx.process.ProcessException;
import cc.jinhx.process.ThreadPoolManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeChain
extends LinkedHashMap<String, List<AbstractNode>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractNodeChain.class);
    private static final long serialVersionUID = 4780080785208529405L;
    private LogLevelEnum logLevel = LogLevelEnum.BASE_AND_TIME_AND_FIRST_AND_LAST_NODES_PARAMS;
    private boolean asyncLastNode = false;
    private String lastNodeName;

    public void addSyncNode(Class<? extends AbstractNode> node) {
        this.addSyncNode(node, null, null, null);
    }

    public void addSyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle) {
        this.addSyncNode(node, failHandle, null, null);
    }

    public void addSyncNode(Class<? extends AbstractNode> node, Long timeout) {
        this.addSyncNode(node, null, timeout, null);
    }

    public void addSyncNode(Class<? extends AbstractNode> node, AbstractNode.RetryTimesEnum retryTimes) {
        this.addSyncNode(node, null, null, retryTimes);
    }

    public void addSyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, Long timeout) {
        this.addSyncNode(node, failHandle, timeout, null);
    }

    public void addSyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, AbstractNode.RetryTimesEnum retryTimes) {
        this.addSyncNode(node, failHandle, null, retryTimes);
    }

    public void addSyncNode(Class<? extends AbstractNode> node, Long timeout, AbstractNode.RetryTimesEnum retryTimes) {
        this.addSyncNode(node, null, timeout, retryTimes);
    }

    public void addSyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, Long timeout, AbstractNode.RetryTimesEnum retryTimes) {
        this.add(node.getName(), node, failHandle, timeout, retryTimes);
        if (this.asyncLastNode) {
            this.asyncLastNode = false;
        }
    }

    public void addAsyncNode(Class<? extends AbstractNode> node) {
        this.addAsyncNode(node, null, null, null, false);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle) {
        this.addAsyncNode(node, failHandle, null, null, false);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, Long timeout) {
        this.addAsyncNode(node, null, timeout, null, false);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.RetryTimesEnum retryTimes) {
        this.addAsyncNode(node, null, null, retryTimes, false);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, Long timeout) {
        this.addAsyncNode(node, failHandle, timeout, null, false);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, AbstractNode.RetryTimesEnum retryTimes) {
        this.addAsyncNode(node, failHandle, null, retryTimes, false);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, Long timeout, AbstractNode.RetryTimesEnum retryTimes) {
        this.addAsyncNode(node, null, timeout, retryTimes, false);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, Long timeout, AbstractNode.RetryTimesEnum retryTimes) {
        this.addAsyncNode(node, failHandle, timeout, retryTimes, false);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, boolean restartAsyncGroup) {
        this.addAsyncNode(node, null, null, null, restartAsyncGroup);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, boolean restartAsyncGroup) {
        this.addAsyncNode(node, failHandle, null, null, restartAsyncGroup);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, Long timeout, boolean restartAsyncGroup) {
        this.addAsyncNode(node, null, timeout, null, restartAsyncGroup);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.RetryTimesEnum retryTimes, boolean restartAsyncGroup) {
        this.addAsyncNode(node, null, null, retryTimes, restartAsyncGroup);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, Long timeout, boolean restartAsyncGroup) {
        this.addAsyncNode(node, failHandle, timeout, null, restartAsyncGroup);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, AbstractNode.RetryTimesEnum retryTimes, boolean restartAsyncGroup) {
        this.addAsyncNode(node, failHandle, null, retryTimes, restartAsyncGroup);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, Long timeout, AbstractNode.RetryTimesEnum retryTimes, boolean restartAsyncGroup) {
        this.addAsyncNode(node, null, timeout, retryTimes, restartAsyncGroup);
    }

    public void addAsyncNode(Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, Long timeout, AbstractNode.RetryTimesEnum retryTimes, boolean restartAsyncGroup) {
        if (restartAsyncGroup && this.asyncLastNode) {
            this.asyncLastNode = false;
        }
        if (this.asyncLastNode) {
            this.add(this.lastNodeName, node, failHandle, timeout, retryTimes);
        } else {
            this.add(node.getName(), node, failHandle, timeout, retryTimes);
            this.asyncLastNode = true;
            this.lastNodeName = node.getName();
        }
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes) {
        this.addAsyncNodeList(nodes, null, null, null, false);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, AbstractNode.FailHandleEnum failHandle) {
        this.addAsyncNodeList(nodes, failHandle, null, null, false);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, Long timeout) {
        this.addAsyncNodeList(nodes, null, timeout, null, false);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, AbstractNode.RetryTimesEnum retryTimes) {
        this.addAsyncNodeList(nodes, null, null, retryTimes, false);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, AbstractNode.FailHandleEnum failHandle, Long timeout) {
        this.addAsyncNodeList(nodes, failHandle, timeout, null, false);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, AbstractNode.FailHandleEnum failHandle, AbstractNode.RetryTimesEnum retryTimes) {
        this.addAsyncNodeList(nodes, failHandle, null, retryTimes, false);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, Long timeout, AbstractNode.RetryTimesEnum retryTimes) {
        this.addAsyncNodeList(nodes, null, timeout, retryTimes, false);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, boolean restartAsyncGroup) {
        this.addAsyncNodeList(nodes, null, null, null, restartAsyncGroup);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, AbstractNode.FailHandleEnum failHandle, boolean restartAsyncGroup) {
        this.addAsyncNodeList(nodes, failHandle, null, null, restartAsyncGroup);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, Long timeout, boolean restartAsyncGroup) {
        this.addAsyncNodeList(nodes, null, timeout, null, restartAsyncGroup);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, AbstractNode.RetryTimesEnum retryTimes, boolean restartAsyncGroup) {
        this.addAsyncNodeList(nodes, null, null, retryTimes, restartAsyncGroup);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, AbstractNode.FailHandleEnum failHandle, Long timeout, boolean restartAsyncGroup) {
        this.addAsyncNodeList(nodes, failHandle, timeout, null, restartAsyncGroup);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, AbstractNode.FailHandleEnum failHandle, AbstractNode.RetryTimesEnum retryTimes, boolean restartAsyncGroup) {
        this.addAsyncNodeList(nodes, failHandle, null, retryTimes, restartAsyncGroup);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, Long timeout, AbstractNode.RetryTimesEnum retryTimes, boolean restartAsyncGroup) {
        this.addAsyncNodeList(nodes, null, timeout, retryTimes, restartAsyncGroup);
    }

    public void addAsyncNodeList(List<Class<? extends AbstractNode>> nodes, AbstractNode.FailHandleEnum failHandle, Long timeout, AbstractNode.RetryTimesEnum retryTimes, boolean restartAsyncGroup) {
        if (restartAsyncGroup && this.asyncLastNode) {
            this.asyncLastNode = false;
        }
        if (this.asyncLastNode) {
            for (Class<? extends AbstractNode> node : nodes) {
                this.add(this.lastNodeName, node, failHandle, timeout, retryTimes);
            }
        } else {
            String name = UUID.randomUUID().toString();
            for (Class<? extends AbstractNode> node : nodes) {
                this.add(name, node, failHandle, timeout, retryTimes);
            }
            this.asyncLastNode = true;
            this.lastNodeName = name;
        }
    }

    private void add(String groupName, Class<? extends AbstractNode> node, AbstractNode.FailHandleEnum failHandle, Long timeout, AbstractNode.RetryTimesEnum retryTimes) {
        AbstractNode abstractNode = NodeManager.getNode(node, failHandle, timeout, retryTimes);
        if (Objects.isNull(abstractNode)) {
            throw new ProcessException(ProcessException.MsgEnum.NODE_UNREGISTERED.getMsg() + "=" + node.getName());
        }
        if (this.containsKey(groupName)) {
            ((List)this.get(groupName)).add(abstractNode);
        } else {
            ArrayList<AbstractNode> list = new ArrayList<AbstractNode>();
            list.add(abstractNode);
            this.put(groupName, list);
        }
    }

    protected abstract void setNodeInfo();

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return ThreadPoolManager.COMMON_NODE_CHAIN_THREAD_POOL;
    }

    public void execute(NodeChainContext<?> nodeChainContext) {
        this.execute(nodeChainContext, this.getThreadPoolExecutor());
    }

    public void execute(NodeChainContext<?> nodeChainContext, ThreadPoolExecutor threadPoolExecutor) {
        AbstractNode.LogLevelEnum nodeLogLevel = null;
        LogLevelEnum nodeChainLogLevel = this.logLevel;
        boolean baseAndTimeAndFirstAndLastNodesParamsLogLevel = false;
        if (LogLevelEnum.NO.getCode().equals(nodeChainLogLevel.getCode())) {
            nodeLogLevel = AbstractNode.LogLevelEnum.NO;
        } else if (LogLevelEnum.BASE.getCode().equals(nodeChainLogLevel.getCode())) {
            nodeLogLevel = AbstractNode.LogLevelEnum.BASE;
        } else if (LogLevelEnum.BASE_AND_TIME.getCode().equals(nodeChainLogLevel.getCode())) {
            nodeLogLevel = AbstractNode.LogLevelEnum.BASE_AND_TIME;
        } else if (LogLevelEnum.BASE_AND_TIME_AND_FIRST_AND_LAST_NODES_PARAMS.getCode().equals(nodeChainLogLevel.getCode())) {
            baseAndTimeAndFirstAndLastNodesParamsLogLevel = true;
        } else {
            nodeLogLevel = LogLevelEnum.BASE_AND_TIME_AND_ALL_NODES_PARAMS.getCode().equals(nodeChainLogLevel.getCode()) ? AbstractNode.LogLevelEnum.BASE_AND_TIME_AND_PARAMS : AbstractNode.LogLevelEnum.BASE_AND_TIME;
        }
        int count = 1;
        for (Map.Entry nodesEntry : this.entrySet()) {
            if (baseAndTimeAndFirstAndLastNodesParamsLogLevel) {
                nodeLogLevel = count == 1 || count == this.entrySet().size() ? AbstractNode.LogLevelEnum.BASE_AND_TIME_AND_PARAMS : AbstractNode.LogLevelEnum.BASE_AND_TIME;
                ++count;
            }
            Map<Future<Void>, AbstractNode> futureMap = this.getFutureMap(nodeChainContext, threadPoolExecutor, (List)nodesEntry.getValue(), nodeLogLevel);
            this.waitFutureExecute(nodeChainContext, threadPoolExecutor, futureMap, new HashMap<String, Integer>(), nodeLogLevel);
            if (!Objects.nonNull(nodeChainContext.getExNextNodeGroup()) || nodeChainContext.getExNextNodeGroup().booleanValue()) continue;
            return;
        }
    }

    private Map<Future<Void>, AbstractNode> getFutureMap(NodeChainContext<?> nodeChainContext, ThreadPoolExecutor threadPoolExecutor, List<AbstractNode> abstractNodeList, AbstractNode.LogLevelEnum nodeLogLevel) {
        HashMap<Future<Void>, AbstractNode> futureMap = new HashMap<Future<Void>, AbstractNode>();
        for (AbstractNode abstractNode : abstractNodeList) {
            String nodeChainName = this.getClass().getName();
            if (Objects.nonNull(threadPoolExecutor)) {
                futureMap.put(CompletableFuture.supplyAsync(() -> {
                    abstractNode.execute(nodeChainContext, nodeLogLevel, nodeChainName);
                    return null;
                }, threadPoolExecutor), abstractNode);
                continue;
            }
            if (Objects.nonNull(this.getThreadPoolExecutor())) {
                futureMap.put(CompletableFuture.supplyAsync(() -> {
                    abstractNode.execute(nodeChainContext, nodeLogLevel, nodeChainName);
                    return null;
                }, this.getThreadPoolExecutor()), abstractNode);
                continue;
            }
            throw new ProcessException(ProcessException.MsgEnum.NODE_CHAIN_THREAD_POOL_EXECUTOR_NOT_NULL.getMsg() + "=" + nodeChainName);
        }
        return futureMap;
    }

    private void waitFutureExecute(NodeChainContext<?> nodeChainContext, ThreadPoolExecutor threadPoolExecutor, Map<Future<Void>, AbstractNode> futureMap, Map<String, Integer> retriedMap, AbstractNode.LogLevelEnum nodeLogLevel) {
        for (Map.Entry<Future<Void>, AbstractNode> futureEntry : futureMap.entrySet()) {
            ProcessException processException = null;
            Future<Void> future = futureEntry.getKey();
            AbstractNode abstractNode = futureEntry.getValue();
            Long timeout = abstractNode.getTimeout();
            Integer failHandle = abstractNode.getFailHandle().getCode();
            Integer retryTimes = abstractNode.getRetryTimes().getCode();
            String nodeName = abstractNode.getClass().getName();
            try {
                future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                boolean cancel = future.cancel(true);
                log.error("nodeChainLog {} execute timeout nodeName={} timeout={} cancel={}", new Object[]{nodeChainContext.getLogStr(), nodeName, timeout, cancel});
                processException = new ProcessException(ProcessException.MsgEnum.NODE_TIMEOUT.getMsg() + "=" + nodeName);
            }
            catch (ProcessException e) {
                log.error("nodeChainLog {} execute fail nodeName={} msg={}", new Object[]{nodeChainContext.getLogStr(), nodeName, this.getExceptionLog(e)});
                processException = e;
            }
            catch (BusinessException e) {
                log.error("nodeChainLog {} execute business fail nodeName={} msg={}", new Object[]{nodeChainContext.getLogStr(), nodeName, this.getExceptionLog(e)});
                throw e;
            }
            catch (Exception e) {
                String exceptionLog = this.getExceptionLog(e);
                log.error("nodeChainLog {} execute fail nodeName={} msg={}", new Object[]{nodeChainContext.getLogStr(), nodeName, exceptionLog});
                processException = new ProcessException(ProcessException.MsgEnum.NODE_UNKNOWN.getMsg() + "=" + nodeName + " error=" + exceptionLog);
            }
            if (!Objects.nonNull(processException)) continue;
            if (AbstractNode.FailHandleEnum.INTERRUPT.getCode().equals(failHandle)) {
                log.error("nodeChainLog {} execute fail interrupt nodeName={} timeout={}", new Object[]{nodeChainContext.getLogStr(), nodeName, timeout});
                throw processException;
            }
            if (AbstractNode.FailHandleEnum.ABANDON.getCode().equals(failHandle)) {
                log.error("nodeChainLog {} execute fail abandon nodeName={} timeout={}", new Object[]{nodeChainContext.getLogStr(), nodeName, timeout});
                continue;
            }
            if (AbstractNode.FailHandleEnum.RETRY.getCode().equals(failHandle)) {
                Map<Future<Void>, AbstractNode> retryFutureMap;
                log.error("nodeChainLog {} execute fail retry start nodeName={} timeout={} retryTimes={}", new Object[]{nodeChainContext.getLogStr(), nodeName, timeout, retryTimes});
                if (!AbstractNode.RetryTimesEnum.containsCode(retryTimes).booleanValue()) continue;
                ArrayList<AbstractNode> retryAbstractNodeList = new ArrayList<AbstractNode>();
                retryAbstractNodeList.add(abstractNode);
                if (retriedMap.containsKey(nodeName)) {
                    if (retriedMap.get(nodeName) >= retryTimes) {
                        log.error("nodeChainLog {} execute fail retry fail nodeName={} timeout={} retryTimes={} retriedTimes={}", new Object[]{nodeChainContext.getLogStr(), nodeName, timeout, retryTimes, retriedMap.get(nodeName)});
                        throw processException;
                    }
                    log.info("nodeChainLog {} execute fail retry nodeName={} timeout={} retryTimes={} retriedTimes={}", new Object[]{nodeChainContext.getLogStr(), nodeName, timeout, retryTimes, retriedMap.get(nodeName) + 1});
                    retriedMap.put(nodeName, retriedMap.get(nodeName) + 1);
                    retryFutureMap = this.getFutureMap(nodeChainContext, threadPoolExecutor, retryAbstractNodeList, nodeLogLevel);
                    this.waitFutureExecute(nodeChainContext, threadPoolExecutor, retryFutureMap, retriedMap, nodeLogLevel);
                } else {
                    log.info("nodeChainLog {} execute fail retry nodeName={} timeout={} retryTimes={} retriedTimes=1", new Object[]{nodeChainContext.getLogStr(), nodeName, timeout, retryTimes});
                    retriedMap.put(nodeName, 1);
                    retryFutureMap = this.getFutureMap(nodeChainContext, threadPoolExecutor, retryAbstractNodeList, nodeLogLevel);
                    this.waitFutureExecute(nodeChainContext, threadPoolExecutor, retryFutureMap, retriedMap, nodeLogLevel);
                }
                log.info("nodeChainLog {} execute fail retry success nodeName={} timeout={} retryTimes={} retriedTimes={}", new Object[]{nodeChainContext.getLogStr(), nodeName, timeout, retryTimes, retriedMap.get(nodeName)});
                continue;
            }
            log.error("nodeChainLog {} execute fail default interrupt nodeName={} timeout={}", new Object[]{nodeChainContext.getLogStr(), nodeName, timeout});
            throw processException;
        }
    }

    private String getExceptionLog(Exception e) {
        if (Objects.nonNull(e)) {
            StackTraceElement[] stackTrace;
            StringBuilder stringBuffer = new StringBuilder("\n");
            if (Objects.nonNull(e.getMessage())) {
                stringBuffer.append(e.getMessage()).append("\n");
            }
            if (Objects.nonNull(e.getCause()) && Objects.nonNull(stackTrace = e.getCause().getStackTrace()) && stackTrace.length > 0) {
                for (StackTraceElement stackTraceElement : stackTrace) {
                    stringBuffer.append(stackTraceElement.toString()).append("\n");
                }
                return stringBuffer.toString();
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractNodeChain)) {
            return false;
        }
        AbstractNodeChain other = (AbstractNodeChain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAsyncLastNode() != other.isAsyncLastNode()) {
            return false;
        }
        LogLevelEnum this$logLevel = this.getLogLevel();
        LogLevelEnum other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !((Object)((Object)this$logLevel)).equals((Object)other$logLevel)) {
            return false;
        }
        String this$lastNodeName = this.getLastNodeName();
        String other$lastNodeName = other.getLastNodeName();
        return !(this$lastNodeName == null ? other$lastNodeName != null : !this$lastNodeName.equals(other$lastNodeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractNodeChain;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAsyncLastNode() ? 79 : 97);
        LogLevelEnum $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : ((Object)((Object)$logLevel)).hashCode());
        String $lastNodeName = this.getLastNodeName();
        result = result * 59 + ($lastNodeName == null ? 43 : $lastNodeName.hashCode());
        return result;
    }

    public LogLevelEnum getLogLevel() {
        return this.logLevel;
    }

    public boolean isAsyncLastNode() {
        return this.asyncLastNode;
    }

    public String getLastNodeName() {
        return this.lastNodeName;
    }

    public void setLogLevel(LogLevelEnum logLevel) {
        this.logLevel = logLevel;
    }

    public void setAsyncLastNode(boolean asyncLastNode) {
        this.asyncLastNode = asyncLastNode;
    }

    public void setLastNodeName(String lastNodeName) {
        this.lastNodeName = lastNodeName;
    }

    @Override
    public String toString() {
        return "AbstractNodeChain(logLevel=" + (Object)((Object)this.getLogLevel()) + ", asyncLastNode=" + this.isAsyncLastNode() + ", lastNodeName=" + this.getLastNodeName() + ")";
    }

    public static enum LogLevelEnum {
        NO(1, "\u4e0d\u6253\u5370"),
        BASE(2, "\u6253\u5370\u57fa\u672c\u4fe1\u606f"),
        BASE_AND_TIME(3, "\u6253\u5370\u57fa\u672c\u4fe1\u606f\u548c\u8017\u65f6"),
        BASE_AND_TIME_AND_FIRST_AND_LAST_NODES_PARAMS(4, "\u6253\u5370\u57fa\u672c\u4fe1\u606f\u548c\u8017\u65f6\u548c\u7b2c\u4e00\u4e2a\u548c\u6700\u540e\u4e00\u4e2a\u8282\u70b9\u53c2\u6570"),
        BASE_AND_TIME_AND_ALL_NODES_PARAMS(5, "\u6253\u5370\u57fa\u672c\u4fe1\u606f\u548c\u8017\u65f6\u548c\u6240\u6709\u8282\u70b9\u53c2\u6570");

        private final Integer code;
        private final String msg;
        private static final Map<Integer, LogLevelEnum> MAP;

        public static Boolean containsCode(Integer code) {
            return MAP.containsKey(code);
        }

        public static String getMsg(Integer code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code).getMsg();
        }

        public static LogLevelEnum getEnum(Integer code) {
            if (!MAP.containsKey(code)) {
                return null;
            }
            return MAP.get(code);
        }

        private LogLevelEnum(Integer code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        static {
            MAP = Arrays.stream(LogLevelEnum.values()).collect(Collectors.toMap(LogLevelEnum::getCode, obj -> obj));
        }
    }
}

