/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.http.interceptors.ResponseLengthValidationInterceptorKt;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u0096\u0001\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0010R\"\u0010\u0011\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0010\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/LengthValidatingSource;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "source", "", "expectedContentLength", "<init>", "(Laws/smithy/kotlin/runtime/io/SdkSource;J)V", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "sink", "limit", "read", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;J)J", "", "close", "()V", "Laws/smithy/kotlin/runtime/io/SdkSource;", "J", "bytesReceived", "getBytesReceived", "()J", "setBytesReceived", "(J)V", "http-client"})
final class LengthValidatingSource
implements SdkSource {
    @NotNull
    private final SdkSource source;
    private final long expectedContentLength;
    private long bytesReceived;

    public LengthValidatingSource(@NotNull SdkSource source, long expectedContentLength) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.expectedContentLength = expectedContentLength;
    }

    public final long getBytesReceived() {
        return this.bytesReceived;
    }

    public final void setBytesReceived(long l) {
        this.bytesReceived = l;
    }

    public long read(@NotNull SdkBuffer sink, long limit) {
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long it = l = this.source.read(sink, limit);
        boolean bl = false;
        if (it == -1L || this.bytesReceived > this.expectedContentLength) {
            ResponseLengthValidationInterceptorKt.access$validateContentLength(this.expectedContentLength, this.bytesReceived);
        } else {
            this.bytesReceived += it;
        }
        return l;
    }

    public void close() {
        this.source.close();
    }
}

