/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.http.interceptors.FlexibleChecksumsResponseInterceptorKt;
import aws.smithy.kotlin.runtime.io.HashingSource;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u0096\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012\u00a8\u0006\u0013"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/ChecksumValidatingSource;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "", "expectedChecksum", "Laws/smithy/kotlin/runtime/io/HashingSource;", "hashingSource", "<init>", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/io/HashingSource;)V", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "sink", "", "limit", "read", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;J)J", "", "close", "()V", "Ljava/lang/String;", "Laws/smithy/kotlin/runtime/io/HashingSource;", "http-client"})
final class ChecksumValidatingSource
implements SdkSource {
    @NotNull
    private final String expectedChecksum;
    @NotNull
    private final HashingSource hashingSource;

    public ChecksumValidatingSource(@NotNull String expectedChecksum, @NotNull HashingSource hashingSource) {
        Intrinsics.checkNotNullParameter((Object)expectedChecksum, (String)"expectedChecksum");
        Intrinsics.checkNotNullParameter((Object)hashingSource, (String)"hashingSource");
        this.expectedChecksum = expectedChecksum;
        this.hashingSource = hashingSource;
    }

    public long read(@NotNull SdkBuffer sink, long limit) {
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long it = l = this.hashingSource.read(sink, limit);
        boolean bl = false;
        if (it == -1L) {
            FlexibleChecksumsResponseInterceptorKt.access$validateAndThrow(this.expectedChecksum, Base64Kt.encodeBase64String((byte[])this.hashingSource.digest()));
        }
        return l;
    }

    public void close() {
        this.hashingSource.close();
    }
}

