/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.data;

import java.io.Serializable;

public class CategoryDirective
implements Serializable {
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARN = "WARN";
    public static final String ERROR = "ERROR";
    private String m_name;
    private final String m_priority;
    private final String m_target;

    public CategoryDirective(String name) {
        this(name, null, null);
    }

    public CategoryDirective(String name, String priority) {
        this(name, priority, null);
    }

    public CategoryDirective(String name, String priority, String target) {
        this.m_name = name;
        this.m_target = target;
        this.m_priority = priority != null ? priority.trim().toUpperCase() : null;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPriority() {
        return this.m_priority;
    }

    public String getTarget() {
        return this.m_target;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof CategoryDirective)) {
            return false;
        }
        CategoryDirective test = (CategoryDirective)other;
        return this.equalName(test.getName()) && this.equalPriority(test.getPriority()) && this.equalTarget(test.getTarget());
    }

    private boolean equalName(String other) {
        if (this.m_name == null) {
            return other == null;
        }
        return this.m_name.equals(other);
    }

    private boolean equalPriority(String other) {
        if (this.m_priority == null) {
            return other == null;
        }
        return this.m_priority.equals(other);
    }

    private boolean equalTarget(String other) {
        if (this.m_target == null) {
            return other == null;
        }
        return this.m_target.equals(other);
    }

    public int hashCode() {
        int hash = this.m_name.hashCode();
        hash >>>= 13;
        if (this.m_priority != null) {
            hash ^= this.m_priority.hashCode();
        }
        hash >>>= 5;
        if (this.m_target != null) {
            hash ^= this.m_target.hashCode();
        }
        return hash;
    }
}

